/*
 * Decompiled with CFR 0.152.
 */
package mod.reborn.server.item;

import java.util.Collections;
import java.util.LinkedList;
import mod.reborn.RebornMod;
import mod.reborn.server.dinosaur.Dinosaur;
import mod.reborn.server.entity.DinosaurEntity;
import mod.reborn.server.entity.EntityHandler;
import mod.reborn.server.item.DNAContainerItem;
import mod.reborn.server.tab.TabHandler;
import mod.reborn.server.util.LangUtils;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class HatchedEggItem
extends DNAContainerItem {
    public HatchedEggItem() {
        this.func_77627_a(true);
        this.func_77625_d(1);
        this.func_77637_a(TabHandler.CREATIVE);
    }

    public String func_77653_i(ItemStack stack) {
        Dinosaur dinosaur = this.getDinosaur(stack);
        return LangUtils.translate(dinosaur.givesDirectBirth() ? "item.gestated.name" : "item.hatched_egg.name", new Object[0]).replace("{dino}", LangUtils.getDinoName(dinosaur));
    }

    public Dinosaur getDinosaur(ItemStack stack) {
        return EntityHandler.getDinosaurById(stack.func_77960_j());
    }

    public boolean getGender(EntityPlayer player, ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        boolean gender = player.field_70170_p.field_73012_v.nextBoolean();
        if (nbt == null) {
            nbt = new NBTTagCompound();
        }
        if (nbt.func_74764_b("Gender")) {
            gender = nbt.func_74767_n("Gender");
        } else {
            nbt.func_74757_a("Gender", gender);
        }
        stack.func_77982_d(nbt);
        return gender;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subtypes) {
        LinkedList<Dinosaur> dinosaurs = new LinkedList<Dinosaur>(EntityHandler.getDinosaurs().values());
        Collections.sort(dinosaurs);
        if (this.func_194125_a(tab)) {
            for (Dinosaur dinosaur : dinosaurs) {
                if (!dinosaur.shouldRegister()) continue;
                subtypes.add((Object)new ItemStack((Item)this, 1, EntityHandler.getDinosaurId(dinosaur)));
            }
        }
    }

    @Override
    public int getContainerId(ItemStack stack) {
        return EntityHandler.getDinosaurId(this.getDinosaur(stack));
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        pos = pos.func_177972_a(side);
        ItemStack stack = player.func_184586_b(hand);
        if (side == EnumFacing.EAST || side == EnumFacing.WEST) {
            hitX = 1.0f - hitX;
        } else if (side == EnumFacing.NORTH || side == EnumFacing.SOUTH) {
            hitZ = 1.0f - hitZ;
        }
        if (player.func_175151_a(pos, side, stack)) {
            if (!world.field_72995_K) {
                Dinosaur dinosaur = this.getDinosaur(stack);
                try {
                    DinosaurEntity entity = dinosaur.getDinosaurClass().getDeclaredConstructor(World.class).newInstance(world);
                    entity.func_70107_b((float)pos.func_177958_n() + hitX, pos.func_177956_o(), (float)pos.func_177952_p() + hitZ);
                    entity.setAge(0);
                    entity.setGenetics(HatchedEggItem.getGeneticCode(player, stack));
                    entity.setDNAQuality(HatchedEggItem.getDNAQuality(player, stack));
                    entity.setMale(this.getGender(player, stack));
                    if (!player.func_70093_af()) {
                        entity.setOwner(player);
                    }
                    world.func_72838_d((Entity)entity);
                    if (!player.field_71075_bZ.field_75098_d) {
                        stack.func_190918_g(1);
                    }
                }
                catch (ReflectiveOperationException e) {
                    RebornMod.getLogger().warn("Failed to spawn dinosaur from hatched egg", (Throwable)e);
                }
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }
}

