/*
 * Decompiled with CFR 0.152.
 */
package mod.reborn.server.item;

import com.google.gson.Gson;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import mod.reborn.RebornMod;
import mod.reborn.server.tab.TabHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class JournalItem
extends Item {
    public JournalItem() {
        this.func_77627_a(true);
        this.func_77637_a(TabHandler.ITEMS);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (world.field_72995_K) {
            RebornMod.PROXY.openJournal(JournalType.get(stack.func_77960_j()));
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        JournalType type = JournalType.get(stack.func_77960_j());
        tooltip.add(I18n.func_74838_a((String)("journal." + type.getIdentifier().func_110623_a() + ".name")));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            for (JournalType type : JournalType.values()) {
                items.add((Object)new ItemStack((Item)this, 1, type.getMetadata()));
            }
        }
    }

    public static class Content {
        private String identifier;
        private String[][] entries;

        public Content(String identifier, String[][] entries) {
            this.identifier = identifier;
            this.entries = entries;
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public String[][] getEntries() {
            return this.entries;
        }
    }

    public static enum JournalType {
        CHEF_ALEJANDRO(0, new ResourceLocation("rebornmod", "chef_alejandro")),
        DENNIS_NEDRY(1, new ResourceLocation("rebornmod", "dennis_nedry")),
        DR_GERRY_HARDING(2, new ResourceLocation("rebornmod", "dr_gerry_harding")),
        DR_HENRY_WU(3, new ResourceLocation("rebornmod", "dr_henry_wu")),
        DR_LAURA_SORKIN(4, new ResourceLocation("rebornmod", "dr_laura_sorkin")),
        ED_REGIS(5, new ResourceLocation("rebornmod", "ed_regis")),
        JOHN_HAMMOND(6, new ResourceLocation("rebornmod", "john_hammond")),
        RAY_ARNOLD(7, new ResourceLocation("rebornmod", "ray_arnold")),
        ROBERT_MULDOON(8, new ResourceLocation("rebornmod", "robert_muldoon"));

        public static final JournalType[] VALUES;
        private final int metadata;
        private final ResourceLocation identifier;
        private final ResourceLocation location;
        @SideOnly(value=Side.CLIENT)
        private Content content;

        private JournalType(int metadata, ResourceLocation identifier) {
            this.metadata = metadata;
            this.identifier = identifier;
            this.location = new ResourceLocation(identifier.func_110624_b(), "journal_entries/" + identifier.func_110623_a() + ".json");
        }

        public int getMetadata() {
            return this.metadata;
        }

        @SideOnly(value=Side.CLIENT)
        public Content getContent() {
            if (this.content == null) {
                try (InputStream input = Minecraft.func_71410_x().func_110442_L().func_110536_a(this.location).func_110527_b();){
                    this.content = (Content)new Gson().fromJson((Reader)new InputStreamReader(input), Content.class);
                }
                catch (IOException e) {
                    String[][] entries = new String[][]{{"Failed to load journal entries"}};
                    return new Content("rebornmod:error", entries);
                }
            }
            return this.content;
        }

        public ResourceLocation getIdentifier() {
            return this.identifier;
        }

        public ResourceLocation getLocation() {
            return this.location;
        }

        public static JournalType get(int metadata) {
            if (metadata >= 0 && metadata < VALUES.length) {
                return VALUES[metadata];
            }
            return CHEF_ALEJANDRO;
        }

        static {
            VALUES = new JournalType[JournalType.values().length];
            JournalType[] journalTypeArray = JournalType.values();
            int n = journalTypeArray.length;
            for (int i = 0; i < n; ++i) {
                JournalType type;
                JournalType.VALUES[type.getMetadata()] = type = journalTypeArray[i];
            }
        }
    }
}

