/*
 * Decompiled with CFR 0.152.
 */
package mod.reborn.server.item;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import mod.reborn.server.api.GrindableItem;
import mod.reborn.server.item.ItemHandler;
import mod.reborn.server.plant.Plant;
import mod.reborn.server.plant.PlantHandler;
import mod.reborn.server.tab.TabHandler;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import org.apache.commons.lang3.tuple.Pair;

public class PlantFossilItem
extends Item
implements GrindableItem {
    public PlantFossilItem() {
        this.func_77637_a(TabHandler.PLANTS);
    }

    @Override
    public boolean isGrindable(ItemStack stack) {
        return true;
    }

    @Override
    public ItemStack getGroundItem(ItemStack stack, Random random) {
        NBTTagCompound tag = stack.func_77978_p();
        int outputType = random.nextInt(4);
        if (outputType == 3) {
            List<Plant> prehistoricPlants = PlantHandler.getPrehistoricPlants();
            ItemStack output = new ItemStack((Item)ItemHandler.PLANT_SOFT_TISSUE, 1, PlantHandler.getPlantId(prehistoricPlants.get(random.nextInt(prehistoricPlants.size()))));
            output.func_77982_d(tag);
            return output;
        }
        if (outputType < 2) {
            return new ItemStack(Items.field_151100_aR, 1, 15);
        }
        return new ItemStack(Items.field_151145_ak);
    }

    @Override
    public List<Pair<Float, ItemStack>> getChancedOutputs(ItemStack inputItem) {
        ArrayList list = Lists.newArrayList();
        List<Plant> prehistoricPlants = PlantHandler.getPrehistoricPlants();
        NBTTagCompound tag = inputItem.func_77978_p();
        float single = 25.0f;
        float plantSingle = single / (float)prehistoricPlants.size();
        for (Plant plant : prehistoricPlants) {
            ItemStack output = new ItemStack((Item)ItemHandler.PLANT_SOFT_TISSUE, 1, PlantHandler.getPlantId(plant));
            output.func_77982_d(tag);
            list.add(Pair.of((Object)Float.valueOf(plantSingle), (Object)output));
        }
        list.add(Pair.of((Object)Float.valueOf(50.0f), (Object)new ItemStack(Items.field_151100_aR, 1, 15)));
        list.add(Pair.of((Object)Float.valueOf(single), (Object)new ItemStack(Items.field_151145_ak)));
        return list;
    }
}

