/*
 * Decompiled with CFR 0.152.
 */
package mod.reborn.server.item;

import java.util.List;
import javax.annotation.Nullable;
import mod.reborn.server.entity.animal.EntityShark;
import mod.reborn.server.item.DNAContainerItem;
import net.minecraft.block.BlockLiquid;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;

public class SharkEggItem
extends DNAContainerItem {
    public SharkEggItem() {
        this.func_77625_d(1);
        this.func_77637_a(CreativeTabs.field_78026_f);
    }

    public String func_77653_i(ItemStack stack) {
        String s = ("" + I18n.func_74838_a((String)"item.monsterPlacer.name")).trim();
        String s1 = EntityList.func_191302_a((ResourceLocation)new ResourceLocation("rebornmod", "entities.shark"));
        if (s1 != null) {
            s = s + " " + I18n.func_74838_a((String)("entity." + s1 + ".name"));
        }
        return s;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (world.field_72995_K) {
            return new ActionResult(EnumActionResult.PASS, (Object)itemstack);
        }
        RayTraceResult raytraceresult = this.func_77621_a(world, player, true);
        if (raytraceresult != null && raytraceresult.field_72313_a == RayTraceResult.Type.BLOCK) {
            BlockPos blockpos = raytraceresult.func_178782_a();
            if (!(world.func_180495_p(blockpos).func_177230_c() instanceof BlockLiquid)) {
                return new ActionResult(EnumActionResult.PASS, (Object)itemstack);
            }
            if (world.func_175660_a(player, blockpos) && player.func_175151_a(blockpos, raytraceresult.field_178784_b, itemstack)) {
                EntityShark entity = SharkEggItem.spawnCreature(world, (double)blockpos.func_177958_n() + 0.5, (double)blockpos.func_177956_o() + 0.5, (double)blockpos.func_177952_p() + 0.5);
                if (entity == null) {
                    return new ActionResult(EnumActionResult.PASS, (Object)itemstack);
                }
                if (entity instanceof EntityLivingBase && itemstack.func_82837_s()) {
                    entity.func_96094_a(itemstack.func_82833_r());
                }
                entity.isSpawnedByEgg = true;
                if (!player.field_71075_bZ.field_75098_d) {
                    itemstack.func_190918_g(1);
                }
                return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
            }
            return new ActionResult(EnumActionResult.FAIL, (Object)itemstack);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)itemstack);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K) {
            return EnumActionResult.PASS;
        }
        ItemStack itemstack = player.func_184586_b(hand);
        BlockPos blockpos = pos.func_177972_a(facing);
        double d0 = this.getYOffset(worldIn, blockpos);
        EntityShark entity = SharkEggItem.spawnCreature(worldIn, (double)blockpos.func_177958_n() + 0.5, (double)blockpos.func_177956_o() + d0, (double)blockpos.func_177952_p() + 0.5);
        if (entity != null) {
            if (itemstack.func_82837_s()) {
                entity.func_96094_a(itemstack.func_82833_r());
            }
            if (!player.field_71075_bZ.field_75098_d) {
                itemstack.func_190918_g(1);
            }
            worldIn.func_72838_d((Entity)entity);
        }
        return EnumActionResult.SUCCESS;
    }

    protected double getYOffset(World world, BlockPos pos) {
        AxisAlignedBB axisalignedbb = new AxisAlignedBB(pos).func_72321_a(0.0, -1.0, 0.0);
        List list = world.func_184144_a((Entity)null, axisalignedbb);
        if (list.isEmpty()) {
            return 0.0;
        }
        double d0 = axisalignedbb.field_72338_b;
        for (AxisAlignedBB axisalignedbb1 : list) {
            d0 = Math.max(axisalignedbb1.field_72337_e, d0);
        }
        return d0 - (double)pos.func_177956_o();
    }

    @Nullable
    public static EntityShark spawnCreature(World worldIn, double x, double y, double z) {
        EntityShark shark = new EntityShark(worldIn);
        shark.func_70012_b(x, y, z, MathHelper.func_76142_g((float)(worldIn.field_73012_v.nextFloat() * 360.0f)), 0.0f);
        shark.field_70759_as = shark.field_70177_z;
        shark.field_70761_aq = shark.field_70177_z;
        shark.isSpawnedByEgg = true;
        return shark;
    }
}

