/*
 * Decompiled with CFR 0.152.
 */
package mod.reborn.server.item.guns;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import mod.reborn.server.entity.item.BulletEntity;
import mod.reborn.server.item.ItemHandler;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;

public class Gun
extends Item {
    private int amount;
    private float speed;
    private float inaccuracy;
    private float pitchoffset;
    private SoundEvent fire;
    private SoundEvent empty;
    private SoundEvent reloadsound;
    private int reloadcooldown;
    private int shotcooldown;
    private int damage;
    private static int MAX_CARRY_SIZE;

    public Gun(CreativeTabs creativeTab, int AmountPerShot, SoundEvent EmptySound, SoundEvent FireSound, SoundEvent ReloadSound, int clipSize, int reloadcooldown, int shotcooldown, float speed, float inaccuracy, float pitchofsset, int damage) {
        this.func_77637_a(creativeTab);
        this.func_77625_d(1);
        this.amount = AmountPerShot;
        this.fire = FireSound;
        this.empty = EmptySound;
        this.reloadsound = ReloadSound;
        this.setClipSize(clipSize);
        this.reloadcooldown = reloadcooldown;
        this.shotcooldown = shotcooldown;
        this.speed = speed;
        this.inaccuracy = inaccuracy;
        this.pitchoffset = pitchofsset;
        this.damage = damage;
    }

    private void setClipSize(int clipSize) {
        MAX_CARRY_SIZE = clipSize;
    }

    public void setAmount(int amount) {
        this.amount = amount;
    }

    public float setSpeed(float speed) {
        this.speed = speed;
        return this.speed;
    }

    public float getSpeed() {
        return this.speed;
    }

    public int getAmount() {
        return this.amount;
    }

    public SoundEvent getFireSound() {
        return this.fire;
    }

    public SoundEvent getEmptySound() {
        return this.empty;
    }

    public SoundEvent getReloadsound() {
        return this.reloadsound;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        SoundEvent event = null;
        int amount = this.amount;
        ItemStack bullet = Gun.getBullet(itemstack);
        if (bullet.func_190926_b()) {
            ArrayList list = Lists.newArrayList((Iterable)playerIn.field_71069_bz.field_75151_b);
            Collections.reverse(list);
            if (Gun.setBullet(itemstack, list.stream().map(Slot::func_75211_c).filter(stack -> stack.func_77973_b() == ItemHandler.BULLET).findFirst().orElse(ItemStack.field_190927_a))) {
                event = this.getReloadsound();
                Gun.setCooldown(playerIn, this, this.reloadcooldown);
            } else if (bullet.func_190916_E() <= this.getAmount()) {
                event = this.getEmptySound();
            }
        } else if (!worldIn.field_72995_K) {
            for (int i = 0; i < this.getAmount(); ++i) {
                this.shoot(playerIn, worldIn, handIn, amount);
                if (playerIn.field_71075_bZ.field_75098_d) continue;
                bullet.func_190918_g(1);
            }
            Gun.setCooldown(playerIn, this, 15);
            Gun.setBullet(itemstack, bullet);
            event = this.getFireSound();
        }
        if (event != null) {
            worldIn.func_184148_a(null, playerIn.field_70165_t, playerIn.field_70163_u, playerIn.field_70161_v, event, SoundCategory.NEUTRAL, 0.5f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
        }
        playerIn.func_71029_a(StatList.func_188057_b((Item)this));
        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
    }

    public void shoot(EntityPlayer playerIn, World worldIn, EnumHand handIn, int amount) {
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        ItemStack bullet = Gun.getBullet(itemstack);
        BulletEntity bulletEntity = new BulletEntity(worldIn, (EntityLivingBase)playerIn, bullet);
        bulletEntity.setDamage(this.damage);
        bulletEntity.func_184538_a((Entity)playerIn, playerIn.field_70125_A, playerIn.field_70177_z, this.pitchoffset, this.speed, this.inaccuracy);
        worldIn.func_72838_d((Entity)bulletEntity);
    }

    public static void setCooldown(EntityPlayer player, Item item, int cooldown) {
        player.func_184811_cZ().func_185145_a(item, cooldown);
    }

    public static ItemStack getBullet(ItemStack gun) {
        NBTTagCompound nbt = gun.func_190925_c("bullets");
        ItemStack stack = new ItemStack(nbt.func_74775_l("itemstack"));
        stack.func_190920_e(Math.min(stack.func_190916_E(), MAX_CARRY_SIZE));
        return stack;
    }

    public static boolean setBullet(ItemStack gun, ItemStack bullet) {
        boolean hadItem = !bullet.func_190926_b();
        ItemStack bullet2 = bullet.func_77979_a(MAX_CARRY_SIZE);
        gun.func_190925_c("bullets").func_74782_a("itemstack", (NBTBase)bullet2.serializeNBT());
        return hadItem;
    }
}

