/*
 * Decompiled with CFR 0.152.
 */
package mod.reborn.server.maps;

import com.google.common.collect.Lists;
import java.util.Random;
import mod.reborn.server.world.structure.StructureUtils;
import net.minecraft.init.Biomes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class MapUtils {
    private static final int MIN_DISTANCE = 5000;
    private static final int MAX_DISTANCE = 10000;
    private static BlockPos cachedPos = null;

    public static BlockPos getVisitorCenterPosition() {
        if (cachedPos == null) {
            cachedPos = MapUtils.generatePosition();
        }
        return cachedPos;
    }

    public static BlockPos getIslaSornaLabPosition() {
        StructureUtils.StructureData data = StructureUtils.getStructureData();
        BlockPos pos = data.getIslaSornaLabPosition();
        if (pos == null) {
            pos = MapUtils.generateLabPosition();
            data.setIslaSornaLabPosition(pos);
        }
        return pos;
    }

    public static BlockPos getJPSanDiegoPosition() {
        StructureUtils.StructureData data = StructureUtils.getStructureData();
        BlockPos pos = data.getJPSanDiegoPosition();
        if (pos == null) {
            pos = MapUtils.generateDiegoPosition();
            data.setJPSanDiegoPosition(pos);
        }
        return pos;
    }

    private static BlockPos generatePosition() {
        WorldServer world = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(0);
        Random worldRandom = new Random(world.func_72905_C());
        int range = 5000;
        BlockPos pos = null;
        for (int i = 0; i < 10000; ++i) {
            pos = new BlockPos(worldRandom.nextInt(range) + 5000, 0, worldRandom.nextInt(range) + 5000);
            if (!Lists.newArrayList((Object[])new Biome[]{Biomes.field_185446_X, Biomes.field_150574_L, Biomes.field_185447_Y, Biomes.field_150588_X, Biomes.field_185435_ag}).contains(world.func_180494_b(pos))) continue;
            return pos;
        }
        return pos;
    }

    private static BlockPos generateLabPosition() {
        WorldServer world = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(0);
        Random worldRandom = new Random(world.func_72905_C());
        int range = 5000;
        BlockPos pos = null;
        for (int i = 0; i < 10000; ++i) {
            pos = new BlockPos(worldRandom.nextInt(range) + 5000 * (worldRandom.nextBoolean() ? 1 : -1), 0, worldRandom.nextInt(range) + 5000 * (worldRandom.nextBoolean() ? 1 : -1));
            if (!Lists.newArrayList((Object[])new Biome[]{Biomes.field_76782_w}).contains(world.func_180494_b(pos))) continue;
            return pos;
        }
        return pos;
    }

    private static BlockPos generateDiegoPosition() {
        WorldServer world = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(0);
        Random worldRandom = new Random(world.func_72905_C());
        int range = 5000;
        BlockPos pos = null;
        for (int i = 0; i < 10000; ++i) {
            pos = new BlockPos(worldRandom.nextInt(range) + 5000 * (worldRandom.nextBoolean() ? 1 : -1), 0, worldRandom.nextInt(range) + 5000 * (worldRandom.nextBoolean() ? 1 : -1));
            if (!Lists.newArrayList((Object[])new Biome[]{Biomes.field_150589_Z, Biomes.field_150607_aa, Biomes.field_150608_ab, Biomes.field_185438_aj, Biomes.field_185439_ak}).contains(world.func_180494_b(pos))) continue;
            return pos;
        }
        return pos;
    }
}

