/*
 * Decompiled with CFR 0.152.
 */
package mod.reborn.server.maps;

import mod.reborn.RebornMod;
import mod.reborn.server.maps.MapUtils;
import mod.reborn.server.world.structure.StructureUtils;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.init.Items;
import net.minecraft.item.ItemMap;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.MapData;
import net.minecraft.world.storage.MapDecoration;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.VillagerRegistry;

public class VillagerTradeHandler {
    public static void init() {
        ResourceLocation location = new ResourceLocation("minecraft", "librarian");
        VillagerRegistry.VillagerProfession profession = (VillagerRegistry.VillagerProfession)ForgeRegistries.VILLAGER_PROFESSIONS.getValue(location);
        if (!profession.getRegistryName().equals((Object)location)) {
            RebornMod.getLogger().error("Could not find librarian profession");
        } else {
            VillagerRegistry.VillagerCareer career = profession.getCareer(1);
            if (career.getName().equals("cartographer")) {
                career.addTrade(4, new EntityVillager.ITradeList[]{(merchant, recipeList, random) -> {
                    ItemStack itemstack;
                    BlockPos blockpos;
                    WorldServer world;
                    if (StructureUtils.getStructureData().isVisitorCenter()) {
                        world = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(0);
                        blockpos = MapUtils.getVisitorCenterPosition();
                        itemstack = ItemMap.func_190906_a((World)world, (double)blockpos.func_177958_n(), (double)blockpos.func_177952_p(), (byte)2, (boolean)true, (boolean)true);
                        ItemMap.func_190905_a((World)world, (ItemStack)itemstack);
                        MapData.func_191094_a((ItemStack)itemstack, (BlockPos)blockpos, (String)"+", (MapDecoration.Type)MapDecoration.Type.MANSION);
                        itemstack.func_190924_f("filled_map.rebornmod.visitorcenter");
                        recipeList.add((Object)new MerchantRecipe(new ItemStack(Items.field_151166_bC, random.nextInt(12) + 16), new ItemStack(Items.field_151111_aL), itemstack));
                    }
                    if (StructureUtils.getStructureData().isIslaSornaLab()) {
                        world = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(0);
                        blockpos = MapUtils.getIslaSornaLabPosition();
                        itemstack = ItemMap.func_190906_a((World)world, (double)blockpos.func_177958_n(), (double)blockpos.func_177952_p(), (byte)3, (boolean)true, (boolean)true);
                        ItemMap.func_190905_a((World)world, (ItemStack)itemstack);
                        MapData.func_191094_a((ItemStack)itemstack, (BlockPos)blockpos, (String)"+", (MapDecoration.Type)MapDecoration.Type.MANSION);
                        itemstack.func_190924_f("filled_map.rebornmod.islasornalab");
                        recipeList.add((Object)new MerchantRecipe(new ItemStack(Items.field_151166_bC, random.nextInt(12) + 16), new ItemStack(Items.field_151111_aL), itemstack));
                    }
                    if (StructureUtils.getStructureData().isJPSanDiego()) {
                        world = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(0);
                        blockpos = MapUtils.getJPSanDiegoPosition();
                        itemstack = ItemMap.func_190906_a((World)world, (double)blockpos.func_177958_n(), (double)blockpos.func_177952_p(), (byte)4, (boolean)true, (boolean)true);
                        ItemMap.func_190905_a((World)world, (ItemStack)itemstack);
                        MapData.func_191094_a((ItemStack)itemstack, (BlockPos)blockpos, (String)"+", (MapDecoration.Type)MapDecoration.Type.MANSION);
                        itemstack.func_190924_f("filled_map.rebornmod.JPsandiego");
                        recipeList.add((Object)new MerchantRecipe(new ItemStack(Items.field_151166_bC, random.nextInt(12) + 16), new ItemStack(Items.field_151111_aL), itemstack));
                    }
                }});
                RebornMod.getLogger().info("Successfully registered maps trade");
            } else {
                RebornMod.getLogger().error("Could not find cartographer maps career");
            }
        }
    }
}

