/*
 * Decompiled with CFR 0.152.
 */
package mod.reborn.server.message;

import io.netty.buffer.ByteBuf;
import mod.reborn.RebornMod;
import mod.reborn.server.entity.vehicle.MultiSeatedEntity;
import mod.reborn.server.entity.vehicle.VehicleEntity;
import net.ilexiconn.llibrary.server.network.AbstractMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class AttemptMoveToSeatMessage
extends AbstractMessage<AttemptMoveToSeatMessage> {
    private int fromSeat;
    private int toSeat;
    private int entityID;

    public AttemptMoveToSeatMessage() {
    }

    public AttemptMoveToSeatMessage(Entity entity, int fromSeat, int toSeat) {
        this.toSeat = toSeat;
        this.entityID = entity.func_145782_y();
        this.fromSeat = fromSeat;
    }

    private AttemptMoveToSeatMessage(AttemptMoveToSeatMessage message) {
        this.toSeat = message.toSeat;
        this.fromSeat = message.fromSeat;
        this.entityID = message.entityID;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.toSeat);
        buf.writeInt(this.fromSeat);
        buf.writeInt(this.entityID);
    }

    public void fromBytes(ByteBuf buf) {
        this.toSeat = buf.readInt();
        this.fromSeat = buf.readInt();
        this.entityID = buf.readInt();
    }

    public void onClientReceived(Minecraft client, AttemptMoveToSeatMessage message, EntityPlayer player, MessageContext messageContext) {
        this.putEntityInSeat(player.field_70170_p, message, player);
    }

    public void onServerReceived(MinecraftServer server, AttemptMoveToSeatMessage message, EntityPlayer player, MessageContext messageContext) {
        if (this.putEntityInSeat(player.field_70170_p, message, player)) {
            RebornMod.NETWORK_WRAPPER.sendToDimension((IMessage)new AttemptMoveToSeatMessage(message), player.field_71093_bK);
        }
    }

    private boolean putEntityInSeat(World world, AttemptMoveToSeatMessage message, EntityPlayer player) {
        Entity entity = world.func_73045_a(message.entityID);
        if (entity instanceof MultiSeatedEntity) {
            MultiSeatedEntity multiSeatedEntity = (MultiSeatedEntity)entity;
            VehicleEntity e = (VehicleEntity)entity;
            multiSeatedEntity.tryPutInSeat(world.func_73045_a(player.func_145782_y()), message.toSeat, true);
            return true;
        }
        return false;
    }
}

