/*
 * Decompiled with CFR 0.152.
 */
package mod.reborn.server.message;

import io.netty.buffer.ByteBuf;
import mod.reborn.RebornMod;
import mod.reborn.server.block.entity.TemperatureControl;
import net.ilexiconn.llibrary.server.network.AbstractMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class ChangeTemperatureMessage
extends AbstractMessage<ChangeTemperatureMessage> {
    private int index;
    private int temperature;
    private BlockPos pos;
    private int dimension;

    public ChangeTemperatureMessage() {
    }

    public ChangeTemperatureMessage(BlockPos pos, int index, int temperature, int dimension) {
        this.index = index;
        this.temperature = temperature;
        this.pos = pos;
        this.dimension = dimension;
    }

    public void onClientReceived(Minecraft minecraft, ChangeTemperatureMessage message, EntityPlayer player, MessageContext messageContext) {
        TileEntity tile = player.field_70170_p.func_175625_s(message.pos);
        if (tile instanceof TemperatureControl) {
            TemperatureControl control = (TemperatureControl)tile;
            control.setTemperature(message.index, message.temperature);
        }
    }

    public void onServerReceived(MinecraftServer server, ChangeTemperatureMessage message, EntityPlayer player, MessageContext messageContext) {
        TemperatureControl control;
        TileEntity tile = player.field_70170_p.func_175625_s(message.pos);
        if (tile instanceof TemperatureControl && (control = (TemperatureControl)tile).func_70300_a(player) && message.index >= 0 && message.index < control.getTemperatureCount()) {
            control.setTemperature(message.index, message.temperature);
            RebornMod.NETWORK_WRAPPER.sendToAllTracking((IMessage)new ChangeTemperatureMessage(message.pos, message.index, message.temperature, message.dimension), new NetworkRegistry.TargetPoint(message.dimension, (double)message.pos.func_177958_n(), (double)message.pos.func_177956_o(), (double)message.pos.func_177952_p(), 5.0));
        }
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeByte(this.index);
        buffer.writeByte(this.temperature);
        buffer.writeLong(this.pos.func_177986_g());
        buffer.writeInt(this.dimension);
    }

    public void fromBytes(ByteBuf buffer) {
        this.index = buffer.readUnsignedByte();
        this.temperature = buffer.readUnsignedByte();
        this.pos = BlockPos.func_177969_a((long)buffer.readLong());
        this.dimension = buffer.readInt();
    }
}

