/*
 * Decompiled with CFR 0.152.
 */
package mod.reborn.server.message;

import io.netty.buffer.ByteBuf;
import mod.reborn.server.block.entity.ISyncable;
import net.ilexiconn.llibrary.server.network.AbstractMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class TileEntityFieldsMessage
extends AbstractMessage<TileEntityFieldsMessage> {
    public NonNullList fields;
    private BlockPos position;
    public ByteBuf fieldBuffer = null;

    public TileEntityFieldsMessage() {
    }

    public TileEntityFieldsMessage(NonNullList fields, TileEntity blockEntity) {
        this.fields = fields;
        this.position = blockEntity.func_174877_v();
    }

    public void onClientReceived(Minecraft minecraft, TileEntityFieldsMessage message, EntityPlayer player, MessageContext messageContext) {
        TileEntity tileEntity = player.field_70170_p.func_175625_s(message.position);
        if (tileEntity != null) {
            ISyncable syncable = (ISyncable)tileEntity;
            if (message.fieldBuffer != null) {
                try {
                    syncable.packetDataHandler(message.fieldBuffer);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                message.fieldBuffer.release();
            }
        }
    }

    public void onServerReceived(MinecraftServer server, TileEntityFieldsMessage message, EntityPlayer player, MessageContext messageContext) {
    }

    public void toBytes(ByteBuf buffer) {
        Object[] objL;
        buffer.writeLong(this.position.func_177986_g());
        for (Object obj : objL = this.fields.toArray()) {
            if (obj instanceof Boolean) {
                buffer.writeBoolean(((Boolean)obj).booleanValue());
                continue;
            }
            if (obj instanceof Byte) {
                buffer.writeByte((int)((Byte)obj).byteValue());
                continue;
            }
            if (obj instanceof Integer) {
                buffer.writeInt(((Integer)obj).intValue());
                continue;
            }
            if (obj instanceof Short) {
                buffer.writeShort((int)((Short)obj).shortValue());
                continue;
            }
            if (obj instanceof Long) {
                buffer.writeLong(((Long)obj).longValue());
                continue;
            }
            if (obj instanceof Float) {
                buffer.writeFloat(((Float)obj).floatValue());
                continue;
            }
            if (obj instanceof Double) {
                buffer.writeDouble(((Double)obj).doubleValue());
                continue;
            }
            if (obj instanceof String) {
                ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)((String)obj));
                continue;
            }
            if (obj instanceof NBTTagCompound) {
                ByteBufUtils.writeTag((ByteBuf)buffer, (NBTTagCompound)((NBTTagCompound)obj));
                continue;
            }
            if (!(obj instanceof ItemStack)) continue;
            ByteBufUtils.writeItemStack((ByteBuf)buffer, (ItemStack)((ItemStack)obj));
        }
    }

    public void fromBytes(ByteBuf buffer) {
        this.position = BlockPos.func_177969_a((long)buffer.readLong());
        this.fieldBuffer = buffer.copy();
    }
}

