/*
 * Decompiled with CFR 0.152.
 */
package mod.reborn.server.plugin.jei;

import com.google.common.collect.Lists;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.ingredients.IIngredientBlacklist;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferRegistry;
import mod.reborn.client.gui.CleaningStationGui;
import mod.reborn.client.gui.CultivateGui;
import mod.reborn.client.gui.DNAExtractorGui;
import mod.reborn.client.gui.DNASequencerGui;
import mod.reborn.client.gui.DNASynthesizerGui;
import mod.reborn.client.gui.EmbryoCalcificationMachineGui;
import mod.reborn.client.gui.EmbryonicMachineGui;
import mod.reborn.client.gui.FossilGrinderGui;
import mod.reborn.client.gui.SkeletonAssemblyGui;
import mod.reborn.server.api.CleanableItem;
import mod.reborn.server.api.GrindableItem;
import mod.reborn.server.api.Hybrid;
import mod.reborn.server.api.RebornIngredientItem;
import mod.reborn.server.api.SequencableItem;
import mod.reborn.server.api.SynthesizableItem;
import mod.reborn.server.block.BlockHandler;
import mod.reborn.server.block.tree.AncientDoorBlock;
import mod.reborn.server.container.CleaningStationContainer;
import mod.reborn.server.container.CultivateContainer;
import mod.reborn.server.container.DNAExtractorContainer;
import mod.reborn.server.container.DNASynthesizerContainer;
import mod.reborn.server.container.EmbryoCalcificationMachineContainer;
import mod.reborn.server.container.EmbryonicMachineContainer;
import mod.reborn.server.container.FossilGrinderContainer;
import mod.reborn.server.container.SkeletonAssemblyContainer;
import mod.reborn.server.dinosaur.Dinosaur;
import mod.reborn.server.entity.EntityHandler;
import mod.reborn.server.item.ItemHandler;
import mod.reborn.server.plant.Plant;
import mod.reborn.server.plant.PlantHandler;
import mod.reborn.server.plugin.jei.category.calcification.CalcificationInput;
import mod.reborn.server.plugin.jei.category.calcification.CalcificationRecipeCategory;
import mod.reborn.server.plugin.jei.category.calcification.CalcificationRecipeWrapper;
import mod.reborn.server.plugin.jei.category.cleaningstation.CleanableInput;
import mod.reborn.server.plugin.jei.category.cleaningstation.CleaningStationRecipeCategory;
import mod.reborn.server.plugin.jei.category.cleaningstation.CleaningStationRecipeWrapper;
import mod.reborn.server.plugin.jei.category.cultivate.CultivateInput;
import mod.reborn.server.plugin.jei.category.cultivate.CultivatorRecipeCategory;
import mod.reborn.server.plugin.jei.category.cultivate.CultivatorRecipeWrapper;
import mod.reborn.server.plugin.jei.category.dnaextractor.DNAExtractorRecipeCategory;
import mod.reborn.server.plugin.jei.category.dnaextractor.DNAExtractorRecipeWrapper;
import mod.reborn.server.plugin.jei.category.dnasequencer.DNASequencerRecipeCategory;
import mod.reborn.server.plugin.jei.category.dnasequencer.DNASequencerRecipeWrapper;
import mod.reborn.server.plugin.jei.category.dnasequencer.SequencerInput;
import mod.reborn.server.plugin.jei.category.dnasynthesizer.DNASequencerTransferHandler;
import mod.reborn.server.plugin.jei.category.dnasynthesizer.DNASynthesizerRecipeCategory;
import mod.reborn.server.plugin.jei.category.dnasynthesizer.DNASynthesizerRecipeWrapper;
import mod.reborn.server.plugin.jei.category.dnasynthesizer.SynthesizerInput;
import mod.reborn.server.plugin.jei.category.embroyonicmachine.EmbryoInput;
import mod.reborn.server.plugin.jei.category.embroyonicmachine.EmbryonicRecipeCategory;
import mod.reborn.server.plugin.jei.category.embroyonicmachine.EmbryonicRecipeWrapper;
import mod.reborn.server.plugin.jei.category.fossilgrinder.FossilGrinderRecipeCategory;
import mod.reborn.server.plugin.jei.category.fossilgrinder.FossilGrinderRecipeWrapper;
import mod.reborn.server.plugin.jei.category.fossilgrinder.GrinderInput;
import mod.reborn.server.plugin.jei.category.incubator.IncubatorInput;
import mod.reborn.server.plugin.jei.category.incubator.IncubatorRecipeCategory;
import mod.reborn.server.plugin.jei.category.incubator.IncubatorRecipeWrapper;
import mod.reborn.server.plugin.jei.category.skeletonassembly.SkeletonAssemblyRecipeCategory;
import mod.reborn.server.plugin.jei.category.skeletonassembly.SkeletonAssemblyRecipeWrapper;
import mod.reborn.server.plugin.jei.category.skeletonassembly.SkeletonInput;
import mod.reborn.server.plugin.jei.vanilla.TippedDartRecipeWrapper;
import net.minecraft.block.Block;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
@JEIPlugin
public class RebornJEIPlugin
implements IModPlugin {
    public static final String FOSSIL_GRINDER = "rebornmod.fossil_grinder";
    public static final String CLEANING_STATION = "rebornmod.cleaning_station";
    public static final String DNA_SYNTHASIZER = "rebornmod.dna_synthesizer";
    public static final String EMBRYOMIC_MACHINE = "rebornmod.embryonic_machine";
    public static final String EMBRYO_CALCIFICATION_MACHINE = "rebornmod.embryo_calcification_machine";
    public static final String SKELETON_ASSEMBLY = "rebornmod.skeleton_assembly";
    public static final String DNA_SEQUENCER = "rebornmod.dna_sequencer";
    public static final String CULTIVATEOR = "rebornmod.cultivator";
    public static final String INCUBATOR = "rebornmod.incubator";
    public static final String DNA_EXTRACTOR = "rebornmod.dna_extractor";

    public void register(IModRegistry registry) {
        IIngredientBlacklist blacklist = registry.getJeiHelpers().getIngredientBlacklist();
        ArrayList<AncientDoorBlock> doors = new ArrayList<AncientDoorBlock>();
        doors.addAll(BlockHandler.ANCIENT_DOORS.values());
        doors.add((AncientDoorBlock)BlockHandler.SECURITY_DOOR);
        doors.add((AncientDoorBlock)BlockHandler.REINFORCED_DOOR);
        for (Block block : doors) {
            blacklist.addIngredientToBlacklist((Object)new ItemStack(block));
        }
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Block)BlockHandler.CULTIVATOR_TOP, 1, Short.MAX_VALUE));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Block)BlockHandler.DISPLAY_BLOCK));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Block)BlockHandler.KRILL_SWARM));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Block)BlockHandler.PLANKTON_SWARM));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Block)BlockHandler.RHAMNUS_SALICIFOLIUS_PLANT));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Block)BlockHandler.AJUGINUCULA_SMITHII));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Block)BlockHandler.WILD_ONION));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Block)BlockHandler.WILD_POTATO_PLANT));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Block)BlockHandler.GRACILARIA));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Item)ItemHandler.HATCHED_EGG));
        registry.addRecipes(DNAExtractorRecipeWrapper.getRecipes(registry.getJeiHelpers()), DNA_EXTRACTOR);
        registry.addRecipeClickArea(DNAExtractorGui.class, 77, 37, 22, 16, new String[]{DNA_EXTRACTOR});
        registry.getRecipeTransferRegistry().addRecipeTransferHandler(DNAExtractorContainer.class, DNA_EXTRACTOR, 0, 2, 3, 36);
        registry.addRecipeCatalyst((Object)new ItemStack((Block)BlockHandler.DNA_EXTRACTOR), new String[]{DNA_EXTRACTOR});
        registry.handleRecipes(GrinderInput.class, FossilGrinderRecipeWrapper::new, FOSSIL_GRINDER);
        registry.addRecipeCatalyst((Object)new ItemStack((Block)BlockHandler.FOSSIL_GRINDER), new String[]{FOSSIL_GRINDER});
        registry.handleRecipes(CleanableInput.class, CleaningStationRecipeWrapper::new, CLEANING_STATION);
        registry.addRecipeCatalyst((Object)new ItemStack((Block)BlockHandler.CLEANING_STATION), new String[]{CLEANING_STATION});
        registry.handleRecipes(SynthesizerInput.class, DNASynthesizerRecipeWrapper::new, DNA_SYNTHASIZER);
        registry.addRecipeCatalyst((Object)new ItemStack((Block)BlockHandler.DNA_SYNTHESIZER), new String[]{DNA_SYNTHASIZER});
        registry.handleRecipes(EmbryoInput.class, EmbryonicRecipeWrapper::new, EMBRYOMIC_MACHINE);
        registry.addRecipeCatalyst((Object)new ItemStack((Block)BlockHandler.EMBRYONIC_MACHINE), new String[]{EMBRYOMIC_MACHINE});
        registry.handleRecipes(CalcificationInput.class, CalcificationRecipeWrapper::new, EMBRYO_CALCIFICATION_MACHINE);
        registry.addRecipeCatalyst((Object)new ItemStack((Block)BlockHandler.EMBRYO_CALCIFICATION_MACHINE), new String[]{EMBRYO_CALCIFICATION_MACHINE});
        registry.handleRecipes(SkeletonInput.class, SkeletonAssemblyRecipeWrapper::new, SKELETON_ASSEMBLY);
        registry.addRecipeCatalyst((Object)new ItemStack((Block)BlockHandler.SKELETON_ASSEMBLY), new String[]{SKELETON_ASSEMBLY});
        registry.handleRecipes(SequencerInput.class, DNASequencerRecipeWrapper::new, DNA_SEQUENCER);
        registry.addRecipeCatalyst((Object)new ItemStack((Block)BlockHandler.DNA_SEQUENCER), new String[]{DNA_SEQUENCER});
        registry.handleRecipes(CultivateInput.class, CultivatorRecipeWrapper::new, CULTIVATEOR);
        NonNullList list = NonNullList.func_191196_a();
        BlockHandler.CULTIVATOR_BOTTOM.func_149666_a(CreativeTabs.field_78027_g, (NonNullList<ItemStack>)list);
        list.forEach(item -> registry.addRecipeCatalyst(item, new String[]{CULTIVATEOR}));
        registry.handleRecipes(IncubatorInput.class, IncubatorRecipeWrapper::new, INCUBATOR);
        registry.addRecipeCatalyst((Object)new ItemStack((Block)BlockHandler.INCUBATOR), new String[]{INCUBATOR});
        registry.addRecipeClickArea(FossilGrinderGui.class, 78, 33, 26, 19, new String[]{FOSSIL_GRINDER});
        registry.addRecipeClickArea(CleaningStationGui.class, 78, 33, 26, 19, new String[]{CLEANING_STATION});
        registry.addRecipeClickArea(DNASynthesizerGui.class, 78, 33, 26, 19, new String[]{DNA_SYNTHASIZER});
        registry.addRecipeClickArea(EmbryonicMachineGui.class, 78, 33, 26, 19, new String[]{EMBRYOMIC_MACHINE});
        registry.addRecipeClickArea(EmbryoCalcificationMachineGui.class, 66, 30, 26, 19, new String[]{EMBRYO_CALCIFICATION_MACHINE});
        registry.addRecipeClickArea(SkeletonAssemblyGui.class, 106, 50, 26, 19, new String[]{SKELETON_ASSEMBLY});
        registry.addRecipeClickArea(DNASequencerGui.class, 86, 18, 23, 52, new String[]{DNA_SEQUENCER});
        this.addHollowClickHandler(registry, CultivateGui.class, new Rectangle(98, 20, 64, 64), new Rectangle(116, 38, 27, 27), CULTIVATEOR);
        IRecipeTransferRegistry iRecipeTransferRegistry = registry.getRecipeTransferRegistry();
        iRecipeTransferRegistry.addRecipeTransferHandler(FossilGrinderContainer.class, FOSSIL_GRINDER, 0, 6, 12, 36);
        iRecipeTransferRegistry.addRecipeTransferHandler(CleaningStationContainer.class, CLEANING_STATION, 0, 2, 8, 36);
        iRecipeTransferRegistry.addRecipeTransferHandler(DNASynthesizerContainer.class, DNA_SYNTHASIZER, 0, 3, 7, 36);
        iRecipeTransferRegistry.addRecipeTransferHandler(EmbryonicMachineContainer.class, EMBRYOMIC_MACHINE, 0, 3, 7, 36);
        iRecipeTransferRegistry.addRecipeTransferHandler(EmbryoCalcificationMachineContainer.class, EMBRYO_CALCIFICATION_MACHINE, 0, 2, 3, 36);
        iRecipeTransferRegistry.addRecipeTransferHandler(SkeletonAssemblyContainer.class, SKELETON_ASSEMBLY, 1, 25, 26, 36);
        iRecipeTransferRegistry.addRecipeTransferHandler((IRecipeTransferHandler)new DNASequencerTransferHandler(registry.getJeiHelpers().recipeTransferHandlerHelper()), DNA_SEQUENCER);
        iRecipeTransferRegistry.addRecipeTransferHandler(CultivateContainer.class, CULTIVATEOR, 0, 1, 4, 36);
        registry.addRecipes(this.getAllItems(GrindableItem::getGrindableItem, GrinderInput::new), FOSSIL_GRINDER);
        registry.addRecipes(this.getAllItems(CleanableItem::getCleanableItem, CleanableInput::new), CLEANING_STATION);
        registry.addRecipes(this.getAllItems(SynthesizableItem::getSynthesizableItem, SynthesizerInput::new), DNA_SYNTHASIZER);
        registry.addRecipes(this.getAllItems(SequencableItem::getSequencableItem, SequencerInput::new), DNA_SEQUENCER);
        registry.addRecipes(this.getDinos(CultivateInput::new, dino -> dino.getBirthType() == Dinosaur.BirthType.LIVE_BIRTH), CULTIVATEOR);
        registry.addRecipes(this.getDinos(IncubatorInput::new, dino -> dino.getBirthType() == Dinosaur.BirthType.EGG_LAYING), INCUBATOR);
        registry.addRecipes(this.getDinos(CalcificationInput::new), EMBRYO_CALCIFICATION_MACHINE);
        registry.addRecipes(this.getDinos(EmbryoInput.DinosaurInput::new), EMBRYOMIC_MACHINE);
        registry.addRecipes(this.getPlants(EmbryoInput.PlantInput::new), EMBRYOMIC_MACHINE);
        for (Dinosaur dinosaur : EntityHandler.getRegisteredDinosaurs()) {
            ArrayList<SkeletonInput> skeletonInputs = new ArrayList<SkeletonInput>();
            skeletonInputs.add(new SkeletonInput(dinosaur, true));
            if (!(dinosaur instanceof Hybrid)) {
                skeletonInputs.add(new SkeletonInput(dinosaur, false));
            }
            registry.addRecipes(skeletonInputs, SKELETON_ASSEMBLY);
        }
        registry.addRecipes((Collection)ForgeRegistries.POTION_TYPES.getValuesCollection().stream().map(TippedDartRecipeWrapper::new).collect(Collectors.toList()), "minecraft.crafting");
    }

    private <T> List<T> getDinos(Function<Dinosaur, T> func) {
        return this.getDinos(func, dino -> true);
    }

    private <T> List<T> getDinos(Function<Dinosaur, T> func, Predicate<Dinosaur> filter) {
        return EntityHandler.getRegisteredDinosaurs().stream().filter(filter).map(func).collect(Collectors.toList());
    }

    private <T> List<T> getPlants(Function<Plant, T> func) {
        return PlantHandler.getPrehistoricPlantsAndTrees().stream().map(func).collect(Collectors.toList());
    }

    private <T> List<T> getAllItems(Function<ItemStack, RebornIngredientItem> ingredientFunction, Function<ItemStack, T> tFunction) {
        ArrayList list = Lists.newArrayList();
        ForgeRegistries.ITEMS.getValuesCollection().stream().map(ItemStack::new).map(ingredientFunction).filter(Objects::nonNull).map(RebornIngredientItem::getJEIRecipeTypes).forEach(l -> list.addAll(l.stream().map(tFunction).collect(Collectors.toList())));
        return list;
    }

    private void addHollowClickHandler(IModRegistry registry, Class<? extends GuiContainer> guiContainerClass, Rectangle size, Rectangle ignore, String ... recipeCategoryUids) {
        registry.addRecipeClickArea(guiContainerClass, size.x, size.y, ignore.x - size.x, size.height, recipeCategoryUids);
        registry.addRecipeClickArea(guiContainerClass, ignore.x + ignore.width, size.y, size.x + size.width - (ignore.x + ignore.width), size.height, recipeCategoryUids);
        registry.addRecipeClickArea(guiContainerClass, ignore.x, size.y, ignore.width, ignore.y - size.y, recipeCategoryUids);
        registry.addRecipeClickArea(guiContainerClass, ignore.x, ignore.y + ignore.height, ignore.width, size.y + size.height - (ignore.y + ignore.height), recipeCategoryUids);
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        IGuiHelper guiHelper = registry.getJeiHelpers().getGuiHelper();
        registry.addRecipeCategories(new IRecipeCategory[]{new FossilGrinderRecipeCategory(guiHelper), new CleaningStationRecipeCategory(guiHelper), new DNASynthesizerRecipeCategory(guiHelper), new EmbryonicRecipeCategory(guiHelper), new CalcificationRecipeCategory(guiHelper), new SkeletonAssemblyRecipeCategory(guiHelper), new DNASequencerRecipeCategory(guiHelper), new CultivatorRecipeCategory(guiHelper), new IncubatorRecipeCategory(guiHelper), new DNAExtractorRecipeCategory(guiHelper)});
    }
}

