/*
 * Decompiled with CFR 0.152.
 */
package mod.reborn.server.plugin.jei.category.dnaextractor;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeWrapper;
import mod.reborn.server.dinosaur.Dinosaur;
import mod.reborn.server.entity.EntityHandler;
import mod.reborn.server.genetics.DinoDNA;
import mod.reborn.server.genetics.GeneticsHelper;
import mod.reborn.server.genetics.PlantDNA;
import mod.reborn.server.item.ItemHandler;
import mod.reborn.server.plant.Plant;
import mod.reborn.server.plant.PlantHandler;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class DNAExtractorRecipeWrapper
implements IRecipeWrapper {
    private final ItemStack inputStack;

    public DNAExtractorRecipeWrapper(ItemStack input) {
        this.inputStack = input;
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInputs(ItemStack.class, (List)Lists.newArrayList((Object[])new ItemStack[]{this.inputStack, new ItemStack((Item)ItemHandler.STORAGE_DISC)}));
        ingredients.setOutputLists(ItemStack.class, this.getAllPossibleOutputs(this.inputStack));
    }

    private List<List<ItemStack>> getAllPossibleOutputs(ItemStack input) {
        Random rand = new Random();
        ArrayList<List<ItemStack>> outputs = new ArrayList<List<ItemStack>>();
        outputs.add(new ArrayList());
        if (input.func_77973_b() == ItemHandler.AMBER || input.func_77973_b() == ItemHandler.SEA_LAMPREY) {
            if (input.func_77952_i() == 0) {
                List<Dinosaur> possibleDinos = input.func_77973_b() == ItemHandler.AMBER ? EntityHandler.getDinosaursFromAmber() : EntityHandler.getMarineCreatures();
                for (Dinosaur dino : possibleDinos) {
                    ItemStack disc = ItemStack.field_190927_a;
                    disc = new ItemStack((Item)ItemHandler.STORAGE_DISC);
                    int quality = 50 + rand.nextInt(50);
                    DinoDNA dna = new DinoDNA(dino, quality, GeneticsHelper.randomGenetics(rand));
                    NBTTagCompound nbt = new NBTTagCompound();
                    dna.writeToNBT(nbt);
                    disc.func_77982_d(nbt);
                    ((List)outputs.get(0)).add(disc);
                }
            }
        } else if (input.func_77952_i() == 1) {
            List<Plant> possiblePlants = PlantHandler.getPrehistoricPlantsAndTrees();
            for (Plant plant : possiblePlants) {
                ItemStack disc = ItemStack.field_190927_a;
                int plantId = PlantHandler.getPlantId(plant);
                disc = new ItemStack((Item)ItemHandler.STORAGE_DISC);
                int quality = 50 + rand.nextInt(50);
                PlantDNA dna = new PlantDNA(plantId, quality);
                NBTTagCompound nbt = new NBTTagCompound();
                dna.writeToNBT(nbt);
                disc.func_77982_d(nbt);
                ((List)outputs.get(0)).add(disc);
            }
        } else if (input.func_77973_b() == ItemHandler.AMBER || input.func_77973_b() == ItemHandler.FROZEN_LEECH) {
            if (input.func_77952_i() == 0) {
                List<Dinosaur> possibleDinos = input.func_77973_b() == ItemHandler.AMBER ? EntityHandler.getDinosaursFromAmber() : EntityHandler.getMammalCreatures();
                for (Dinosaur dino : possibleDinos) {
                    ItemStack disc = ItemStack.field_190927_a;
                    disc = new ItemStack((Item)ItemHandler.STORAGE_DISC);
                    int quality = 50 + rand.nextInt(50);
                    DinoDNA dna = new DinoDNA(dino, quality, GeneticsHelper.randomGenetics(rand));
                    NBTTagCompound nbt = new NBTTagCompound();
                    dna.writeToNBT(nbt);
                    disc.func_77982_d(nbt);
                    ((List)outputs.get(0)).add(disc);
                }
            }
        } else if (input.func_77973_b() == ItemHandler.DINOSAUR_MEAT) {
            ItemStack disc = ItemStack.field_190927_a;
            Dinosaur dino = EntityHandler.getDinosaurById(input.func_77960_j());
            disc = new ItemStack((Item)ItemHandler.STORAGE_DISC);
            DinoDNA dna = new DinoDNA(dino, 100, GeneticsHelper.randomGenetics(rand));
            NBTTagCompound nbt = new NBTTagCompound();
            dna.writeToNBT(nbt);
            disc.func_77982_d(nbt);
            ((List)outputs.get(0)).add(disc);
        }
        return outputs;
    }

    public static List<DNAExtractorRecipeWrapper> getRecipes(IJeiHelpers helpers) {
        ArrayList<DNAExtractorRecipeWrapper> list = new ArrayList<DNAExtractorRecipeWrapper>();
        list.add(new DNAExtractorRecipeWrapper(new ItemStack((Item)ItemHandler.AMBER)));
        list.add(new DNAExtractorRecipeWrapper(new ItemStack((Item)ItemHandler.SEA_LAMPREY)));
        list.add(new DNAExtractorRecipeWrapper(new ItemStack((Item)ItemHandler.FROZEN_LEECH)));
        list.add(new DNAExtractorRecipeWrapper(new ItemStack((Item)ItemHandler.AMBER, 1, 1)));
        for (int dino = 0; dino < EntityHandler.getDinosaurs().size(); ++dino) {
            list.add(new DNAExtractorRecipeWrapper(new ItemStack((Item)ItemHandler.DINOSAUR_MEAT, 1, dino)));
        }
        return list;
    }
}

