/*
 * Decompiled with CFR 0.152.
 */
package mod.reborn.server.plugin.jei.category.dnasynthesizer;

import java.awt.Color;
import java.util.List;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import mod.reborn.server.item.ItemHandler;
import mod.reborn.server.plugin.jei.category.dnasynthesizer.DNASynthesizerRecipeWrapper;
import mod.reborn.server.plugin.jei.util.RecipeLayoutOutputSupplier;
import net.minecraft.client.Minecraft;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;

public class DNASynthesizerRecipeCategory
implements IRecipeCategory<DNASynthesizerRecipeWrapper> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("rebornmod", "textures/gui/dna_synthesizer.png");
    private final IDrawable background;
    private final String title;
    private final IDrawableAnimated arrow;
    private RecipeLayoutOutputSupplier outPutSupplier = null;

    public DNASynthesizerRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(TEXTURE, 22, 21, 132, 45);
        this.title = I18n.func_74838_a((String)"tile.dna_synthesizer.name");
        IDrawableStatic arrowDrawable = guiHelper.createDrawable(TEXTURE, 176, 14, 24, 16);
        this.arrow = guiHelper.createAnimatedDrawable(arrowDrawable, 200, IDrawableAnimated.StartDirection.LEFT, false);
    }

    public void drawExtras(Minecraft minecraft) {
        this.arrow.draw(minecraft, 57, 14);
        ItemStack stack = this.outPutSupplier.get();
        if (stack != null && !stack.func_190926_b()) {
            float value = stack.func_190925_c("jei_rendering_info").func_74760_g("Chance");
            String text = value + "%";
            if (value != 100.0f) {
                int width = minecraft.field_71466_p.func_78256_a(text);
                minecraft.field_71466_p.func_78276_b(text, 72 - width / 2, 47, Color.GRAY.getRGB());
            }
        }
    }

    public String getUid() {
        return "rebornmod.dna_synthesizer";
    }

    public String getTitle() {
        return this.title;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public void setRecipe(IRecipeLayout recipeLayout, DNASynthesizerRecipeWrapper recipeWrapper, IIngredients ingredients) {
        this.outPutSupplier = new RecipeLayoutOutputSupplier(recipeLayout, 0, false);
        IGuiItemStackGroup stackGroup = recipeLayout.getItemStacks();
        List inputs = ingredients.getInputs(ItemStack.class);
        List outputs = ingredients.getOutputs(ItemStack.class);
        stackGroup.init(0, true, 15, 0);
        stackGroup.set(0, (List)inputs.get(0));
        stackGroup.init(1, true, 1, 27);
        stackGroup.set(1, new ItemStack((Item)ItemHandler.EMPTY_TEST_TUBE));
        stackGroup.init(2, true, 27, 27);
        stackGroup.set(2, new ItemStack((Item)ItemHandler.DNA_NUCLEOTIDES));
        stackGroup.init(3, false, 96, 4);
        stackGroup.set(3, (List)outputs.get(0));
    }

    public String getModName() {
        return "Jurassic Reborn";
    }
}

