/*
 * Decompiled with CFR 0.152.
 */
package mod.reborn.server.plugin.jei.category.fossilgrinder;

import java.awt.Color;
import java.util.List;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import mod.reborn.server.block.BlockHandler;
import mod.reborn.server.plugin.jei.category.fossilgrinder.FossilGrinderRecipeWrapper;
import mod.reborn.server.plugin.jei.util.RecipeLayoutOutputSupplier;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class FossilGrinderRecipeCategory
implements IRecipeCategory<FossilGrinderRecipeWrapper> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("rebornmod", "textures/gui/fossil_grinder.png");
    private final IDrawable background;
    private final String title;
    private final IDrawableAnimated arrow;
    private RecipeLayoutOutputSupplier outPutSupplier = null;

    public FossilGrinderRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(TEXTURE, 18, 21, 147, 43);
        this.title = BlockHandler.FOSSIL_GRINDER.func_149732_F();
        IDrawableStatic arrowDrawable = guiHelper.createDrawable(TEXTURE, 176, 14, 24, 16);
        this.arrow = guiHelper.createAnimatedDrawable(arrowDrawable, 200, IDrawableAnimated.StartDirection.LEFT, false);
    }

    public void drawExtras(Minecraft minecraft) {
        this.arrow.draw(minecraft, 61, 14);
        ItemStack stack = this.outPutSupplier.get();
        if (stack != null && !stack.func_190926_b()) {
            float value = stack.func_190925_c("jei_rendering_info").func_74760_g("Chance");
            String text = value + "%";
            if (value >= 100.0f) {
                int width = minecraft.field_71466_p.func_78256_a(text);
                minecraft.field_71466_p.func_78276_b(text, 100 - width / 2, 42, Color.GRAY.getRGB());
            }
        }
    }

    public String getUid() {
        return "rebornmod.fossil_grinder";
    }

    public String getTitle() {
        return this.title;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public void setRecipe(IRecipeLayout recipeLayout, FossilGrinderRecipeWrapper recipeWrapper, IIngredients ingredients) {
        this.outPutSupplier = new RecipeLayoutOutputSupplier(recipeLayout, 0, false);
        IGuiItemStackGroup stackGroup = recipeLayout.getItemStacks();
        List inputs = ingredients.getInputs(ItemStack.class);
        List outputs = ingredients.getOutputs(ItemStack.class);
        for (int row = 0; row < 2; ++row) {
            for (int column = 0; column < 3; ++column) {
                int index = column + row * 2;
                int outputIndex = index + 6;
                stackGroup.init(index, true, 4 + column * 18, 4 + row * 18);
                stackGroup.init(outputIndex, false, 89 + column * 18, 4 + row * 18);
                if (index < inputs.size()) {
                    stackGroup.set(index, (List)inputs.get(index));
                }
                if (index >= outputs.size()) continue;
                stackGroup.set(outputIndex, (List)outputs.get(index));
            }
        }
    }

    public String getModName() {
        return "Jurassic Reborn";
    }
}

