/*
 * Decompiled with CFR 0.152.
 */
package mod.reborn.server.util;

import net.minecraft.util.math.MathHelper;

public class MutableVec3 {
    private static final String __OBFID = "CL_00000612";
    public double xCoord;
    public double yCoord;
    public double zCoord;

    public MutableVec3(double x, double y, double z) {
        if (x == -0.0) {
            x = 0.0;
        }
        if (y == -0.0) {
            y = 0.0;
        }
        if (z == -0.0) {
            z = 0.0;
        }
        this.xCoord = x;
        this.yCoord = y;
        this.zCoord = z;
    }

    public MutableVec3 subtractReverse(MutableVec3 vec) {
        return new MutableVec3(vec.xCoord - this.xCoord, vec.yCoord - this.yCoord, vec.zCoord - this.zCoord);
    }

    public MutableVec3 normalize() {
        double d0 = MathHelper.func_76133_a((double)(this.xCoord * this.xCoord + this.yCoord * this.yCoord + this.zCoord * this.zCoord));
        if (d0 < 1.0E-4) {
            this.set(0.0, 0.0, 0.0);
        } else {
            this.set(this.xCoord / d0, this.yCoord / d0, this.zCoord / d0);
        }
        return this;
    }

    public MutableVec3 set(MutableVec3 v) {
        return this.set(v.xCoord, v.yCoord, v.zCoord);
    }

    public MutableVec3 set(double x, double y, double z) {
        this.xCoord = x;
        this.yCoord = y;
        this.zCoord = z;
        return this;
    }

    public double dotProduct(MutableVec3 vec) {
        return this.xCoord * vec.xCoord + this.yCoord * vec.yCoord + this.zCoord * vec.zCoord;
    }

    public MutableVec3 crossProduct(MutableVec3 vec) {
        return this.set(this.yCoord * vec.zCoord - this.zCoord * vec.yCoord, this.zCoord * vec.xCoord - this.xCoord * vec.zCoord, this.xCoord * vec.yCoord - this.yCoord * vec.xCoord);
    }

    public MutableVec3 subtract(MutableVec3 vec) {
        return this.subtract(vec.xCoord, vec.yCoord, vec.zCoord);
    }

    public MutableVec3 subtract(double x, double y, double z) {
        return this.addVector(-x, -y, -z);
    }

    public MutableVec3 add(MutableVec3 vec) {
        return this.addVector(vec.xCoord, vec.yCoord, vec.zCoord);
    }

    public MutableVec3 addVector(double x, double y, double z) {
        return this.set(this.xCoord + x, this.yCoord + y, this.zCoord + z);
    }

    public double distanceTo(MutableVec3 vec) {
        double d0 = vec.xCoord - this.xCoord;
        double d1 = vec.yCoord - this.yCoord;
        double d2 = vec.zCoord - this.zCoord;
        return MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1 + d2 * d2));
    }

    public double squareDistanceTo(MutableVec3 vec) {
        double d0 = vec.xCoord - this.xCoord;
        double d1 = vec.yCoord - this.yCoord;
        double d2 = vec.zCoord - this.zCoord;
        return d0 * d0 + d1 * d1 + d2 * d2;
    }

    public double lengthVector() {
        return MathHelper.func_76133_a((double)(this.xCoord * this.xCoord + this.yCoord * this.yCoord + this.zCoord * this.zCoord));
    }

    public MutableVec3 getIntermediateWithXValue(MutableVec3 vec, double x) {
        double d1 = vec.xCoord - this.xCoord;
        double d2 = vec.yCoord - this.yCoord;
        double d3 = vec.zCoord - this.zCoord;
        if (d1 * d1 < (double)1.0E-7f) {
            return null;
        }
        double d4 = (x - this.xCoord) / d1;
        return d4 >= 0.0 && d4 <= 1.0 ? this.set(this.xCoord + d1 * d4, this.yCoord + d2 * d4, this.zCoord + d3 * d4) : null;
    }

    public MutableVec3 getIntermediateWithYValue(MutableVec3 vec, double y) {
        double d1 = vec.xCoord - this.xCoord;
        double d2 = vec.yCoord - this.yCoord;
        double d3 = vec.zCoord - this.zCoord;
        if (d2 * d2 < (double)1.0E-7f) {
            return null;
        }
        double d4 = (y - this.yCoord) / d2;
        return d4 >= 0.0 && d4 <= 1.0 ? this.set(this.xCoord + d1 * d4, this.yCoord + d2 * d4, this.zCoord + d3 * d4) : null;
    }

    public MutableVec3 getIntermediateWithZValue(MutableVec3 vec, double z) {
        double d1 = vec.xCoord - this.xCoord;
        double d2 = vec.yCoord - this.yCoord;
        double d3 = vec.zCoord - this.zCoord;
        if (d3 * d3 < (double)1.0E-7f) {
            return null;
        }
        double d4 = (z - this.zCoord) / d3;
        return d4 >= 0.0 && d4 <= 1.0 ? this.set(this.xCoord + d1 * d4, this.yCoord + d2 * d4, this.zCoord + d3 * d4) : null;
    }

    public String toString() {
        return "(" + this.xCoord + ", " + this.yCoord + ", " + this.zCoord + ")";
    }

    public MutableVec3 rotatePitch(float pitch) {
        float f1 = MathHelper.func_76134_b((float)pitch);
        float f2 = MathHelper.func_76126_a((float)pitch);
        double d0 = this.xCoord;
        double d1 = this.yCoord * (double)f1 + this.zCoord * (double)f2;
        double d2 = this.zCoord * (double)f1 - this.yCoord * (double)f2;
        return this.set(d0, d1, d2);
    }

    public MutableVec3 rotateYaw(float yaw) {
        float f1 = MathHelper.func_76134_b((float)yaw);
        float f2 = MathHelper.func_76126_a((float)yaw);
        double d0 = this.xCoord * (double)f1 + this.zCoord * (double)f2;
        double d1 = this.yCoord;
        double d2 = this.zCoord * (double)f1 - this.xCoord * (double)f2;
        return this.set(d0, d1, d2);
    }
}

