/*
 * Decompiled with CFR 0.152.
 */
package mod.reborn.server.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mod.reborn.RebornMod;
import mod.reborn.server.block.BlockHandler;
import mod.reborn.server.item.ItemHandler;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.ICriterionTrigger;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber
public class RegistryHandler {
    private static Set<Block> blocksToReg = new HashSet<Block>();
    private static Set<Item> itemsToReg = new HashSet<Item>();
    private static List<IForgeRegistryEntry> otherItems = new ArrayList<IForgeRegistryEntry>();
    private static List<SoundEvent> sounds = new ArrayList<SoundEvent>();
    protected static HashMap<Block, Item> blockItems = new HashMap();
    private static Method CriterionRegister;

    public static void registerBlock(Block block, String registryname) {
        block.setRegistryName(registryname);
        block.func_149663_c(registryname);
        blocksToReg.add(block);
    }

    public static void registerSound(SoundEvent sound, String name) {
        sound.setRegistryName(name);
        sounds.add(sound);
    }

    public static void registerBlockWithItem(Block block, String registryname) {
        block.setRegistryName("rebornmod", registryname);
        block.func_149663_c(registryname);
        ItemBlock ib = new ItemBlock(block);
        ib.setRegistryName("rebornmod", registryname);
        blocksToReg.add(block);
        itemsToReg.add((Item)ib);
        blockItems.put(block, (Item)ib);
    }

    public static void registerBlockWithCustomItem(Block block, ItemBlock iBlock, String registryname) {
        block.setRegistryName("rebornmod", registryname);
        iBlock.setRegistryName("rebornmod", registryname);
        blocksToReg.add(block);
        itemsToReg.add((Item)iBlock);
        blockItems.put(block, (Item)iBlock);
    }

    public static void registerItem(Item item, String registryname) {
        item.setRegistryName("rebornmod", registryname);
        item.func_77655_b(registryname);
        itemsToReg.add(item);
    }

    public static void registerItem(Item item, ResourceLocation registryname, String unlocalized) {
        item.setRegistryName(registryname);
        item.func_77655_b(unlocalized);
        itemsToReg.add(item);
    }

    public <K extends IForgeRegistryEntry<K>> K registerOther(K object) {
        otherItems.add(object);
        return object;
    }

    @SubscribeEvent
    public void registerBlocks(RegistryEvent.Register<Block> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])blocksToReg.toArray(new Block[blocksToReg.size()]));
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])itemsToReg.toArray(new Item[itemsToReg.size()]));
    }

    @SubscribeEvent
    public void registerEnchantments(RegistryEvent.Register<Enchantment> event) {
        for (IForgeRegistryEntry e : otherItems) {
            if (!(e instanceof Enchantment)) continue;
            this.call(event, e);
        }
    }

    @SubscribeEvent
    public static void registerSounds(RegistryEvent.Register<SoundEvent> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])sounds.toArray(new SoundEvent[sounds.size()]));
    }

    private <K extends IForgeRegistryEntry<K>, T> void call(RegistryEvent.Register<K> event, T value) {
        event.getRegistry().register((IForgeRegistryEntry)value);
    }

    public static <T extends ICriterionInstance> ICriterionTrigger<T> registerAdvancementTrigger(ICriterionTrigger<T> trigger) {
        if (CriterionRegister == null) {
            CriterionRegister = ReflectionHelper.findMethod(CriteriaTriggers.class, (String)"register", (String)"func_192118_a", (Class[])new Class[]{ICriterionTrigger.class});
            CriterionRegister.setAccessible(true);
        }
        try {
            trigger = (ICriterionTrigger)CriterionRegister.invoke(null, trigger);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            RebornMod.getLogger().error("Failed to register trigger " + trigger.func_192163_a() + "!");
            e.printStackTrace();
        }
        return trigger;
    }

    @SubscribeEvent
    public void missingMapBlock(RegistryEvent.MissingMappings<Block> event) {
        for (RegistryEvent.MissingMappings.Mapping missing : event.getMappings()) {
            ResourceLocation identifier = new ResourceLocation(missing.key.func_110623_a());
            if (!identifier.equals((Object)new ResourceLocation("rebornmod", "action_figure_block"))) continue;
            missing.remap((IForgeRegistryEntry)BlockHandler.DISPLAY_BLOCK);
        }
    }

    @SubscribeEvent
    public void missingMapItem(RegistryEvent.MissingMappings<Item> event) {
        for (RegistryEvent.MissingMappings.Mapping missing : event.getMappings()) {
            ResourceLocation identifier = new ResourceLocation(missing.key.func_110623_a());
            if (!identifier.equals((Object)new ResourceLocation("rebornmod", "action_figure"))) continue;
            missing.remap((IForgeRegistryEntry)ItemHandler.DISPLAY_BLOCK);
        }
    }
}

