/*
 * Decompiled with CFR 0.152.
 */
package mod.reborn.server.world;

import com.google.common.base.Predicate;
import java.util.Random;
import mod.reborn.server.block.BlockHandler;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenMinable;

public class WorldGenCoal
extends WorldGenMinable {
    private final IBlockState oreBlock;
    private final int veinSize;
    private final Predicate<IBlockState> predicate;

    public WorldGenCoal(IBlockState state, int blockCount) {
        this(state, blockCount, (Predicate<IBlockState>)BlockMatcher.func_177642_a((Block)Blocks.field_150348_b));
    }

    public WorldGenCoal(IBlockState state, int blockCount, Predicate<IBlockState> predicate) {
        super(state, blockCount, predicate);
        this.oreBlock = state;
        this.veinSize = blockCount;
        this.predicate = predicate;
    }

    public boolean func_180709_b(World world, Random rand, BlockPos position) {
        float f = rand.nextFloat() * (float)Math.PI;
        double d0 = (float)(position.func_177958_n() + 8) + MathHelper.func_76126_a((float)f) * (float)this.veinSize / 8.0f;
        double d1 = (float)(position.func_177958_n() + 8) - MathHelper.func_76126_a((float)f) * (float)this.veinSize / 8.0f;
        double d2 = (float)(position.func_177952_p() + 8) + MathHelper.func_76134_b((float)f) * (float)this.veinSize / 8.0f;
        double d3 = (float)(position.func_177952_p() + 8) - MathHelper.func_76134_b((float)f) * (float)this.veinSize / 8.0f;
        double d4 = position.func_177956_o() + rand.nextInt(3) - 2;
        double d5 = position.func_177956_o() + rand.nextInt(3) - 2;
        for (int i = 0; i < this.veinSize; ++i) {
            float f1 = (float)i / (float)this.veinSize;
            double d6 = d0 + (d1 - d0) * (double)f1;
            double d7 = d4 + (d5 - d4) * (double)f1;
            double d8 = d2 + (d3 - d2) * (double)f1;
            double d9 = rand.nextDouble() * (double)this.veinSize / 16.0;
            double d10 = (double)(MathHelper.func_76126_a((float)((float)Math.PI * f1)) + 1.0f) * d9 + 1.0;
            double d11 = (double)(MathHelper.func_76126_a((float)((float)Math.PI * f1)) + 1.0f) * d9 + 1.0;
            int j = MathHelper.func_76128_c((double)(d6 - d10 / 2.0));
            int k = MathHelper.func_76128_c((double)(d7 - d11 / 2.0));
            int l = MathHelper.func_76128_c((double)(d8 - d10 / 2.0));
            int i1 = MathHelper.func_76128_c((double)(d6 + d10 / 2.0));
            int j1 = MathHelper.func_76128_c((double)(d7 + d11 / 2.0));
            int k1 = MathHelper.func_76128_c((double)(d8 + d10 / 2.0));
            for (int l1 = j; l1 <= i1; ++l1) {
                double d12 = ((double)l1 + 0.5 - d6) / (d10 / 2.0);
                if (!(d12 * d12 < 1.0)) continue;
                for (int i2 = k; i2 <= j1; ++i2) {
                    double d13 = ((double)i2 + 0.5 - d7) / (d11 / 2.0);
                    if (!(d12 * d12 + d13 * d13 < 1.0)) continue;
                    for (int j2 = l; j2 <= k1; ++j2) {
                        BlockPos pos;
                        IBlockState previousState;
                        double d14 = ((double)j2 + 0.5 - d8) / (d10 / 2.0);
                        if (!(d12 * d12 + d13 * d13 + d14 * d14 < 1.0) || !(previousState = world.func_180495_p(pos = new BlockPos(l1, i2, j2))).func_177230_c().isReplaceableOreGen(previousState, (IBlockAccess)world, pos, this.predicate)) continue;
                        if (rand.nextInt(10) == 0) {
                            world.func_175656_a(pos, BlockHandler.PLANT_FOSSIL.func_176223_P());
                            continue;
                        }
                        world.func_180501_a(pos, this.oreBlock, 2);
                    }
                }
            }
        }
        return true;
    }
}

