/*
 * Decompiled with CFR 0.152.
 */
package mod.reborn.server.world.structure;

import java.util.List;
import java.util.Map;
import java.util.Random;
import mod.reborn.server.block.BlockHandler;
import mod.reborn.server.world.loot.Loot;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockLog;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureVillagePieces;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraft.world.gen.structure.template.TemplateManager;
import net.minecraftforge.fml.common.registry.VillagerRegistry;

public class GeneticistVillagerHouse
extends StructureVillagePieces.Village {
    public static final int WIDTH = 8;
    public static final int HEIGHT = 6;
    public static final int DEPTH = 14;
    public static final int OFFSET_X = -4;
    public static final int OFFSET_Y = 0;
    public static final int OFFSET_Z = -13;
    public static final IBlockState[] MACHINES = new IBlockState[]{BlockHandler.DNA_EXTRACTOR.func_176223_P(), BlockHandler.DNA_SEQUENCER.func_176223_P(), BlockHandler.DNA_COMBINATOR_HYBRIDIZER.func_176223_P(), BlockHandler.DNA_SYNTHESIZER.func_176223_P(), BlockHandler.EMBRYONIC_MACHINE.func_176223_P()};
    private static final ResourceLocation STRUCTURE = new ResourceLocation("rebornmod", "geneticist_house");
    private int count;
    private EnumFacing coordBaseMode;
    private Mirror mirror;
    private Rotation rotation;

    public GeneticistVillagerHouse() {
    }

    public GeneticistVillagerHouse(StructureVillagePieces.Start start, int type, StructureBoundingBox bounds, EnumFacing facing) {
        super(start, type);
        this.func_186164_a(facing);
        this.field_74887_e = bounds;
    }

    public void func_186164_a(EnumFacing facing) {
        super.func_186164_a(facing);
        this.coordBaseMode = facing;
        if (facing == null) {
            this.rotation = Rotation.NONE;
            this.mirror = Mirror.NONE;
        } else {
            switch (facing) {
                case SOUTH: {
                    this.mirror = Mirror.LEFT_RIGHT;
                    this.rotation = Rotation.NONE;
                    break;
                }
                case WEST: {
                    this.mirror = Mirror.LEFT_RIGHT;
                    this.rotation = Rotation.CLOCKWISE_90;
                    break;
                }
                case EAST: {
                    this.mirror = Mirror.NONE;
                    this.rotation = Rotation.CLOCKWISE_90;
                    break;
                }
                default: {
                    this.mirror = Mirror.NONE;
                    this.rotation = Rotation.NONE;
                }
            }
        }
    }

    public boolean func_74875_a(World world, Random random, StructureBoundingBox bounds) {
        MinecraftServer server = world.func_73046_m();
        TemplateManager templateManager = world.func_72860_G().func_186340_h();
        PlacementSettings settings = new PlacementSettings().func_186220_a(this.rotation).func_186214_a(this.mirror).func_186222_a(true);
        Template template = templateManager.func_186237_a(server, STRUCTURE);
        if (this.field_143015_k < 0) {
            this.field_143015_k = this.func_74889_b(world, bounds);
            if (this.field_143015_k < 0) {
                return false;
            }
            settings.func_186222_a(false);
            this.field_74887_e.func_78886_a(0, this.field_143015_k - this.field_74887_e.field_78894_e + 6 - 1, 0);
            boolean invert = this.mirror == Mirror.LEFT_RIGHT;
            switch (this.coordBaseMode) {
                case SOUTH: {
                    this.field_74887_e.func_78886_a(-4, 0, 13);
                    break;
                }
                case WEST: 
                case EAST: {
                    this.field_74887_e.func_78886_a(invert ? 0 : 13, 0, -4);
                }
            }
        }
        BlockPos lowerCorner = new BlockPos(this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c);
        settings.func_186223_a(this.field_74887_e);
        template.func_186260_a(world, lowerCorner, settings);
        ++this.count;
        Map dataBlocks = template.func_186258_a(lowerCorner, settings);
        dataBlocks.forEach((pos, type) -> {
            switch (type) {
                case "GeneticistChest": {
                    world.func_175656_a(pos, Blocks.field_150486_ae.func_176223_P().func_185907_a(this.rotation.func_185830_a(Rotation.CLOCKWISE_90)).func_185902_a(this.mirror));
                    ((TileEntityChest)world.func_175625_s(pos)).func_189404_a(Loot.GENETICIST_HOUSE_CHEST, random.nextLong());
                    break;
                }
                case "GeneticistMachine": {
                    if (random.nextInt(4) != 0) break;
                    world.func_175656_a(pos, MACHINES[random.nextInt(MACHINES.length)].func_185907_a(this.rotation.func_185830_a(Rotation.CLOCKWISE_90)).func_185902_a(this.mirror));
                    break;
                }
                case "Log": {
                    world.func_175656_a(pos, this.func_175847_a(Blocks.field_150364_r.func_176223_P()));
                    break;
                }
                case "Base": {
                    world.func_175656_a(pos, this.func_175847_a(Blocks.field_150347_e.func_176223_P()));
                    break;
                }
                case "BaseStairs": {
                    world.func_175656_a(pos, this.func_175847_a(Blocks.field_150446_ar.func_176223_P().func_185907_a(this.rotation).func_185902_a(this.mirror)));
                    break;
                }
                case "Wall": {
                    world.func_175656_a(pos, this.func_175847_a(Blocks.field_150344_f.func_176223_P()));
                    break;
                }
                case "Fence": {
                    world.func_175656_a(pos, this.func_175847_a(Blocks.field_180407_aO.func_176223_P()));
                    break;
                }
                case "FenceGate": {
                    IBlockState gate;
                    switch (this.field_189928_h) {
                        case 2: {
                            gate = Blocks.field_180387_bt.func_176223_P();
                            break;
                        }
                        case 3: {
                            gate = Blocks.field_180391_bp.func_176223_P();
                            break;
                        }
                        default: {
                            gate = Blocks.field_180390_bo.func_176223_P();
                        }
                    }
                    world.func_175656_a(pos, gate.func_185907_a(this.rotation).func_185902_a(this.mirror));
                    break;
                }
                case "StainedClay": {
                    IBlockState state = this.func_175847_a(Blocks.field_150364_r.func_176223_P());
                    if (state.func_177227_a().contains(BlockLog.field_176299_a)) {
                        state = state.func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.Y);
                    }
                    world.func_175656_a(pos, state);
                    break;
                }
                case "Bricks": {
                    IBlockState brick = Blocks.field_150417_aV.func_176223_P();
                    if (this.field_189928_h == 1) {
                        brick = Blocks.field_150322_A.func_176223_P();
                    }
                    world.func_175656_a(pos, brick);
                }
            }
        });
        dataBlocks.forEach((pos, type) -> {
            switch (type) {
                case "Door": {
                    world.func_175656_a(pos, this.func_189925_i().func_176223_P().func_185907_a(this.rotation).func_185902_a(this.mirror));
                    break;
                }
                case "DoorTop": {
                    world.func_175656_a(pos, this.func_189925_i().func_176223_P().func_177226_a((IProperty)BlockDoor.field_176523_O, (Comparable)BlockDoor.EnumDoorHalf.UPPER).func_185907_a(this.rotation).func_185902_a(this.mirror));
                    break;
                }
                case "Torch": {
                    world.func_175656_a(pos, Blocks.field_150478_aa.func_176223_P());
                    break;
                }
                case "TorchDoor": {
                    world.func_175656_a(pos, Blocks.field_150478_aa.func_176223_P().func_185907_a(this.rotation).func_185902_a(this.mirror));
                }
            }
        });
        return true;
    }

    protected void func_143012_a(NBTTagCompound tagCompound) {
        super.func_143012_a(tagCompound);
        tagCompound.func_74768_a("count", this.count);
    }

    protected void func_143011_b(NBTTagCompound tagCompound, TemplateManager p_143011_2_) {
        super.func_143011_b(tagCompound, p_143011_2_);
        this.count = tagCompound.func_74762_e("count");
    }

    public static class CreationHandler
    implements VillagerRegistry.IVillageCreationHandler {
        public StructureVillagePieces.PieceWeight getVillagePieceWeight(Random random, int size) {
            return new StructureVillagePieces.PieceWeight(GeneticistVillagerHouse.class, 1, MathHelper.func_76136_a((Random)random, (int)0, (int)1));
        }

        public Class<?> getComponentClass() {
            return GeneticistVillagerHouse.class;
        }

        public StructureVillagePieces.Village buildComponent(StructureVillagePieces.PieceWeight villagePiece, StructureVillagePieces.Start startPiece, List<StructureComponent> pieces, Random random, int minX, int minY, int minZ, EnumFacing facing, int componentType) {
            StructureBoundingBox bounds = StructureBoundingBox.func_175897_a((int)minX, (int)minY, (int)minZ, (int)0, (int)0, (int)0, (int)8, (int)6, (int)14, (EnumFacing)facing);
            return StructureComponent.func_74883_a(pieces, (StructureBoundingBox)bounds) == null ? new GeneticistVillagerHouse(startPiece, componentType, bounds, facing) : null;
        }
    }
}

