/*
 * Decompiled with CFR 0.152.
 */
package mod.reborn.server.world.structure;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import java.util.function.Predicate;
import mod.reborn.server.maps.MapUtils;
import mod.reborn.server.world.structure.AbandonedPaddockGenerator;
import mod.reborn.server.world.structure.AmberMineGenerator;
import mod.reborn.server.world.structure.DesertDigsiteGenerator;
import mod.reborn.server.world.structure.IceFossilDigsiteGenerator;
import mod.reborn.server.world.structure.IslaSornaLabGenerator;
import mod.reborn.server.world.structure.JPSanDiegoGenerator;
import mod.reborn.server.world.structure.RaptorPaddockGenerator;
import mod.reborn.server.world.structure.StructureGenerator;
import mod.reborn.server.world.structure.StructureUtils;
import mod.reborn.server.world.structure.VisitorCentreGenerator;
import net.minecraft.init.Biomes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.registry.GameRegistry;

public enum StructureGenerationHandler implements IWorldGenerator
{
    INSTANCE;

    private static final Map<Biome, List<GeneratorEntry>> GENERATORS;
    private static final List<GeneratorEntry> UNIVERSAL_GENERATORS;

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (world.field_73011_w.getDimension() == 0) {
            List<GeneratorEntry> entries;
            GeneratorEntry generatorEntry2;
            int blockX = (chunkX << 4) + random.nextInt(16);
            int blockZ = (chunkZ << 4) + random.nextInt(16);
            BlockPos pos = new BlockPos(blockX, 0, blockZ);
            Biome biome = world.getBiomeForCoordsBody(pos);
            StructureUtils.StructureData data = StructureUtils.getStructureData();
            boolean universalGeneratorsGenerated = false;
            for (GeneratorEntry generatorEntry2 : UNIVERSAL_GENERATORS) {
                if (!generatorEntry2.predicate.canSpawn(world, pos, random) || !generatorEntry2.configPredicate.test(data)) continue;
                ((StructureGenerator)((Object)generatorEntry2.generatorFunction.apply(random))).func_180709_b(world, random, pos);
                universalGeneratorsGenerated = true;
            }
            if (!universalGeneratorsGenerated && (entries = GENERATORS.get(biome)) != null && !entries.isEmpty() && (generatorEntry2 = entries.get(random.nextInt(entries.size()))) != null && generatorEntry2.predicate.canSpawn(world, pos, random) && generatorEntry2.configPredicate.test(data)) {
                ((StructureGenerator)((Object)generatorEntry2.generatorFunction.apply(random))).func_180709_b(world, random, pos);
            }
        }
    }

    public static void register() {
        GameRegistry.registerWorldGenerator((IWorldGenerator)INSTANCE, (int)0);
        StructureGenerationHandler.registerGenerator(VisitorCentreGenerator::new, StructureUtils.StructureData::isVisitorCenter, (world, pos, random) -> world.func_175726_f(pos) == world.func_175726_f(MapUtils.getVisitorCenterPosition()), new Biome[0]);
        StructureGenerationHandler.registerGenerator(IslaSornaLabGenerator::new, StructureUtils.StructureData::isIslaSornaLab, (world, pos, random) -> world.func_175726_f(pos) == world.func_175726_f(MapUtils.getIslaSornaLabPosition()), new Biome[0]);
        StructureGenerationHandler.registerGenerator(JPSanDiegoGenerator::new, StructureUtils.StructureData::isJPSanDiego, (world, pos, random) -> world.func_175726_f(pos) == world.func_175726_f(MapUtils.getJPSanDiegoPosition()), new Biome[0]);
        StructureGenerationHandler.registerGenerator(RaptorPaddockGenerator::new, StructureUtils.StructureData::isRaptorPaddock, 4000, Biomes.field_76782_w, Biomes.field_185446_X, Biomes.field_150574_L, Biomes.field_185447_Y, Biomes.field_150588_X, Biomes.field_185435_ag);
        StructureGenerationHandler.registerGenerator(AbandonedPaddockGenerator::new, StructureUtils.StructureData::isAbandonedPaddock, 4000, Biomes.field_150588_X, Biomes.field_185435_ag, Biomes.field_76772_c, Biomes.field_76767_f);
        StructureGenerationHandler.registerGenerator(IceFossilDigsiteGenerator::new, StructureUtils.StructureData::isIceFossilDigsite, 4000, Biomes.field_76774_n, Biomes.field_185445_W, Biomes.field_76775_o);
        StructureGenerationHandler.registerGenerator(DesertDigsiteGenerator::new, StructureUtils.StructureData::isDesertDigsite, 4000, Biomes.field_76769_d, Biomes.field_185442_R);
        StructureGenerationHandler.registerGenerator(AmberMineGenerator::new, StructureUtils.StructureData::isAmberMine, 4000, Biomes.field_150585_R, Biomes.field_185430_ab);
    }

    public static void registerGenerator(Function<Random, StructureGenerator> generatorFunction, Predicate<StructureUtils.StructureData> configPredicate, int weight, Biome ... validBiomes) {
        StructureGenerationHandler.registerGenerator(generatorFunction, configPredicate, (world, pos, random) -> random.nextInt(weight) == 0, validBiomes);
    }

    public static void registerGenerator(Function<Random, StructureGenerator> generatorFunction, Predicate<StructureUtils.StructureData> configPredicate, StructurePredicate predicate, Biome ... validBiomes) {
        GeneratorEntry entry = new GeneratorEntry(generatorFunction, configPredicate, predicate);
        for (Biome biome : validBiomes) {
            StructureGenerationHandler.addEntry(biome, entry);
        }
        if (validBiomes.length == 0) {
            UNIVERSAL_GENERATORS.add(entry);
        }
    }

    private static void addEntry(Biome biome, GeneratorEntry generator) {
        GENERATORS.computeIfAbsent(biome, b -> new ArrayList()).add(generator);
    }

    static {
        GENERATORS = new HashMap<Biome, List<GeneratorEntry>>();
        UNIVERSAL_GENERATORS = Lists.newArrayList();
    }

    @FunctionalInterface
    public static interface StructurePredicate {
        public boolean canSpawn(World var1, BlockPos var2, Random var3);
    }

    private static class GeneratorEntry {
        private final Function<Random, StructureGenerator> generatorFunction;
        private final Predicate<StructureUtils.StructureData> configPredicate;
        private final StructurePredicate predicate;

        public GeneratorEntry(Function<Random, StructureGenerator> generatorFunction, Predicate<StructureUtils.StructureData> configPredicate, StructurePredicate predicate) {
            this.generatorFunction = generatorFunction;
            this.configPredicate = configPredicate;
            this.predicate = predicate;
        }
    }
}

