/*
 * Decompiled with CFR 0.152.
 */
package mod.reborn.server.world.structure;

import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.feature.WorldGenerator;

public abstract class StructureGenerator
extends WorldGenerator {
    protected Rotation rotation;
    protected Mirror mirror;
    protected int horizontalPos = -1;
    protected int sizeX;
    protected int sizeY;
    protected int sizeZ;
    private int offsetY;

    protected StructureGenerator(Random rand, int sizeX, int sizeY, int sizeZ) {
        this.sizeX = sizeX;
        this.sizeY = sizeY;
        this.sizeZ = sizeZ;
        Rotation[] rotations = Rotation.values();
        this.rotation = rotations[rand.nextInt(rotations.length)];
        Mirror[] mirrors = Mirror.values();
        this.mirror = mirrors[rand.nextInt(mirrors.length)];
    }

    public void setRotation(Rotation rotation) {
        this.rotation = rotation;
    }

    public void setMirror(Mirror mirror) {
        this.mirror = mirror;
    }

    protected BlockPos placeOnGround(World world, BlockPos pos, int yOffset) {
        int oldMax;
        if (this.horizontalPos >= 0) {
            return new BlockPos(pos.func_177958_n(), this.horizontalPos, pos.func_177952_p());
        }
        int minHeight = Integer.MAX_VALUE;
        int maxHeight = Integer.MIN_VALUE;
        BlockPos.MutableBlockPos currentPos = new BlockPos.MutableBlockPos();
        BlockPos min = this.transformPos(new BlockPos(0, 0, 0), this.mirror, this.rotation).func_177971_a((Vec3i)pos);
        BlockPos max = this.transformPos(new BlockPos(this.sizeX - 1, 0, this.sizeZ - 1), this.mirror, this.rotation).func_177971_a((Vec3i)pos);
        int minX = min.func_177958_n();
        int minZ = min.func_177952_p();
        int maxX = max.func_177958_n();
        int maxZ = max.func_177952_p();
        if (maxZ < minZ) {
            oldMax = maxZ;
            maxZ = minZ;
            minZ = oldMax;
        }
        if (maxX < minX) {
            oldMax = maxX;
            maxX = minX;
            minX = oldMax;
        }
        for (int z = minZ; z <= maxZ; ++z) {
            for (int x = minX; x <= maxX; ++x) {
                if (x != minX && x != maxX && z != minZ && z != maxZ) continue;
                currentPos.func_181079_c(x, 64, z);
                BlockPos ground = this.getGround(world, (BlockPos)currentPos);
                int level = ground.func_177956_o();
                if (level < minHeight) {
                    minHeight = level;
                }
                if (level <= maxHeight) continue;
                maxHeight = level;
            }
        }
        int average = (maxHeight + minHeight) / 2;
        if (average - minHeight > 8 && !this.canSpawnOnHills()) {
            return null;
        }
        this.horizontalPos = minHeight + yOffset;
        return new BlockPos(pos.func_177958_n(), this.horizontalPos, pos.func_177952_p());
    }

    protected BlockPos getGround(World world, BlockPos pos) {
        BlockPos ground;
        IBlockState state;
        Material material;
        Chunk chunk = world.func_175726_f(pos);
        BlockPos currentPos = new BlockPos(pos.func_177958_n(), chunk.func_177433_f(pos), pos.func_177952_p());
        while (currentPos.func_177956_o() >= world.field_73011_w.func_76557_i() - 16 && (material = (state = chunk.func_177435_g(ground = currentPos.func_177977_b())).func_185904_a()) != Material.field_151578_c && material != Material.field_151595_p && material != Material.field_151577_b && material != Material.field_151576_e && !material.func_76224_d()) {
            currentPos = ground;
        }
        return currentPos;
    }

    public boolean func_180709_b(World world, Random random, BlockPos position) {
        BlockPos levelPos = this.getLevelPosition();
        BlockPos blockPos = position = levelPos == null ? this.placeOnGround(world, position, this.getOffsetY()) : this.getGround(world, position).func_177973_b((Vec3i)this.transformPos(levelPos, this.mirror, this.rotation));
        if (position != null) {
            this.generateStructure(world, random, position);
            this.generateFiller(world, position);
            return true;
        }
        return false;
    }

    protected void generateFiller(World world, BlockPos pos) {
        BlockPos min = this.transformPos(new BlockPos(0, 0, 0), this.mirror, this.rotation).func_177971_a((Vec3i)pos);
        BlockPos max = this.transformPos(new BlockPos(this.sizeX - 1, 0, this.sizeZ - 1), this.mirror, this.rotation).func_177971_a((Vec3i)pos);
        for (int x = Math.min(min.func_177958_n(), max.func_177958_n()); x <= Math.max(min.func_177958_n(), max.func_177958_n()); ++x) {
            for (int z = Math.min(min.func_177952_p(), max.func_177952_p()); z <= Math.max(min.func_177952_p(), max.func_177952_p()); ++z) {
                BlockPos blockPos = new BlockPos(x, pos.func_177956_o(), z);
                if (world.func_180495_p(blockPos).func_185904_a() == Material.field_151579_a) continue;
                BlockPos setpos = blockPos.func_177977_b();
                do {
                    world.func_175656_a(setpos, this.getFillerState());
                } while (world.func_180495_p(setpos = setpos.func_177977_b()).func_177230_c().func_176200_f((IBlockAccess)world, setpos));
            }
        }
    }

    protected boolean canSpawnOnHills() {
        return false;
    }

    protected BlockPos transformPos(BlockPos pos, Mirror mirror, Rotation rotation) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        boolean mirrored = true;
        switch (mirror) {
            case LEFT_RIGHT: {
                z = -z;
                break;
            }
            case FRONT_BACK: {
                x = -x;
                break;
            }
            default: {
                mirrored = false;
            }
        }
        switch (rotation) {
            case COUNTERCLOCKWISE_90: {
                return new BlockPos(z, y, -x);
            }
            case CLOCKWISE_90: {
                return new BlockPos(-z, y, x);
            }
            case CLOCKWISE_180: {
                return new BlockPos(-x, y, -z);
            }
        }
        return mirrored ? new BlockPos(x, y, z) : pos;
    }

    protected abstract void generateStructure(World var1, Random var2, BlockPos var3);

    public int getOffsetY() {
        return -1;
    }

    @Nullable
    public BlockPos getLevelPosition() {
        return null;
    }

    @Nonnull
    public IBlockState getFillerState() {
        return Blocks.field_150346_d.func_176223_P();
    }
}

