/*
 * Decompiled with CFR 0.152.
 */
package mod.reborn.server.world.structure;

import javax.annotation.Nonnull;
import mod.reborn.server.conf.RebornConfig;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class StructureUtils {
    private static final String DATA_ID = "rebornmod_structure_info";

    @Nonnull
    public static StructureData getStructureData() {
        WorldServer world = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(0);
        if (world == null) {
            throw new RuntimeException("Overworld returned null");
        }
        StructureData data = (StructureData)world.func_72943_a(StructureData.class, DATA_ID);
        if (data == null) {
            data = new StructureData(DATA_ID);
            data.func_76185_a();
            world.func_72823_a(DATA_ID, (WorldSavedData)data);
        }
        return data;
    }

    public static class StructureData
    extends WorldSavedData {
        private boolean visitorCenter;
        private boolean IslaSornaLab;
        private boolean JPSanDiego;
        private boolean raptorPaddock;
        private boolean IceFossilDigsite;
        private boolean DesertDigsite;
        private boolean AmberMine;
        private boolean AbandonedPaddock;
        private BlockPos visitorCenterPosition;
        private BlockPos IslaSornaLabPosition;
        private BlockPos JPSanDiegoPosition;

        public StructureData(String string) {
            super(string);
            this.visitorCenter = RebornConfig.STRUCTURE_GENERATION.visitorcentergeneration;
            this.IslaSornaLab = RebornConfig.STRUCTURE_GENERATION.islasornalabgenereation;
            this.JPSanDiego = RebornConfig.STRUCTURE_GENERATION.jpsandiegogeneration;
            this.raptorPaddock = RebornConfig.STRUCTURE_GENERATION.raptorgeneration;
            this.IceFossilDigsite = RebornConfig.STRUCTURE_GENERATION.icegeneration;
            this.DesertDigsite = RebornConfig.STRUCTURE_GENERATION.desertgeneration;
            this.AmberMine = RebornConfig.STRUCTURE_GENERATION.minegeneration;
            this.AbandonedPaddock = RebornConfig.STRUCTURE_GENERATION.abandonedgeneration;
            if (!string.equals(StructureUtils.DATA_ID)) {
                throw new RuntimeException("Invalid identifier: " + string);
            }
        }

        public NBTTagCompound func_189551_b(NBTTagCompound compound) {
            compound.func_74757_a("VisitorCenter", this.visitorCenter);
            compound.func_74757_a("IslaSornaLab", this.IslaSornaLab);
            compound.func_74757_a("JPSanDiego", this.JPSanDiego);
            compound.func_74757_a("RaptorPaddock", this.raptorPaddock);
            compound.func_74757_a("AbandonedPaddock", this.AbandonedPaddock);
            compound.func_74757_a("IceFossilDigsite", this.IceFossilDigsite);
            compound.func_74757_a("DesertDigsite", this.DesertDigsite);
            compound.func_74757_a("AmberMine", this.AmberMine);
            compound.func_74772_a("VisitorCenterBlockPosition", this.visitorCenterPosition.func_177986_g());
            compound.func_74772_a("IslaSornaLabBlockPosition", this.IslaSornaLabPosition.func_177986_g());
            compound.func_74772_a("SanDiegoBlockPosition", this.JPSanDiegoPosition.func_177986_g());
            return compound;
        }

        public void func_76184_a(NBTTagCompound nbt) {
            this.visitorCenter = nbt.func_74767_n("VisitorCenter");
            this.IslaSornaLab = nbt.func_74767_n("IslaSornaLab");
            this.JPSanDiego = nbt.func_74767_n("JPSanDiego");
            this.raptorPaddock = nbt.func_74767_n("RaptorPaddock");
            this.AbandonedPaddock = nbt.func_74767_n("AbandonedPaddock");
            this.IceFossilDigsite = nbt.func_74767_n("IceFossilDigsite");
            this.DesertDigsite = nbt.func_74767_n("DesertDigsite");
            this.AmberMine = nbt.func_74767_n("AmberMine");
            this.visitorCenterPosition = BlockPos.func_177969_a((long)nbt.func_74763_f("VisitorCenterBlockPosition"));
            this.IslaSornaLabPosition = BlockPos.func_177969_a((long)nbt.func_74763_f("IslaSornaLabPosition"));
            this.JPSanDiegoPosition = BlockPos.func_177969_a((long)nbt.func_74763_f("SanDiegoPosition"));
        }

        public boolean isVisitorCenter() {
            return this.visitorCenter;
        }

        public boolean isIslaSornaLab() {
            return this.IslaSornaLab;
        }

        public boolean isJPSanDiego() {
            return this.JPSanDiego;
        }

        public boolean isRaptorPaddock() {
            return this.raptorPaddock;
        }

        public boolean isAbandonedPaddock() {
            return this.AbandonedPaddock;
        }

        public boolean isIceFossilDigsite() {
            return this.IceFossilDigsite;
        }

        public boolean isDesertDigsite() {
            return this.DesertDigsite;
        }

        public boolean isAmberMine() {
            return this.AmberMine;
        }

        public BlockPos getVisitorCenterPosition() {
            return this.visitorCenterPosition;
        }

        public BlockPos getIslaSornaLabPosition() {
            return this.IslaSornaLabPosition;
        }

        public BlockPos getJPSanDiegoPosition() {
            return this.JPSanDiegoPosition;
        }

        public void setIslaSornaLabPosition(BlockPos IslaSornaLabPosition) {
            this.IslaSornaLabPosition = IslaSornaLabPosition;
            this.func_76185_a();
        }

        public void setJPSanDiegoPosition(BlockPos JPSanDiegoPosition) {
            this.JPSanDiegoPosition = JPSanDiegoPosition;
            this.func_76185_a();
        }

        public void setVisitorCenterPosition(BlockPos visitorCenterPosition) {
            this.visitorCenterPosition = visitorCenterPosition;
            this.func_76185_a();
        }
    }
}

