/*
 * Decompiled with CFR 0.152.
 */
package mod.reborn.server.world.structure;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import mod.reborn.server.world.loot.Loot;
import mod.reborn.server.world.structure.StructureGenerator;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraft.world.gen.structure.template.TemplateManager;

public class VisitorCentreGenerator
extends StructureGenerator {
    private static final ResourceLocation STRUCTURE = new ResourceLocation("rebornmod", "visitor_centre");
    private static final Map<String, ResourceLocation> LOOT_TABLES = new HashMap<String, ResourceLocation>();

    public VisitorCentreGenerator(Random rand) {
        super(rand, 85, 35, 105);
    }

    @Override
    protected void generateStructure(World world, Random random, BlockPos position) {
        MinecraftServer server = world.func_73046_m();
        TemplateManager templateManager = world.func_72860_G().func_186340_h();
        PlacementSettings settings = new PlacementSettings();
        settings.func_186220_a(this.rotation);
        settings.func_186214_a(this.mirror);
        settings.func_189950_a(random);
        Template template = templateManager.func_186237_a(server, STRUCTURE);
        template.func_186260_a(world, position, settings);
        Map dataBlocks = template.func_186258_a(position, settings);
        for (Map.Entry entry : dataBlocks.entrySet()) {
            String type = (String)entry.getValue();
            BlockPos dataPos = (BlockPos)entry.getKey();
            ResourceLocation lootTable = LOOT_TABLES.get(type);
            if (lootTable == null) continue;
            world.func_175698_g(dataPos);
            TileEntity tile = world.func_175625_s(dataPos.func_177977_b());
            if (!(tile instanceof TileEntityChest)) continue;
            ((TileEntityChest)tile).func_189404_a(lootTable, random.nextLong());
        }
    }

    @Override
    @Nullable
    public BlockPos getLevelPosition() {
        return new BlockPos(38, 3, 1);
    }

    static {
        LOOT_TABLES.put("GroundStorage", Loot.VISITOR_GROUND_STORAGE);
        LOOT_TABLES.put("ControlRoom", Loot.VISITOR_CONTROL_ROOM);
        LOOT_TABLES.put("Laboratory", Loot.VISITOR_LABORATORY);
        LOOT_TABLES.put("Cryonics", Loot.VISITOR_CRYONICS);
        LOOT_TABLES.put("Infirmary", Loot.VISITOR_INFIRMARY);
        LOOT_TABLES.put("Garage", Loot.VISITOR_GARAGE);
        LOOT_TABLES.put("StaffDorms", Loot.VISITOR_STAFF_DORMS);
        LOOT_TABLES.put("Kitchen", Loot.VISITOR_KITCHEN);
        LOOT_TABLES.put("DormTower", Loot.VISITOR_DORM_TOWER);
        LOOT_TABLES.put("DiningHall", Loot.VISITOR_DINING_HALL);
    }
}

