/*
 * Decompiled with CFR 0.152.
 */
package mod.reborn.server.world.tree;

import java.util.Random;
import mod.reborn.server.block.BlockHandler;
import mod.reborn.server.block.tree.AncientLeavesBlock;
import mod.reborn.server.block.tree.AncientLogBlock;
import mod.reborn.server.block.tree.AncientSaplingBlock;
import mod.reborn.server.block.tree.TreeType;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLog;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;

public class AraucariaTreeGenerator
extends WorldGenAbstractTree {
    public AraucariaTreeGenerator() {
        super(true);
    }

    public boolean func_180709_b(World world, Random rand, BlockPos position) {
        IBlockState log = BlockHandler.ANCIENT_LOGS.get((Object)TreeType.ARAUCARIA).func_176223_P();
        IBlockState leaves = BlockHandler.ANCIENT_LEAVES.get((Object)TreeType.ARAUCARIA).func_176223_P();
        int height = rand.nextInt(15) + 10;
        int branchHeight = (int)((double)height / 1.3);
        for (int y = 0; y < height; ++y) {
            BlockPos logPos = position.func_177981_b(y);
            world.func_175656_a(logPos, log);
            if (y <= branchHeight) continue;
            for (EnumFacing facing : EnumFacing.field_176754_o) {
                EnumFacing.Axis axis = facing.func_176740_k();
                boolean zAxis = axis == EnumFacing.Axis.Z;
                if (y % 2 != (facing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE ? 0 : 1)) continue;
                BlockPos branch = logPos.func_177972_a(facing);
                IBlockState facingLog = log.func_177226_a((IProperty)AncientLogBlock.field_176299_a, (Comparable)(zAxis ? BlockLog.EnumAxis.Z : BlockLog.EnumAxis.X));
                world.func_175656_a(branch, facingLog);
                this.generateClump(world, branch, 1.2, leaves);
                if (!((double)y > (double)branchHeight * 1.2)) continue;
                world.func_175656_a(branch.func_177984_a().func_177972_a(facing), facingLog);
                this.generateClump(world, branch.func_177984_a().func_177972_a(facing), 4.0, leaves);
            }
        }
        if (rand.nextInt(10) == 0) {
            this.generateClump(world, position.func_177981_b(height), 64.0, 6.0, leaves);
            this.generateClump(world, position.func_177981_b(height), 8.0, 8.0, leaves);
        } else {
            this.generateClump(world, position.func_177981_b(height), 32.0, 6.0, leaves);
            this.generateClump(world, position.func_177981_b(height), 6.0, 6.0, leaves);
        }
        this.generateClump(world, position.func_177981_b(height + 2), 16.0, 3.5, leaves);
        return true;
    }

    private void generateClump(World world, BlockPos pos, double size, IBlockState state) {
        int blockRadius = (int)Math.ceil(size);
        for (int x = -blockRadius; x < blockRadius; ++x) {
            for (int y = -blockRadius; y < blockRadius; ++y) {
                for (int z = -blockRadius; z < blockRadius; ++z) {
                    BlockPos leafPos;
                    if (!((double)Math.abs(x * x + y * y + z * z) <= size) || !world.func_175623_d(leafPos = pos.func_177982_a(x, y, z))) continue;
                    this.setBlockState(world, leafPos, state);
                }
            }
        }
    }

    private void generateClump(World world, BlockPos pos, double size, double sizeY, IBlockState state) {
        int blockRadius = (int)Math.ceil(size);
        for (int x = -blockRadius; x < blockRadius; ++x) {
            for (int y = -blockRadius; y < blockRadius; ++y) {
                for (int z = -blockRadius; z < blockRadius; ++z) {
                    BlockPos leafPos;
                    if (!(Math.abs((double)(x * x) + (double)(y * y) * (size / sizeY) + (double)(z * z)) <= size) || !world.func_175623_d(leafPos = pos.func_177982_a(x, y, z))) continue;
                    this.setBlockState(world, leafPos, state);
                }
            }
        }
    }

    private void setBlockState(World world, BlockPos pos, IBlockState state) {
        Block block = world.func_180495_p(pos).func_177230_c();
        if (this.func_150523_a(block) || block instanceof AncientLeavesBlock || block instanceof AncientSaplingBlock || block instanceof AncientLogBlock) {
            world.func_175656_a(pos, state);
        }
    }
}

