/*
 * Decompiled with CFR 0.152.
 */
package mod.reborn.server.world.tree;

import java.util.Random;
import mod.reborn.server.block.BlockHandler;
import mod.reborn.server.block.tree.AncientLeavesBlock;
import mod.reborn.server.block.tree.AncientLogBlock;
import mod.reborn.server.block.tree.AncientSaplingBlock;
import mod.reborn.server.block.tree.TreeType;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;

public class PsaroniusTreeGenerator
extends WorldGenAbstractTree {
    public PsaroniusTreeGenerator() {
        super(true);
    }

    public boolean func_180709_b(World world, Random rand, BlockPos position) {
        IBlockState log = BlockHandler.ANCIENT_LOGS.get((Object)TreeType.PSARONIUS).func_176223_P();
        IBlockState leaves = BlockHandler.ANCIENT_LEAVES.get((Object)TreeType.PSARONIUS).func_176223_P();
        int scale = rand.nextInt(1) + 1;
        int height = scale + 6 + rand.nextInt(2);
        BlockPos topPosition = position.func_177981_b(height);
        for (int y = 0; y < height; ++y) {
            BlockPos logPosition = position.func_177981_b(y);
            this.setBlockState(world, logPosition, log);
        }
        int leafScale = scale + 2;
        for (int x = -leafScale; x <= leafScale; ++x) {
            this.setBlockState(world, topPosition.func_177982_a(x, 0, 0), leaves);
        }
        for (int z = -leafScale; z <= leafScale; ++z) {
            this.setBlockState(world, topPosition.func_177982_a(0, 0, z), leaves);
        }
        this.setBlockState(world, topPosition.func_177982_a(-leafScale - 1, -1, 0), leaves);
        this.setBlockState(world, topPosition.func_177982_a(leafScale + 1, -1, 0), leaves);
        this.setBlockState(world, topPosition.func_177982_a(0, -1, -leafScale - 1), leaves);
        this.setBlockState(world, topPosition.func_177982_a(0, -1, leafScale + 1), leaves);
        this.setBlockState(world, topPosition.func_177982_a(-2, -1, -2), leaves);
        this.setBlockState(world, topPosition.func_177982_a(-2, -1, 2), leaves);
        this.setBlockState(world, topPosition.func_177982_a(2, -1, 2), leaves);
        this.setBlockState(world, topPosition.func_177982_a(2, -1, -2), leaves);
        this.generateClump(world, topPosition, 2.5, leaves);
        return true;
    }

    private void generateClump(World world, BlockPos pos, double size, IBlockState state) {
        int blockRadius = (int)Math.ceil(size);
        for (int x = -blockRadius; x < blockRadius; ++x) {
            for (int y = -blockRadius; y < blockRadius; ++y) {
                for (int z = -blockRadius; z < blockRadius; ++z) {
                    BlockPos leafPos;
                    if (!((double)Math.abs(x * x + y * y + z * z) <= size) || !world.func_175623_d(leafPos = pos.func_177982_a(x, y, z))) continue;
                    this.setBlockState(world, leafPos, state);
                }
            }
        }
    }

    private void setBlockState(World world, BlockPos pos, IBlockState state) {
        Block block = world.func_180495_p(pos).func_177230_c();
        if (this.func_150523_a(block) || block instanceof AncientLeavesBlock || block instanceof AncientSaplingBlock || block instanceof AncientLogBlock) {
            world.func_175656_a(pos, state);
        }
    }
}

