/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.client.render.entity;

import com.github.alexthe666.citadel.client.model.basic.BasicEntityModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.awt.Color;
import java.util.Random;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.vit.jurassicreborn.client.render.entity.DinosaurRenderInfo;
import net.vit.jurassicreborn.client.render.entity.animation.EntityAnimator;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.AllosaurusEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.AnkylodocusEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.AnkylosaurusEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.ApatosaurusEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.BaryonyxEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.BrachiosaurusEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.CalymeneEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.CamarasaurusEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.CeratosaurusEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.ChasmosaurusEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.CompsognathusEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.CorythosaurusEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.DeinotheriumEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.DiplodocusEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.GiganotosaurusEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.IndoraptorEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.MaiasauraEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.MammothEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.MicroceratusEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.NigersaurusEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.OviraptorEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.ParaceratheriumEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.ParasaurolophusEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.PatagotitanEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.ProtoceratopsEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.SinoceratopsEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.SmilodonEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.SpinoraptorEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.StyracosaurusEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.TitanisEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.TriceratopsEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.VectipeltaEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntity;
import net.vit.jurassicreborn.common.entities.Dinosaurs.Dinosaur;
import net.vit.jurassicreborn.common.entities.EntityUtils.GrowthStage;
import net.vit.jurassicreborn.common.util.EntityColorTint;

@OnlyIn(value=Dist.CLIENT)
public class DinosaurRenderer
extends LivingEntityRenderer<DinosaurEntity, BasicEntityModel<DinosaurEntity>> {
    public Dinosaur dinosaur;
    public DinosaurRenderInfo renderInfo;
    private static final float BASE_SHADOW_SIZE = 0.5f;
    public Random random;
    Color tint = new Color(0, 0, 0, 255);

    public DinosaurRenderer(EntityRendererProvider.Context renderInfo, BasicEntityModel<DinosaurEntity> model, float shadowSize) {
        super(renderInfo, model, shadowSize);
        this.random = new Random();
        this.m_115326_(new LayerEyelid((RenderLayerParent<DinosaurEntity, BasicEntityModel<DinosaurEntity>>)this));
    }

    public DinosaurRenderer(EntityRendererProvider.Context renderInfo, BasicEntityModel<DinosaurEntity> model, float shadowSize, DinosaurRenderInfo info) {
        super(renderInfo, model, shadowSize);
        this.renderInfo = info;
        this.dinosaur = info.getDinosaur();
        this.random = new Random();
        this.m_115326_(new LayerEyelid((RenderLayerParent<DinosaurEntity, BasicEntityModel<DinosaurEntity>>)this));
    }

    public void setDinosaur(Dinosaur dino, EntityAnimator<?> anim) {
        this.renderInfo = new DinosaurRenderInfo(dino, anim);
    }

    public void scale(DinosaurEntity entity, PoseStack stack, float partialTick) {
        String name;
        boolean skeleton = entity.isSkeleton();
        float scaleModifier = entity.getLegacyAttributes().getScaleModifier();
        double infantScale = this.dinosaur.getScaleInfant(skeleton);
        double adultScale = this.dinosaur.getScaleAdult(skeleton);
        float scale = (float)entity.interpolate(infantScale, adultScale) * scaleModifier;
        this.f_114477_ = scale * 0.5f;
        float offsetX = skeleton ? this.dinosaur.getSkeletonOffsetX() : this.dinosaur.getOffsetX();
        float offsetY = skeleton ? this.dinosaur.getSkeletonOffsetY() : this.dinosaur.getOffsetY();
        float offsetZ = skeleton ? this.dinosaur.getSkeletonOffsetZ() : this.dinosaur.getOffsetZ();
        stack.m_252880_(offsetX * scale, offsetY * scale, offsetZ * scale);
        if (entity.m_7770_() == null) {
            stack.m_85841_(scale, scale, scale);
            return;
        }
        switch (name = entity.m_7770_().getString()) {
            case "Panic": {
                stack.m_85841_(0.1f, scale, scale);
                break;
            }
            case "Kal": {
                stack.m_85841_(scale, 0.01f, scale);
                break;
            }
            case "Des": {
                stack.m_85841_(scale * 1.2f, scale * 1.2f, scale * 1.2f);
                break;
            }
            case "Wyn": {
                stack.m_85841_(scale * 1.3f, scale * 1.3f, scale * 1.3f);
                break;
            }
            case "Notch": {
                stack.m_85841_(scale * 2.0f, scale * 2.0f, scale * 2.0f);
                break;
            }
            case "jglrxavpok": {
                stack.m_85841_(scale, scale, scale * -1.0f);
                break;
            }
            case "Vitiate": {
                int color = Color.HSBtoRGB((float)(entity.f_19853_.m_46467_() % 1000L) / 100.0f, 1.0f, 1.0f);
                this.tint = new Color((float)(color & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color >> 16 & 0xFF) / 255.0f, 1.0f);
                break;
            }
            case "Zth": {
                stack.m_85841_(scale * (float)this.random.nextInt(69), scale * (float)this.random.nextInt(69), scale * (float)this.random.nextInt(69));
                break;
            }
            case "WIDE": {
                stack.m_85841_(scale * 5.0f, scale * 0.5f, scale * 0.5f);
                break;
            }
            default: {
                stack.m_85841_(scale, scale, scale);
                this.tint = new Color(0, 0, 0, 0);
            }
        }
    }

    public void render(DinosaurEntity entity, float pEntityYaw, float pPartialTicks, PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight) {
        this.f_115290_ = this.renderInfo.getModel(entity.getGrowthStage(), entity.getSkeletonVariant());
        if (this.tint.getRGB() != new Color(0, 0, 0, 255).getRGB()) {
            EntityColorTint.setColor(this.tint);
            EntityColorTint.addEntityClassToList(entity.getClass());
        }
        super.m_7392_((LivingEntity)entity, pEntityYaw, pPartialTicks, pMatrixStack, pBuffer, pPackedLight);
    }

    public ResourceLocation getTextureLocation(DinosaurEntity entity) {
        GrowthStage growthStage = entity.getGrowthStage();
        if (!this.dinosaur.doesSupportGrowthStage(growthStage)) {
            growthStage = GrowthStage.ADULT;
        }
        if (entity.isSkeleton()) {
            String dinoName = this.dinosaur.getFormattedName();
            StringBuilder texPath = new StringBuilder();
            texPath.append("textures/entities/").append(dinoName);
            texPath.append("/").append(dinoName);
            if (entity.getIsFossile()) {
                texPath.append("_male_skeleton");
            } else {
                texPath.append("_female_skeleton");
            }
            texPath.append(".png");
            return new ResourceLocation("jurassicreborn", texPath.toString());
        }
        if (entity instanceof MammothEntity) {
            return ((MammothEntity)entity).getTexture();
        }
        if (entity instanceof CorythosaurusEntity) {
            return ((CorythosaurusEntity)entity).getTexture();
        }
        if (entity instanceof GiganotosaurusEntity) {
            return ((GiganotosaurusEntity)entity).getTexture();
        }
        if (entity instanceof MaiasauraEntity) {
            return ((MaiasauraEntity)entity).getTexture();
        }
        if (entity instanceof PatagotitanEntity) {
            return ((PatagotitanEntity)entity).getTexture();
        }
        if (entity instanceof CalymeneEntity) {
            return ((CalymeneEntity)entity).getTexture();
        }
        if (entity instanceof NigersaurusEntity) {
            return ((NigersaurusEntity)entity).getTexture();
        }
        if (entity instanceof CompsognathusEntity) {
            return ((CompsognathusEntity)entity).getTexture();
        }
        if (entity instanceof AllosaurusEntity) {
            return ((AllosaurusEntity)entity).getTexture();
        }
        if (entity instanceof ParasaurolophusEntity) {
            return ((ParasaurolophusEntity)entity).getTexture();
        }
        if (entity instanceof DeinotheriumEntity) {
            return ((DeinotheriumEntity)entity).getTexture();
        }
        if (entity instanceof SmilodonEntity) {
            return ((SmilodonEntity)entity).getTexture();
        }
        if (entity instanceof TitanisEntity) {
            return ((TitanisEntity)entity).getTexture();
        }
        if (entity instanceof CeratosaurusEntity) {
            return ((CeratosaurusEntity)entity).getTexture();
        }
        if (entity instanceof SpinoraptorEntity) {
            return ((SpinoraptorEntity)entity).getTexture();
        }
        if (entity instanceof IndoraptorEntity) {
            return ((IndoraptorEntity)entity).getTexture();
        }
        if (entity instanceof BaryonyxEntity) {
            return ((BaryonyxEntity)entity).getTexture();
        }
        if (entity instanceof DiplodocusEntity) {
            return ((DiplodocusEntity)entity).getTexture();
        }
        if (entity instanceof AnkylodocusEntity) {
            return ((AnkylodocusEntity)entity).getTexture();
        }
        if (entity instanceof CamarasaurusEntity) {
            return ((CamarasaurusEntity)entity).getTexture();
        }
        if (entity instanceof BrachiosaurusEntity) {
            return ((BrachiosaurusEntity)entity).getTexture();
        }
        if (entity instanceof AnkylosaurusEntity) {
            return ((AnkylosaurusEntity)entity).getTexture();
        }
        if (entity instanceof ApatosaurusEntity) {
            return ((ApatosaurusEntity)entity).getTexture();
        }
        if (entity instanceof ParaceratheriumEntity) {
            return ((ParaceratheriumEntity)entity).getTexture();
        }
        if (entity instanceof VectipeltaEntity) {
            return ((VectipeltaEntity)entity).getTexture();
        }
        if (entity instanceof TriceratopsEntity) {
            return ((TriceratopsEntity)entity).getTexture();
        }
        if (entity instanceof StyracosaurusEntity) {
            return ((StyracosaurusEntity)entity).getTexture();
        }
        if (entity instanceof ChasmosaurusEntity) {
            return ((ChasmosaurusEntity)entity).getTexture();
        }
        if (entity instanceof SinoceratopsEntity) {
            return ((SinoceratopsEntity)entity).getTexture();
        }
        if (entity instanceof OviraptorEntity) {
            return ((OviraptorEntity)entity).getTexture();
        }
        if (entity instanceof ProtoceratopsEntity) {
            return ((ProtoceratopsEntity)entity).getTexture();
        }
        if (entity instanceof MicroceratusEntity) {
            return ((MicroceratusEntity)entity).getTexture();
        }
        return entity.isMale() ? this.dinosaur.getMaleTexture(growthStage) : this.dinosaur.getFemaleTexture(growthStage);
    }

    @OnlyIn(value=Dist.CLIENT)
    public class LayerEyelid
    extends RenderLayer<DinosaurEntity, BasicEntityModel<DinosaurEntity>> {
        private final RenderLayerParent<DinosaurEntity, BasicEntityModel<DinosaurEntity>> renderer;

        public LayerEyelid(RenderLayerParent<DinosaurEntity, BasicEntityModel<DinosaurEntity>> pRenderer) {
            super(pRenderer);
            this.renderer = pRenderer;
        }

        public void render(PoseStack poseStack, MultiBufferSource buffer, int packedLight, DinosaurEntity entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            if (entity.m_20145_() || !entity.areEyelidsClosed()) {
                return;
            }
            ResourceLocation tex = entity.getDinosaur().getEyelidTexture(entity);
            if (tex == null) {
                return;
            }
            VertexConsumer vc = buffer.m_6299_(RenderType.m_110458_((ResourceLocation)tex));
            ((BasicEntityModel)this.m_117386_()).m_7695_(poseStack, vc, packedLight, LivingEntityRenderer.m_115338_((LivingEntity)entity, (float)0.0f), 1.0f, 1.0f, 1.0f, 1.0f);
        }
    }
}

