/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.client.render.entity.animation;

import com.github.alexthe666.citadel.client.model.AdvancedModelBox;
import net.minecraft.client.Minecraft;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class FixedChainBuffer {
    private int yawTimer;
    private float yawVariation;
    private float prevYawVariation;
    private float pitchVariation;
    private float prevPitchVariation;
    private float prevPartialTicks;
    private int lastAppliedTick = -1;

    public void calculateChainSwingBuffer(float maxAngle, int bufferTime, float angleDec, float divisor, LivingEntity entity) {
        this.prevYawVariation = this.yawVariation;
        if (entity.f_19797_ != this.lastAppliedTick) {
            this.lastAppliedTick = entity.f_19797_;
            float delta = Mth.m_14177_((float)(entity.f_20884_ - entity.f_20883_));
            if (delta != 0.0f && Mth.m_14154_((float)this.yawVariation) < maxAngle) {
                this.yawVariation += delta / (divisor == 0.0f ? 1.0f : divisor);
            }
            if (this.yawVariation > 0.7f * angleDec) {
                if (this.yawTimer > bufferTime) {
                    this.yawVariation -= angleDec;
                    if (Mth.m_14154_((float)this.yawVariation) < angleDec) {
                        this.yawVariation = 0.0f;
                        this.yawTimer = 0;
                    }
                } else {
                    ++this.yawTimer;
                }
            } else if (this.yawVariation < -0.7f * angleDec) {
                if (this.yawTimer > bufferTime) {
                    this.yawVariation += angleDec;
                    if (Mth.m_14154_((float)this.yawVariation) < angleDec) {
                        this.yawVariation = 0.0f;
                        this.yawTimer = 0;
                    }
                } else {
                    ++this.yawTimer;
                }
            } else if (this.yawTimer > 0) {
                --this.yawTimer;
            }
        }
    }

    public void calculateChainSwingBuffer(float maxAngle, int bufferTime, float angleDec, LivingEntity entity) {
        this.calculateChainSwingBuffer(maxAngle, bufferTime, angleDec, 1.0f, entity);
    }

    public void applyChainSwingBuffer(AdvancedModelBox ... boxes) {
        float partial;
        if (boxes == null || boxes.length == 0) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        float f = partial = mc.m_91104_() ? this.prevPartialTicks : mc.m_91296_();
        if (!mc.m_91104_()) {
            this.prevPartialTicks = partial;
        }
        float rotateAmount = (float)Math.toRadians(Mth.m_14179_((float)partial, (float)this.prevYawVariation, (float)this.yawVariation)) / (float)boxes.length;
        for (AdvancedModelBox box : boxes) {
            box.rotateAngleY += rotateAmount;
        }
    }

    public void applyChainWaveBuffer(AdvancedModelBox ... boxes) {
        if (boxes == null || boxes.length == 0) {
            return;
        }
        float partial = Minecraft.m_91087_().m_91296_();
        float rotateAmount = (float)Math.toRadians(Mth.m_14179_((float)partial, (float)this.prevPitchVariation, (float)this.pitchVariation)) / (float)boxes.length;
        for (AdvancedModelBox box : boxes) {
            box.rotateAngleX += rotateAmount;
        }
    }
}

