/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.client.render.entity.vehicle;

import com.github.alexthe666.citadel.client.model.ITabulaModelAnimator;
import com.github.alexthe666.citadel.client.model.TabulaModel;
import com.github.alexthe666.citadel.client.model.container.TabulaModelContainer;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.stream.IntStream;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.vit.jurassicreborn.client.model.TabulaModelUV;
import net.vit.jurassicreborn.client.render.entity.vehicle.HelicopterAnimator;
import net.vit.jurassicreborn.common.entities.vehicle.HelicopterEntity;
import net.vit.jurassicreborn.common.entities.vehicle.VehicleEntity;
import net.vit.jurassicreborn.common.legacy.tabula.TabulaModelHelper;
import org.jetbrains.annotations.Nullable;

public abstract class HelicopterRenderer<E extends HelicopterEntity>
extends EntityRenderer<E> {
    private final String helicopterName;
    protected final ResourceLocation texture;
    protected final ResourceLocation positionLights;
    private static final ResourceLocation[] DESTROY_STAGES = (ResourceLocation[])IntStream.range(0, 10).mapToObj(i -> new ResourceLocation("textures/block/destroy_stage_" + i + ".png")).toArray(ResourceLocation[]::new);
    protected TabulaModel baseModel;
    protected TabulaModel destroyModel;
    protected HelicopterAnimator animator;
    protected int passedRenderTicks = 0;

    public HelicopterRenderer(EntityRendererProvider.Context context, String helicopterName) {
        super(context);
        this.helicopterName = helicopterName;
        this.animator = this.createCarAnimator();
        this.texture = new ResourceLocation("jurassicreborn", "textures/entities/" + helicopterName + "/" + helicopterName + ".png");
        this.positionLights = new ResourceLocation("jurassicreborn", "textures/entities/" + helicopterName + "/" + helicopterName + "_position_lights.png");
        try {
            TabulaModelContainer container = TabulaModelHelper.loadTabulaModel(new ResourceLocation("jurassicreborn", "models/entities/" + helicopterName + "/" + helicopterName));
            this.baseModel = new TabulaModel(container, (ITabulaModelAnimator)this.animator);
            this.destroyModel = new TabulaModel((TabulaModelContainer)new TabulaModelUV(container, 16, 16), (ITabulaModelAnimator)this.animator);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to load helicopter " + helicopterName, e);
        }
    }

    public void render(E entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, 1.25f, 0.0f);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f - entityYaw));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(((VehicleEntity)((Object)entity)).pitch(partialTicks)));
        poseStack.m_252781_(Axis.f_252403_.m_252977_(((VehicleEntity)((Object)entity)).roll(partialTicks)));
        poseStack.m_85841_(-1.0f, -1.0f, 1.0f);
        this.renderModel(entity, poseStack, buffer, packedLight, partialTicks, false);
        this.renderPositionLamp(entity, poseStack, buffer, packedLight, partialTicks);
        this.renderDestroyTexture(entity, poseStack, buffer, packedLight, partialTicks);
        poseStack.m_85849_();
        super.m_7392_(entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
    }

    protected void renderModel(E entity, PoseStack poseStack, MultiBufferSource buffer, int packedLight, float partialTicks, boolean destroy) {
        TabulaModel model = destroy ? this.destroyModel : this.baseModel;
        this.animator.setRotationAngles(model, (HelicopterEntity)((Object)entity), 0.0f, 0.0f, (float)((HelicopterEntity)((Object)entity)).f_19797_ + partialTicks, entity.m_146908_(), entity.m_146909_(), 0.0625f);
        VertexConsumer consumer = buffer.m_6299_(RenderType.m_110458_((ResourceLocation)this.getTextureLocation(entity)));
        model.m_7695_(poseStack, consumer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    protected void renderPositionLamp(E entity, PoseStack poseStack, MultiBufferSource buffer, int packedLight, float partialTicks) {
        if (((VehicleEntity)((Object)entity)).m_6688_() != null || ((HelicopterEntity)((Object)entity)).getCurrentEngineSpeed() > 1.0f) {
            if (((HelicopterEntity)((Object)entity)).f_19853_.m_46467_() - (long)this.passedRenderTicks > (long)(((HelicopterEntity)((Object)entity)).getPositionLightFrequency() * 2)) {
                this.passedRenderTicks = (int)((HelicopterEntity)((Object)entity)).f_19853_.m_46467_();
            }
            if (((HelicopterEntity)((Object)entity)).f_19853_.m_46467_() - (long)this.passedRenderTicks <= (long)((HelicopterEntity)((Object)entity)).getPositionLightFrequency()) {
                VertexConsumer consumer = buffer.m_6299_(RenderType.m_110473_((ResourceLocation)this.positionLights));
                this.baseModel.m_7695_(poseStack, consumer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 0.7f);
            }
        }
    }

    protected void renderDestroyTexture(E entity, PoseStack poseStack, MultiBufferSource buffer, int packedLight, float partialTicks) {
        int destroyStage = Math.min(10, (int)(10.0f - ((VehicleEntity)((Object)entity)).getHealth() / ((VehicleEntity)((Object)entity)).getHealth() * 10.0f)) - 1;
        if (destroyStage >= 0) {
            RenderSystem.m_69478_();
            RenderSystem.m_69453_();
            VertexConsumer consumer = buffer.m_6299_(RenderType.m_110473_((ResourceLocation)DESTROY_STAGES[destroyStage]));
            this.destroyModel.m_7695_(poseStack, consumer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 0.5f);
            RenderSystem.m_69461_();
        }
    }

    @Nullable
    public ResourceLocation getTextureLocation(E entity) {
        return this.texture;
    }

    protected abstract HelicopterAnimator createCarAnimator();
}

