/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.entities.DinosaurEntities;

import com.github.alexthe666.citadel.animation.Animation;
import java.util.Locale;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.goat.Goat;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.vit.jurassicreborn.client.render.entity.animation.EntityAnimation;
import net.vit.jurassicreborn.client.sounds.SoundHandler;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.CrassigyrinusEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.DodoEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.LeptictidiumEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.MicroceratusEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.MicroraptorEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.OthnieliaEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntity;
import net.vit.jurassicreborn.common.entities.Dinosaurs.DinosaurHandler;
import net.vit.jurassicreborn.common.entities.ai.LeapingMeleeEntityAI;
import net.vit.jurassicreborn.common.entities.ai.RaptorLeapEntityAI;

public class CompsognathusEntity
extends DinosaurEntity {
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(CompsognathusEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public CompsognathusEntity(Level world, EntityType<CompsognathusEntity> type) {
        super(world, type, DinosaurHandler.COMPSOGNATHUS);
        this.setVariant(this.m_217043_().m_188503_(6));
        this.doesEatEggs(true);
        this.target(DodoEntity.class, OthnieliaEntity.class, MicroceratusEntity.class, MicroraptorEntity.class, CrassigyrinusEntity.class, LeptictidiumEntity.class, Player.class, Animal.class, Villager.class, Goat.class);
        this.addTask(0, (Goal)new LeapingMeleeEntityAI(this, this.dinosaur.getAttackSpeed()));
        this.addTask(1, new RaptorLeapEntityAI(this));
        this.addTask(1, (Goal)new CompyHurtByTarget());
    }

    public int m_5639_(float distance, float damageMultiplier) {
        if (this.getAnimation() != EntityAnimation.LEAP_LAND.get()) {
            return super.m_5639_(distance, damageMultiplier);
        }
        return 0;
    }

    @Override
    public SoundEvent getSoundForAnimation(Animation animation) {
        switch (EntityAnimation.getAnimation(animation)) {
            case SPEAK: {
                return SoundHandler.COMPSOGNATHUS_LIVING;
            }
            case DYING: {
                return SoundHandler.COMPSOGNATHUS_DEATH;
            }
            case INJURED: {
                return SoundHandler.COMPSOGNATHUS_HURT;
            }
            case CALLING: {
                return SoundHandler.COMPSOGNATHUS_CALL;
            }
            case BEGGING: {
                return SoundHandler.COMPSOGNATHUS_THREAT;
            }
        }
        return null;
    }

    @Override
    public void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VARIANT, (Object)0);
    }

    @Override
    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128405_("Variant", ((Integer)this.f_19804_.m_135370_(VARIANT)).intValue());
    }

    @Override
    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.f_19804_.m_135381_(VARIANT, (Object)nbt.m_128451_("Variant"));
    }

    public void setVariant(int value) {
        this.f_19804_.m_135381_(VARIANT, (Object)value);
    }

    public int getVariant() {
        return (Integer)this.f_19804_.m_135370_(VARIANT);
    }

    public ResourceLocation getTexture() {
        switch (this.getVariant()) {
            default: {
                return this.texture("nostripes");
            }
            case 1: {
                return this.texture("stripes");
            }
            case 2: {
                return this.texture("lightstripes");
            }
            case 3: {
                return this.texture("orange");
            }
            case 4: {
                return this.texture("blue");
            }
            case 5: 
        }
        return this.texture("purple");
    }

    private ResourceLocation texture(String variant) {
        String formattedName = this.dinosaur.getName().toLowerCase(Locale.ENGLISH).replaceAll(" ", "_");
        String baseTextures = "textures/entities/" + formattedName + "/";
        String texture = baseTextures + formattedName;
        return this.isMale() ? new ResourceLocation("jurassicreborn", texture + "_male_adult_" + variant + ".png") : new ResourceLocation("jurassicreborn", texture + "_female_adult_" + variant + ".png");
    }

    class CompyHurtByTarget
    extends HurtByTargetGoal {
        public CompyHurtByTarget() {
            super((PathfinderMob)CompsognathusEntity.this, new Class[0]);
        }

        public void m_8056_() {
            if (CompsognathusEntity.this.herd.size() >= 3) {
                super.m_8056_();
                if (CompsognathusEntity.this.m_6162_()) {
                    this.m_26047_();
                    this.m_8041_();
                }
            }
        }

        protected void alertOther(DinosaurEntity creatureIn, LivingEntity LivingEntityIn) {
            if (creatureIn instanceof CompsognathusEntity && !creatureIn.m_6162_() && creatureIn != null) {
                super.m_5766_((Mob)creatureIn, LivingEntityIn);
            }
        }
    }
}

