/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.entities.DinosaurEntities;

import com.github.alexthe666.citadel.animation.Animation;
import java.util.EnumSet;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.goat.Goat;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.vit.jurassicreborn.client.render.entity.animation.EntityAnimation;
import net.vit.jurassicreborn.client.sounds.SoundHandler;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.AchillobatorEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.AlligatorGarEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.AlvarezsaurusEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.ArsinoitheriumEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.BeelzebufoEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.ChasmosaurusEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.ChilesaurusEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.CoelurusEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.CompsognathusEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.CrassigyrinusEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.DeinosuchusEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.DiplocaulusEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.DodoEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.GallimimusEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.GuanlongEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.HyaenodonEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.HypsilophodonEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.KairukuEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.LeaellynasauraEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.LeptictidiumEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.MegapiranhaEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.MegatheriumEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.MetriacanthosaurusEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.MicroceratusEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.MicroraptorEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.MussaurusEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.NigersaurusEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.OrnithomimusEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.OthnieliaEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.OviraptorEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.PachycephalosaurusEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.PostosuchusEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.ProceratosaurusEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.ProtoceratopsEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.SegisaurusEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.SmilodonEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.SpinoraptorEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.TroodonEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.VelociraptorBlueEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.VelociraptorCharlieEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.VelociraptorDeltaEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.VelociraptorEchoEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.VelociraptorEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntity;
import net.vit.jurassicreborn.common.entities.Dinosaurs.DinosaurHandler;
import net.vit.jurassicreborn.common.entities.ModEntities;
import net.vit.jurassicreborn.common.entities.VenomEntity;
import net.vit.jurassicreborn.common.entities.ai.DilophosaurusSpitGoal;
import net.vit.jurassicreborn.common.entities.ai.DinosaurAttackMeleeEntityAI;
import org.jetbrains.annotations.NotNull;

public class DilophosaurusEntity
extends DinosaurEntity
implements RangedAttackMob {
    private static final EntityDataAccessor<Boolean> WATCHER_HAS_TARGET = SynchedEntityData.m_135353_(DilophosaurusEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int targetCooldown;

    public DilophosaurusEntity(EntityType<DilophosaurusEntity> type, Level world) {
        super(world, type, DinosaurHandler.DILOPHOSAURUS);
        this.target(Goat.class, SmilodonEntity.class, MegatheriumEntity.class, ArsinoitheriumEntity.class, SpinoraptorEntity.class, Player.class, Villager.class, Animal.class, AchillobatorEntity.class, AlligatorGarEntity.class, AlvarezsaurusEntity.class, BeelzebufoEntity.class, VelociraptorBlueEntity.class, VelociraptorCharlieEntity.class, ChasmosaurusEntity.class, NigersaurusEntity.class, ChilesaurusEntity.class, KairukuEntity.class, CoelurusEntity.class, CompsognathusEntity.class, CrassigyrinusEntity.class, VelociraptorDeltaEntity.class, DodoEntity.class, DiplocaulusEntity.class, VelociraptorEchoEntity.class, GallimimusEntity.class, GuanlongEntity.class, HyaenodonEntity.class, HypsilophodonEntity.class, LeaellynasauraEntity.class, LeptictidiumEntity.class, MegapiranhaEntity.class, MetriacanthosaurusEntity.class, MicroceratusEntity.class, MicroraptorEntity.class, MussaurusEntity.class, OrnithomimusEntity.class, OthnieliaEntity.class, OviraptorEntity.class, PostosuchusEntity.class, DeinosuchusEntity.class, ProceratosaurusEntity.class, ProtoceratopsEntity.class, SegisaurusEntity.class, TroodonEntity.class, VelociraptorEntity.class, PachycephalosaurusEntity.class);
        this.addTask(1, (Goal)new DilophosaurusMeleeEntityAI(this, this.dinosaur.getAttackSpeed()));
        this.f_21345_.m_25352_(0, (Goal)new DilophosaurusSpitGoal(this, 1.2, 25, 45, 14.0f));
    }

    public void m_6504_(LivingEntity target, float power) {
        Player p;
        if (target instanceof Player && (p = (Player)target).m_7500_()) {
            return;
        }
        if (this.f_19853_.f_46443_) {
            return;
        }
        double baseX = this.m_20185_();
        double baseY = this.m_20188_() - 0.12;
        double baseZ = this.m_20189_();
        float bodyYaw = this.m_146908_() * ((float)Math.PI / 180);
        float sin = Mth.m_14031_((float)bodyYaw);
        float cos = Mth.m_14089_((float)bodyYaw);
        double forward = 0.8;
        double mouthDrop = 0.1;
        double spawnX = baseX + (double)(-sin) * 0.8;
        double spawnY = baseY - 0.1;
        double spawnZ = baseZ + (double)cos * 0.8;
        double dx = target.m_20185_() - spawnX;
        double dz = target.m_20189_() - spawnZ;
        double horiz = Math.sqrt(dx * dx + dz * dz);
        double dy = target.m_20188_() - spawnY + horiz * 0.12;
        VenomEntity venom = new VenomEntity((EntityType<? extends VenomEntity>)((EntityType)ModEntities.VENOM.get()), this.f_19853_, (LivingEntity)this);
        venom.m_5602_((Entity)this);
        venom.m_6034_(spawnX, spawnY, spawnZ);
        float velocity = 1.85f + 0.25f * Mth.m_14036_((float)power, (float)0.1f, (float)1.0f);
        float inaccuracy = 0.08f;
        venom.m_6686_(dx, dy, dz, velocity, 0.08f);
        venom.m_20242_(false);
        this.f_19853_.m_7967_((Entity)venom);
        Level level = this.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            sl.m_8767_((ParticleOptions)ParticleTypes.f_123753_, spawnX, spawnY, spawnZ, 10, 0.05, 0.02, 0.05, 0.01);
        }
    }

    @Override
    public void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(WATCHER_HAS_TARGET, (Object)false);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.f_46443_) {
            LivingEntity current = this.m_5448_();
            if (current != null && current.m_6084_() && this.targetCooldown < 50) {
                this.targetCooldown = 50 + this.m_217043_().m_188503_(30);
            } else if (this.targetCooldown > 0) {
                --this.targetCooldown;
            }
            this.f_19804_.m_135381_(WATCHER_HAS_TARGET, (Object)this.hasTarget());
        }
    }

    @Override
    public boolean m_7327_(@NotNull Entity entity) {
        if (super.m_7327_(entity)) {
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                living.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 300, 1, false, false));
            }
            return true;
        }
        return false;
    }

    public boolean hasTarget() {
        if (this.isCarcass() || this.m_5803_()) {
            return false;
        }
        if (this.f_19853_.f_46443_) {
            return (Boolean)this.f_19804_.m_135370_(WATCHER_HAS_TARGET);
        }
        LivingEntity t = this.m_5448_();
        return t != null && t.m_6084_() || this.targetCooldown > 0;
    }

    @Override
    public SoundEvent getSoundForAnimation(Animation animation) {
        switch (EntityAnimation.getAnimation(animation)) {
            case SPEAK: 
            case CALLING: {
                return SoundHandler.DILOPHOSAURUS_LIVING;
            }
            case DYING: {
                return SoundHandler.DILOPHOSAURUS_DEATH;
            }
            case INJURED: {
                return SoundHandler.DILOPHOSAURUS_HURT;
            }
            case ATTACKING: {
                return SoundHandler.DILOPHOSAURUS_SPIT;
            }
        }
        return null;
    }

    public class DilophosaurusMeleeEntityAI
    extends DinosaurAttackMeleeEntityAI {
        public DilophosaurusMeleeEntityAI(DilophosaurusEntity entity, double speed) {
            super(entity, speed, false);
            this.m_7021_(EnumSet.of(Goal.Flag.TARGET));
        }

        @Override
        public boolean m_8036_() {
            LivingEntity target = DilophosaurusEntity.this.m_5448_();
            return super.m_8036_() && target != null && target.m_6084_() && target.m_21223_() < target.m_21233_() * 0.9f && target.m_21023_(MobEffects.f_19610_);
        }
    }
}

