/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.entities.Dinosaurs.DinosaurList;

import java.util.ArrayList;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.BaryonyxEntity;
import net.vit.jurassicreborn.common.entities.Dinosaurs.Dinosaur;
import net.vit.jurassicreborn.common.entities.EntityUtils.Diet;
import net.vit.jurassicreborn.common.util.TimePeriod;

public class BaryonyxDinosaur
extends Dinosaur {
    public static final double SPEED = (double)0.4f;

    public BaryonyxDinosaur() {
        this.setName("Baryonyx");
        this.setScientificName("Baryonyx walkeri");
        this.setFamily("Spinosauridae");
        this.setLocation("United Kingdom");
        this.setDinosaurType(Dinosaur.DinosaurType.AGGRESSIVE);
        this.setDinosaurClass(BaryonyxEntity.class);
        this.setTimePeriod(TimePeriod.CRETACEOUS);
        this.setEggColorMale(7958048, 490867);
        this.setEggColorFemale(9076529, 4603413);
        this.setHealth(6.0, 35.0);
        this.setSpeed(0.3500000059604645, 0.4f);
        this.setAttackSpeed(1.6);
        this.setStrength(1.0, 10.0);
        this.setMaximumAge(this.fromDays(55));
        this.setEyeHeight(0.45f, 2.85f);
        this.setSizeX(0.3f, 1.5f);
        this.setSizeY(0.5f, 2.95f);
        this.setDiet(Diet.PCARNIVORE.get());
        this.setBones("arm_bones", "claw", "leg_bones", "neck_vertebrae", "pelvis", "ribcage", "shoulder", "skull", "tail_vertebrae", "tooth", "foot_bones");
        this.setHeadCubeName("Head");
        this.setBreeding(false, 2, 6, 60, false, true);
        this.setScale(1.38f, 0.1f);
        this.shouldDefendOffspring();
        this.setImprintable(true);
        this.setDefendOwner(true);
        String[][] recipe = new String[][]{{"", "", "", "neck_vertebrae", "skull"}, {"tail_vertebrae", "pelvis", "ribcage", "shoulder", "tooth"}, {"", "leg_bones", "", "arm_bones", ""}, {"", "foot_bones", "", "claw", ""}};
        this.setRecipe(recipe);
        this.enableSkeleton();
        ArrayList<Object> biomeList = new ArrayList();
        TagKey[] tags = new TagKey[]{Tags.Biomes.IS_PLAINS, BiomeTags.f_207611_, Tags.Biomes.IS_SWAMP, BiomeTags.f_207605_};
        ArrayList allBiomes = new ArrayList(ForgeRegistries.BIOMES.getValues());
        biomeList = new ArrayList<ResourceKey>(allBiomes.stream().filter(biome -> {
            boolean accept = false;
            for (TagKey tag : tags) {
                if (!ForgeRegistries.BIOMES.tags().getTag(tag).contains(biome)) continue;
                accept = true;
            }
            return accept;
        }).map(biome -> (ResourceKey)ForgeRegistries.BIOMES.getResourceKey(biome).get()).toList());
        this.setSpawn(1, biomeList);
        this.init();
    }
}

