/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.entities.Dinosaurs.DinosaurList;

import java.util.ArrayList;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.CrassigyrinusEntity;
import net.vit.jurassicreborn.common.entities.Dinosaurs.Dinosaur;
import net.vit.jurassicreborn.common.entities.EntityUtils.Diet;
import net.vit.jurassicreborn.common.util.TimePeriod;

public class CrassigyrinusDinosaur
extends Dinosaur {
    public static final double SPEED = (double)0.3f;

    public CrassigyrinusDinosaur() {
        this.setName("Crassigyrinus");
        this.setScientificName("Crassigyrinus scoticus");
        this.setFamily("Crassigyrinidae");
        this.setLocation("Scotland");
        this.setDinosaurType(Dinosaur.DinosaurType.SCARED);
        this.setDinosaurClass(CrassigyrinusEntity.class);
        this.setTimePeriod(TimePeriod.CRETACEOUS);
        this.setEggColorMale(15057581, 7221774);
        this.setEggColorFemale(15257778, 7620623);
        this.setHealth(10.0, 20.0);
        this.setSpeed(0.25000001192092897, 0.3f);
        this.setStorage(27);
        this.setStrength(1.0, 20.0);
        this.setMaximumAge(this.fromDays(45));
        this.setAttackBias(120.0);
        this.setEyeHeight(0.05f, 0.45f);
        this.setSizeX(0.1f, 1.0f);
        this.setSizeY(0.1f, 0.5f);
        this.setDiet(Diet.CARNIVORE.get());
        this.setBones("skull", "teeth", "tail_vertebrae", "ribcage", "foot_bone", "hind_leg_bones", "front_leg_bones");
        this.setBirthType(Dinosaur.BirthType.LIVE_BIRTH);
        this.setHeadCubeName("Head");
        this.setAttackBias(5.0);
        this.setScale(0.65f, 0.1f);
        this.setOffset(0.0f, -0.75f, 0.0f);
        this.setMarineAnimal(true);
        this.setBreeding(true, 2, 4, 20, false, true);
        String[][] recipe = new String[][]{{"", "", "skull"}, {"tail_vertebrae", "ribcage", "teeth"}, {"hind_leg_bones", "", "front_leg_bones"}, {"", "", "foot_bone"}};
        this.setRecipe(recipe);
        this.enableSkeleton();
        ArrayList<Object> biomeList = new ArrayList();
        TagKey[] tags = new TagKey[]{Tags.Biomes.IS_WATER, BiomeTags.f_207603_, BiomeTags.f_207605_};
        ArrayList allBiomes = new ArrayList(ForgeRegistries.BIOMES.getValues());
        biomeList = new ArrayList<ResourceKey>(allBiomes.stream().filter(biome -> {
            boolean accept = false;
            for (TagKey tag : tags) {
                if (!ForgeRegistries.BIOMES.tags().getTag(tag).contains(biome)) continue;
                accept = true;
            }
            return accept;
        }).map(biome -> (ResourceKey)ForgeRegistries.BIOMES.getResourceKey(biome).get()).toList());
        this.setSpawn(1, biomeList);
        this.init();
    }
}

