/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.entities.Dinosaurs.DinosaurList;

import java.util.ArrayList;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.TylosaurusEntity;
import net.vit.jurassicreborn.common.entities.Dinosaurs.Dinosaur;
import net.vit.jurassicreborn.common.entities.EntityUtils.Diet;
import net.vit.jurassicreborn.common.util.TimePeriod;

public class TylosaurusDinosaur
extends Dinosaur {
    public static final double SPEED = 0.75;

    public TylosaurusDinosaur() {
        this.setName("Tylosaurus");
        this.setScientificName("Tylosaurus proriger");
        this.setFamily("Mosasauridae");
        this.setLocation("North America");
        this.setDinosaurType(Dinosaur.DinosaurType.NEUTRAL);
        this.setDinosaurClass(TylosaurusEntity.class);
        this.setTimePeriod(TimePeriod.CRETACEOUS);
        this.setEggColorMale(1604981, 1397839);
        this.setEggColorFemale(7965327, 1053975);
        this.setHealth(10.0, 40.0);
        this.setSpeed(0.6, 0.75);
        this.setStrength(5.0, 30.0);
        this.setMaximumAge(this.fromDays(60));
        this.setEyeHeight(0.23f, 2.95f);
        this.setSizeX(0.45f, 4.5f);
        this.setSizeY(0.25f, 2.95f);
        this.setStorage(54);
        this.setDiet(Diet.CARNIVORE.get());
        this.setBones("front_flipper", "hind_flipper", "inner_teeth", "ribcage", "skull", "spine", "tail_fluke", "tail_vertebrae", "tooth");
        this.setHeadCubeName("Main head");
        this.setScale(2.2f, 0.15f);
        this.setOffset(0.0f, 0.0f, 1.0f);
        this.shouldDefendOffspring();
        this.setBirthType(Dinosaur.BirthType.LIVE_BIRTH);
        this.setAttackBias(500.0);
        this.setMarineAnimal(true);
        this.givesDirectBirth();
        this.setBreeding(true, 1, 4, 60, false, true);
        this.setImprintable(false);
        this.setStorage(54);
        String[][] recipe = new String[][]{{"tail_fluke", "tail_vertebrae", "spine", "ribcage", "skull"}, {"", "", "", "inner_teeth", "tooth"}, {"hind_flipper", "hind_flipper", "", "front_flipper", "front_flipper"}};
        this.setRecipe(recipe);
        this.enableSkeleton();
        ArrayList<Object> biomeList = new ArrayList();
        TagKey[] tags = new TagKey[]{Tags.Biomes.IS_WATER, BiomeTags.f_207603_};
        ArrayList allBiomes = new ArrayList(ForgeRegistries.BIOMES.getValues());
        biomeList = new ArrayList<ResourceKey>(allBiomes.stream().filter(biome -> {
            boolean accept = false;
            for (TagKey tag : tags) {
                if (!ForgeRegistries.BIOMES.tags().getTag(tag).contains(biome)) continue;
                accept = true;
            }
            return accept;
        }).map(biome -> (ResourceKey)ForgeRegistries.BIOMES.getResourceKey(biome).get()).toList());
        this.setSpawn(1, biomeList);
        this.init();
    }
}

