/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.entities;

import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.vit.jurassicreborn.common.entities.DinosaurEntity;
import net.vit.jurassicreborn.common.entities.Dinosaurs.Dinosaur;
import net.vit.jurassicreborn.common.entities.ai.navigation.DinosaurMoveHelper;
import net.vit.jurassicreborn.common.entities.ai.navigation.DinosaurPathNavigate;
import org.jetbrains.annotations.Nullable;

public abstract class PenguinDinosaurEntity
extends DinosaurEntity {
    private boolean getOut = false;
    private boolean getInWater = false;
    private boolean blocked;
    protected final PathNavigation navigationSwimmer;
    protected final PathNavigation navigationLand;
    private final SmoothSwimmingMoveControl waterMoveControl = new SmoothSwimmingMoveControl((Mob)this, 85, 10, 0.02f, 0.1f, true);
    private final SmoothSwimmingLookControl waterLookControl = new SmoothSwimmingLookControl((Mob)this, 10);
    private final DinosaurMoveHelper landMoveControl;
    private final LookControl landLookControl;
    private int waterTicks;
    private int landTicks;

    public PenguinDinosaurEntity(Level world, EntityType type, Dinosaur dino) {
        super(world, (EntityType<? extends DinosaurEntity>)type, dino);
        this.navigationSwimmer = new WaterBoundPathNavigation((Mob)this, world);
        this.landMoveControl = new DinosaurMoveHelper(this);
        this.landLookControl = new LookControl((Mob)this);
        this.navigationLand = new DinosaurPathNavigate(this, world);
        this.navigationLand.m_7008_(true);
        this.f_21342_ = this.landMoveControl;
        this.f_21365_ = this.landLookControl;
        this.f_21344_ = this.navigationLand;
        this.blocked = false;
        this.f_21345_.m_25352_(5, (Goal)new MoveUnderwaterGoal());
        this.f_21345_.m_25352_(10, (Goal)new FindWaterGoal());
        this.f_21345_.m_25352_(10, (Goal)new WanderGoal());
    }

    @Override
    public boolean isMovementBlocked() {
        return this.isCarcass() || this.m_5803_() || this.blocked;
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (!this.f_19853_.f_46443_ && this.m_6084_()) {
            if (this.m_20069_()) {
                ++this.waterTicks;
                this.landTicks = 0;
                this.m_20301_(300);
                this.getOut = this.waterTicks > 200;
                this.getInWater = false;
                this.f_21344_ = this.navigationSwimmer;
            } else {
                ++this.landTicks;
                this.waterTicks = 0;
                int air = this.m_20146_() - 1;
                this.m_20301_(air);
                if (air <= -20) {
                    this.m_20301_(0);
                    this.m_6469_(DamageSource.f_19312_, 2.0f);
                }
                this.getInWater = air < 40;
                this.getOut = false;
                this.f_21344_ = this.navigationLand;
            }
        }
        if (this.m_20069_()) {
            if (this.f_21342_ != this.waterMoveControl) {
                this.f_21342_ = this.waterMoveControl;
            }
            if (this.f_21365_ != this.waterLookControl) {
                this.f_21365_ = this.waterLookControl;
            }
            if (this.f_21344_ != this.navigationSwimmer) {
                this.f_21344_ = this.navigationSwimmer;
            }
        } else {
            if (this.f_21342_ != this.landMoveControl) {
                this.f_21342_ = this.landMoveControl;
            }
            if (this.f_21365_ != this.landLookControl) {
                this.f_21365_ = this.landLookControl;
            }
            if (this.f_21344_ != this.navigationLand) {
                this.f_21344_ = this.navigationLand;
            }
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.f_19853_.f_46443_ && this.m_20069_() && this.m_20184_().m_82556_() > 0.005) {
            Vec3 viewVec = this.m_20252_(0.0f);
            float offsetX = Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180))) * 0.3f;
            float offsetZ = Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))) * 0.3f;
            float distance = 1.2f - this.f_19796_.m_188501_() * 0.7f;
            for (int i = 0; i < 2; ++i) {
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123776_, this.m_20185_() - viewVec.f_82479_ * (double)distance + (double)offsetX, this.m_20186_() - viewVec.f_82480_, this.m_20189_() - viewVec.f_82481_ * (double)distance + (double)offsetZ, 0.0, 0.0, 0.0);
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123776_, this.m_20185_() - viewVec.f_82479_ * (double)distance - (double)offsetX, this.m_20186_() - viewVec.f_82480_, this.m_20189_() - viewVec.f_82481_ * (double)distance - (double)offsetZ, 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    public void m_7023_(Vec3 vec) {
        boolean noInput;
        float strafe = (float)vec.f_82479_;
        float vertical = (float)vec.f_82480_;
        float forward = (float)vec.f_82481_;
        boolean bl = noInput = strafe == 0.0f && vertical == 0.0f && forward == 0.0f;
        if (!this.f_19853_.f_46443_ && this.m_20069_() && !this.isCarcass()) {
            this.m_19920_(0.25f, new Vec3((double)strafe, (double)vertical, (double)forward));
            this.m_6478_(MoverType.SELF, this.m_20184_());
            Vec3 movement = this.m_20184_().m_82542_(0.7, 0.7, 0.7);
            if (noInput) {
                movement = movement.m_82520_(0.0, -0.005, 0.0);
            }
            this.m_20256_(movement);
        } else {
            super.m_7023_(vec);
        }
    }

    class MoveUnderwaterGoal
    extends Goal {
        private double x;
        private double y;
        private double z;

        public MoveUnderwaterGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            Vec3 target;
            RandomSource rng = PenguinDinosaurEntity.this.m_217043_();
            if (PenguinDinosaurEntity.this.m_5448_() != null) {
                return false;
            }
            if (rng.m_188501_() < 0.5f && PenguinDinosaurEntity.this.isBusy()) {
                return false;
            }
            Vec3 vec3 = target = PenguinDinosaurEntity.this.getOut ? this.getRandomLandPos((Mob)PenguinDinosaurEntity.this, 6, 6) : this.getRandomWaterPos((Mob)PenguinDinosaurEntity.this, 6, 6);
            if (target == null) {
                return false;
            }
            this.x = target.f_82479_;
            this.y = target.f_82480_;
            this.z = target.f_82481_;
            return true;
        }

        public boolean m_8045_() {
            if (PenguinDinosaurEntity.this.m_5448_() != null) {
                return false;
            }
            return !PenguinDinosaurEntity.this.m_21573_().m_26571_();
        }

        public void m_8056_() {
            PenguinDinosaurEntity.this.m_21573_().m_26519_(this.x, this.y, this.z, 1.0);
        }

        public boolean m_6767_() {
            return true;
        }

        @Nullable
        private Vec3 getRandomWaterPos(Mob mob, int hr, int vr) {
            for (int i = 0; i < 10; ++i) {
                double z;
                double y;
                double x = mob.m_20185_() + (double)mob.m_217043_().m_188503_(hr * 2 + 1) - (double)hr;
                BlockPos pos = new BlockPos(x, y = mob.m_20186_() + (double)mob.m_217043_().m_188503_(vr * 2 + 1) - (double)vr, z = mob.m_20189_() + (double)mob.m_217043_().m_188503_(hr * 2 + 1) - (double)hr);
                if (!mob.f_19853_.m_8055_(pos).m_60767_().m_76332_()) continue;
                return new Vec3(x, y, z);
            }
            return null;
        }

        @Nullable
        private Vec3 getRandomLandPos(Mob mob, int hr, int vr) {
            for (int i = 0; i < 10; ++i) {
                double z;
                double y;
                double x = mob.m_20185_() + (double)mob.m_217043_().m_188503_(hr * 2 + 1) - (double)hr;
                BlockPos pos = new BlockPos(x, y = mob.m_20186_() + (double)mob.m_217043_().m_188503_(vr * 2 + 1) - (double)vr, z = mob.m_20189_() + (double)mob.m_217043_().m_188503_(hr * 2 + 1) - (double)hr);
                if (!mob.f_19853_.m_8055_(pos).m_60767_().m_76333_()) continue;
                return new Vec3(x, y, z);
            }
            return null;
        }
    }

    class FindWaterGoal
    extends Goal {
        public FindWaterGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return false;
        }
    }

    class WanderGoal
    extends RandomStrollGoal {
        public WanderGoal() {
            super((PathfinderMob)PenguinDinosaurEntity.this, 1.0, 10);
        }

        public boolean m_8036_() {
            if (PenguinDinosaurEntity.this.getInWater) {
                return false;
            }
            return !PenguinDinosaurEntity.this.m_20069_() && super.m_8036_();
        }
    }
}

