/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.items.Fossils;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.vit.jurassicreborn.common.blocks.ModBlocks;
import net.vit.jurassicreborn.common.blocks.entities.SkullDisplayBlockEntity;
import net.vit.jurassicreborn.common.blocks.entities.grinder.FossilGrinderBlockEntity;
import net.vit.jurassicreborn.common.entities.Dinosaurs.Dinosaur;
import net.vit.jurassicreborn.common.entities.Dinosaurs.DinosaurHandler;
import net.vit.jurassicreborn.common.entities.EntityUtils.Hybrid;
import net.vit.jurassicreborn.common.items.ModItems;
import net.vit.jurassicreborn.common.util.LangUtil;
import net.vit.jurassicreborn.common.util.api.DinosaurItem;
import net.vit.jurassicreborn.common.util.api.GrindableItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FossilItem
extends Item
implements GrindableItem {
    public static Map<String, List<Dinosaur>> fossilDinosaurs = new HashMap<String, List<Dinosaur>>();
    public static Map<String, List<Dinosaur>> freshFossilDinosaurs = new HashMap<String, List<Dinosaur>>();
    private String type;
    private boolean fresh;
    private final Dinosaur dino;
    private static final Set<Dinosaur> SKULL_DISPLAY_DINOS = Set.of(DinosaurHandler.ACHILLOBATOR, DinosaurHandler.TYRANNOSAURUS, DinosaurHandler.VELOCIRAPTOR, DinosaurHandler.ECHO, DinosaurHandler.BLUE, DinosaurHandler.DELTA, DinosaurHandler.CHARLIE, DinosaurHandler.ALLOSAURUS, DinosaurHandler.BARYONYX, DinosaurHandler.ANKYLODOCUS, DinosaurHandler.ANKYLOSAURUS, DinosaurHandler.ARSINOITHERIUM, DinosaurHandler.APATOSAURUS, DinosaurHandler.BRACHIOSAURUS, DinosaurHandler.CAMARASAURUS, DinosaurHandler.CARCHARODONTOSAURUS, DinosaurHandler.CERATOSAURUS, DinosaurHandler.CHASMOSAURUS, DinosaurHandler.CARNOTAURUS, DinosaurHandler.CORYTHOSAURUS, DinosaurHandler.CEARADACTYLUS, DinosaurHandler.DREADNOUGHTUS, DinosaurHandler.DIPLODOCUS, DinosaurHandler.DEINOTHERIUM, DinosaurHandler.DUNKLEOSTEUS, DinosaurHandler.EDMONTOSAURUS, DinosaurHandler.ELASMOTHERIUM, DinosaurHandler.HERRERASAURUS, DinosaurHandler.GIGANOTOSAURUS, DinosaurHandler.INDOMINUS, DinosaurHandler.HYAENODON, DinosaurHandler.INDORAPTOR, DinosaurHandler.DIMETRODON, DinosaurHandler.LUDODACTYLUS, DinosaurHandler.MAJUNGASAURUS, DinosaurHandler.LAMBEOSAURUS, DinosaurHandler.MAWSONIA, DinosaurHandler.MAMENCHISAURUS, DinosaurHandler.MAMMOTH, DinosaurHandler.PACHYCEPHALOSAURUS, DinosaurHandler.DILOPHOSAURUS, DinosaurHandler.METRIACANTHOSAURUS, DinosaurHandler.MEGATHERIUM, DinosaurHandler.MOSASAURUS, DinosaurHandler.PROTOCERATOPS, DinosaurHandler.PARASAUROLOPHUS, DinosaurHandler.POSTOSUCHUS, DinosaurHandler.PTERANODON, DinosaurHandler.SUCHOMIMUS, DinosaurHandler.STEGOSAURUS, DinosaurHandler.SMILODON, DinosaurHandler.STYRACOSAURUS, DinosaurHandler.SPINOSAURUS, DinosaurHandler.SPINORAPTOR, DinosaurHandler.SINOCERATOPS, DinosaurHandler.RAPHUSREX, DinosaurHandler.RUGOPS, DinosaurHandler.QUETZAL, DinosaurHandler.THERIZINOSAURUS, DinosaurHandler.TYLOSAURUS, DinosaurHandler.TROPEOGNATHUS, DinosaurHandler.TRICERATOPS, DinosaurHandler.TITANIS, DinosaurHandler.TROODON, DinosaurHandler.LIVYATAN, DinosaurHandler.DEINOSUCHUS, DinosaurHandler.MAIASAURA, DinosaurHandler.PARACERATHERIUM, DinosaurHandler.PATAGOTITAN);
    private static final String TAG_STAND = "Type";

    public FossilItem(Item.Properties properties, String type, boolean fresh, Dinosaur dino) {
        super(properties);
        this.type = type.toLowerCase(Locale.ENGLISH).replaceAll(" ", "_");
        this.fresh = fresh;
        this.dino = dino;
    }

    public static void init() {
        for (boolean fresh : new boolean[]{true, false}) {
            for (Dinosaur dinosaur : Dinosaur.DINOS) {
                String[] boneTypes;
                if (!fresh && dinosaur instanceof Hybrid) continue;
                Map<String, List<Dinosaur>> map = fresh ? freshFossilDinosaurs : fossilDinosaurs;
                for (String boneType : boneTypes = dinosaur.getBones()) {
                    List<Dinosaur> dinosaursWithType = map.get(boneType);
                    if (dinosaursWithType == null) {
                        dinosaursWithType = new ArrayList<Dinosaur>();
                    }
                    if (!dinosaur.getName().isEmpty() || dinosaur == Dinosaur.EMPTY) {
                        dinosaursWithType.add(dinosaur);
                    }
                    map.put(boneType, dinosaursWithType);
                }
            }
        }
    }

    @NotNull
    public Component m_7626_(@NotNull ItemStack pStack) {
        return LangUtil.replaceWithDinoName(this.dino, "item.JurassicReborn." + this.type + (this.isFresh() ? "_fresh" : ""));
    }

    @Nullable
    public Dinosaur getDinosaur(@NotNull ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof FossilItem) {
            FossilItem item2 = (FossilItem)item;
            return item2.dino;
        }
        return null;
    }

    public void m_7373_(ItemStack stack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        CompoundTag nbt = stack.m_41783_();
        if (nbt != null && nbt.m_128441_("Genetics") && nbt.m_128441_("DNAQuality")) {
            int quality = nbt.m_128451_("DNAQuality");
            ChatFormatting colour = quality > 75 ? ChatFormatting.GREEN : (quality > 50 ? ChatFormatting.YELLOW : (quality > 25 ? ChatFormatting.GOLD : ChatFormatting.RED));
            pTooltipComponents.add((Component)Component.m_237113_((String)Component.m_237115_((String)"lore.%s".formatted("dna_quality")).getString().replace("%1$s", LangUtil.getFormattedQuality(quality).getString())).m_130940_(colour));
            pTooltipComponents.add((Component)LangUtil.replaceInKey(() -> LangUtil.getFormattedGenetics(nbt.m_128461_("Genetics")).getString(), "%1$s", Component.m_237115_((String)"lore.%s".formatted("genetic_code")).getString()).m_130940_(ChatFormatting.BLUE));
        }
        if (this.type.equals("skull") && SKULL_DISPLAY_DINOS.contains(this.dino)) {
            pTooltipComponents.add((Component)Component.m_237113_((String)(Component.m_237115_((String)"pose.name").getString() + ": " + LangUtil.getStandType(FossilItem.getHasStand(stack)))).m_130940_(ChatFormatting.GOLD));
            pTooltipComponents.add((Component)Component.m_237115_((String)"lore.change_variant.name").m_130940_(ChatFormatting.WHITE));
        }
        super.m_7373_(stack, pLevel, pTooltipComponents, pIsAdvanced);
    }

    @Override
    public boolean isGrindable(ItemStack stack) {
        return true;
    }

    public boolean isFresh() {
        return this.fresh;
    }

    public String getBoneType() {
        return this.type;
    }

    @Override
    public ItemStack getGroundItem(ItemStack stack, Random random) {
        CompoundTag tag = stack.m_41783_();
        int outputType = random.nextInt(6);
        if (outputType == 5 || this.fresh) {
            ItemStack output = new ItemStack((ItemLike)ModItems.SOFT_TISSUE.get(this.getDinosaur(stack)).get());
            FossilGrinderBlockEntity.copyDNA(stack, output);
            return DinosaurItem.setDino(output, this.getDinosaur(stack));
        }
        if (outputType < 3) {
            return Items.f_42535_.m_7968_();
        }
        return new ItemStack((ItemLike)Items.f_42484_);
    }

    @Override
    public List<Pair<Float, ItemStack>> getChancedOutputs(ItemStack inputItem) {
        float single = 16.666666f;
        CompoundTag tag = inputItem.m_41783_();
        ItemStack output = new ItemStack((ItemLike)ModItems.SOFT_TISSUE.get(this.getDinosaur(inputItem)).get(), 1, tag);
        if (this.fresh) {
            return Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)Float.valueOf(100.0f), (Object)output)});
        }
        return Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)Float.valueOf(single), (Object)output), Pair.of((Object)Float.valueOf(50.0f), (Object)Items.f_42499_.m_7968_()), Pair.of((Object)Float.valueOf(single * 2.0f), (Object)new ItemStack((ItemLike)Items.f_42484_))});
    }

    public Map<String, List<Dinosaur>> getMap() {
        return this.fresh ? freshFossilDinosaurs : fossilDinosaurs;
    }

    public static boolean getHasStand(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        return tag == null || !tag.m_128441_(TAG_STAND) || tag.m_128471_(TAG_STAND);
    }

    public static void setHasStand(ItemStack stack, boolean hasStand) {
        stack.m_41784_().m_128379_(TAG_STAND, hasStand);
    }

    public static boolean changeStandType(ItemStack stack) {
        boolean newVal = !FossilItem.getHasStand(stack);
        FossilItem.setHasStand(stack, newVal);
        return newVal;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (player.m_6144_() && this.type.equals("skull") && SKULL_DISPLAY_DINOS.contains(this.dino)) {
            boolean oldVal = FossilItem.getHasStand(stack);
            boolean newVal = FossilItem.changeStandType(stack);
            if (level.f_46443_ && newVal != oldVal) {
                String msg = LangUtil.translate(LangUtil.STAND_CHANGE.get("type")).replace("{mode}", LangUtil.getStandType(newVal));
                player.m_5661_((Component)Component.m_237113_((String)msg).m_130940_(ChatFormatting.YELLOW), true);
            }
            return InteractionResultHolder.m_19092_((Object)stack, (boolean)level.f_46443_);
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    protected boolean canPlace(BlockPlaceContext ctx, BlockState state) {
        Player player = ctx.m_43723_();
        CollisionContext shape = player == null ? CollisionContext.m_82749_() : CollisionContext.m_82750_((Entity)player);
        return state.m_60710_((LevelReader)ctx.m_43725_(), ctx.m_8083_()) && ctx.m_43725_().m_45752_(state, ctx.m_8083_(), shape);
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        if (!this.type.equals("skull") || !SKULL_DISPLAY_DINOS.contains(this.dino)) {
            return InteractionResult.PASS;
        }
        Level level = context.m_43725_();
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockPos pos = context.m_8083_().m_121945_(context.m_43719_());
        BlockPlaceContext placeCtx = new BlockPlaceContext(context);
        Block block = (Block)ModBlocks.SKULL_DISPLAY.get();
        BlockState state = block.m_5573_(placeCtx);
        if (state == null) {
            return InteractionResult.FAIL;
        }
        if (!this.canPlace(placeCtx, state)) {
            return InteractionResult.FAIL;
        }
        level.m_7731_(pos, state, 3);
        block.m_6402_(level, pos, state, (LivingEntity)context.m_43723_(), stack);
        BlockEntity be = level.m_7702_(pos);
        if (be instanceof SkullDisplayBlockEntity) {
            SkullDisplayBlockEntity tile = (SkullDisplayBlockEntity)be;
            tile.setModel(DinosaurHandler.getId(this.dino), !this.isFresh(), FossilItem.getHasStand(stack));
            Direction face = context.m_43719_();
            if (face.m_122434_() == Direction.Axis.Y && context.m_43723_() != null) {
                tile.setAngle(FossilItem.angleToPlayer(pos, context.m_43723_().m_20185_(), context.m_43723_().m_20189_()));
            } else if (face.m_122434_() == Direction.Axis.X) {
                tile.setAngle((short)face.m_122435_());
            } else if (face.m_122434_() == Direction.Axis.Z) {
                tile.setAngle((short)(180.0f + face.m_122435_()));
            }
            tile.m_6596_();
        }
        level.m_46672_(pos, block);
        if (context.m_43723_() != null && !context.m_43723_().m_7500_()) {
            stack.m_41774_(1);
        }
        return InteractionResult.SUCCESS;
    }

    private static short angleToPlayer(BlockPos block, double playerX, double playerZ) {
        return (short)(90.0 - Math.toDegrees(Math.atan2((double)block.m_123343_() + 0.5 - playerZ, (double)block.m_123341_() + 0.5 - playerX)));
    }
}

