/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.items;

import com.google.gson.Gson;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.vit.jurassicreborn.client.screens.JournalGui;

public class JournalItem
extends Item {
    private final JournalType type;

    public JournalItem(JournalType type) {
        super(new Item.Properties().m_41487_(1));
        this.type = type;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        if (level.f_46443_) {
            this.openScreen();
        }
        return InteractionResultHolder.m_19090_((Object)player.m_21120_(hand));
    }

    @OnlyIn(value=Dist.CLIENT)
    private void openScreen() {
        Minecraft.m_91087_().m_91152_((Screen)new JournalGui(this.type));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)("journal." + this.type.getIdentifier().m_135815_() + ".name")));
    }

    public static enum JournalType {
        CHEF_ALEJANDRO(0, new ResourceLocation("jurassicreborn", "chef_alejandro")),
        DENNIS_NEDRY(1, new ResourceLocation("jurassicreborn", "dennis_nedry")),
        DR_GERRY_HARDING(2, new ResourceLocation("jurassicreborn", "dr_gerry_harding")),
        DR_HENRY_WU(3, new ResourceLocation("jurassicreborn", "dr_henry_wu")),
        DR_LAURA_SORKIN(4, new ResourceLocation("jurassicreborn", "dr_laura_sorkin")),
        ED_REGIS(5, new ResourceLocation("jurassicreborn", "ed_regis")),
        JOHN_HAMMOND(6, new ResourceLocation("jurassicreborn", "john_hammond")),
        RAY_ARNOLD(7, new ResourceLocation("jurassicreborn", "ray_arnold")),
        ROBERT_MULDOON(8, new ResourceLocation("jurassicreborn", "robert_muldoon"));

        public static final JournalType[] VALUES;
        private final int metadata;
        private final ResourceLocation identifier;
        private final ResourceLocation location;
        @OnlyIn(value=Dist.CLIENT)
        private Content content;

        private JournalType(int metadata, ResourceLocation identifier) {
            this.metadata = metadata;
            this.identifier = identifier;
            this.location = new ResourceLocation(identifier.m_135827_(), "journal_entries/" + identifier.m_135815_() + ".json");
        }

        public int getMetadata() {
            return this.metadata;
        }

        public ResourceLocation getIdentifier() {
            return this.identifier;
        }

        @OnlyIn(value=Dist.CLIENT)
        public Content getContent() {
            if (this.content == null) {
                try (InputStream in = ((Resource)Minecraft.m_91087_().m_91098_().m_213713_(this.location).get()).m_215507_();){
                    this.content = (Content)new Gson().fromJson((Reader)new InputStreamReader(in), Content.class);
                }
                catch (IOException e) {
                    String[][] fallback = new String[][]{{"Failed to load journal entries"}};
                    this.content = new Content("error", fallback);
                }
            }
            return this.content;
        }

        public static JournalType get(int meta) {
            if (meta >= 0 && meta < VALUES.length) {
                return VALUES[meta];
            }
            return CHEF_ALEJANDRO;
        }

        static {
            VALUES = JournalType.values();
        }
    }

    public static class Content {
        private final String identifier;
        private final String[][] entries;

        public Content(String identifier, String[][] entries) {
            this.identifier = identifier;
            this.entries = entries;
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public String[][] getEntries() {
            return this.entries;
        }
    }
}

