/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.items.guns;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.vit.jurassicreborn.common.entities.item.BulletEntity;
import net.vit.jurassicreborn.common.items.ModItems;

public class Gun
extends Item {
    private final int amountPerShot;
    private final float speed;
    private final float inaccuracy;
    private final float pitchOffset;
    private final SoundEvent fireSound;
    private final SoundEvent emptySound;
    private final SoundEvent reloadSound;
    private final int clipSize;
    private final int reloadCooldown;
    private final int shotCooldown;
    private final int damage;
    private static final String NBT_BULLET_KEY = "LoadedBullet";

    public Gun(int amountPerShot, SoundEvent emptySound, SoundEvent fireSound, SoundEvent reloadSound, int clipSize, int reloadCooldown, int shotCooldown, float speed, float inaccuracy, float pitchOffset, int damage) {
        super(new Item.Properties().m_41487_(1));
        this.amountPerShot = amountPerShot;
        this.emptySound = emptySound;
        this.fireSound = fireSound;
        this.reloadSound = reloadSound;
        this.clipSize = clipSize;
        this.reloadCooldown = reloadCooldown;
        this.shotCooldown = shotCooldown;
        this.speed = speed;
        this.inaccuracy = inaccuracy;
        this.pitchOffset = pitchOffset;
        this.damage = damage;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack gunStack = player.m_21120_(hand);
        if (player.m_36335_().m_41519_((Item)this)) {
            return InteractionResultHolder.m_19098_((Object)gunStack);
        }
        if (level.f_46443_) {
            return InteractionResultHolder.m_19090_((Object)gunStack);
        }
        ItemStack clip = this.getLoadedBullet(gunStack);
        if (clip.m_41619_()) {
            int toLoad;
            ItemStack invAmmo = this.findBulletInInventory(player);
            if (invAmmo.m_41619_() && !player.m_150110_().f_35937_) {
                Gun.play(level, player, this.emptySound, 1.0f, 1.0f);
                return InteractionResultHolder.m_19100_((Object)gunStack);
            }
            int n = toLoad = player.m_150110_().f_35937_ ? this.clipSize : Math.min(invAmmo.m_41613_(), this.clipSize);
            if (toLoad <= 0) {
                Gun.play(level, player, this.emptySound, 1.0f, 1.0f);
                return InteractionResultHolder.m_19100_((Object)gunStack);
            }
            ItemStack newClip = player.m_150110_().f_35937_ ? new ItemStack((ItemLike)ModItems.BULLET.get(), this.clipSize) : Gun.copyWithCount(invAmmo, toLoad);
            this.setLoadedBullet(gunStack, newClip);
            if (!player.m_150110_().f_35937_) {
                invAmmo.m_41774_(toLoad);
            }
            Gun.play(level, player, this.reloadSound, 1.0f, 1.0f);
            player.m_36335_().m_41524_((Item)this, this.reloadCooldown);
            return InteractionResultHolder.m_19090_((Object)gunStack);
        }
        for (int i = 0; i < this.amountPerShot; ++i) {
            this.shootBullet(player, level, hand, clip);
            if (player.m_150110_().f_35937_) continue;
            clip.m_41774_(1);
            if (clip.m_41619_()) break;
        }
        this.setLoadedBullet(gunStack, clip.m_41619_() ? ItemStack.f_41583_ : clip);
        Gun.play(level, player, this.fireSound, 1.0f, 1.0f);
        player.m_36335_().m_41524_((Item)this, this.shotCooldown);
        player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
        return InteractionResultHolder.m_19090_((Object)gunStack);
    }

    private void shootBullet(Player shooter, Level level, InteractionHand hand, ItemStack ammoStack) {
        BulletEntity bullet = new BulletEntity(level, (LivingEntity)shooter, ammoStack.m_41777_());
        bullet.m_5602_((Entity)shooter);
        bullet.setDamage(this.damage);
        bullet.m_20225_(true);
        bullet.m_20242_(true);
        Vec3 look = shooter.m_20252_(1.0f);
        Vec3 eye = shooter.m_20299_(1.0f);
        double spawnOffset = 0.5;
        bullet.m_7678_(eye.f_82479_ + look.f_82479_ * spawnOffset, eye.f_82480_ - 0.1 + look.f_82480_ * spawnOffset, eye.f_82481_ + look.f_82481_ * spawnOffset, shooter.m_146908_(), shooter.m_146909_());
        bullet.m_6686_(look.f_82479_, look.f_82480_, look.f_82481_, this.speed, this.inaccuracy);
        level.m_7967_((Entity)bullet);
    }

    private ItemStack findBulletInInventory(Player player) {
        for (ItemStack stack : player.m_150109_().f_35974_) {
            if (stack.m_41619_() || !stack.m_150930_((Item)ModItems.BULLET.get())) continue;
            return stack;
        }
        return ItemStack.f_41583_;
    }

    private ItemStack getLoadedBullet(ItemStack gun) {
        ItemStack stack;
        CompoundTag tag = gun.m_41783_();
        if (tag != null && tag.m_128441_(NBT_BULLET_KEY) && !(stack = ItemStack.m_41712_((CompoundTag)tag.m_128469_(NBT_BULLET_KEY))).m_41619_() && stack.m_150930_((Item)ModItems.BULLET.get())) {
            return stack;
        }
        return ItemStack.f_41583_;
    }

    private void setLoadedBullet(ItemStack gun, ItemStack bulletStack) {
        if (bulletStack.m_41619_()) {
            if (gun.m_41782_()) {
                CompoundTag t = gun.m_41783_();
                t.m_128473_(NBT_BULLET_KEY);
                if (t.m_128456_()) {
                    gun.m_41751_(null);
                }
            }
        } else {
            CompoundTag tag = gun.m_41784_();
            tag.m_128365_(NBT_BULLET_KEY, (Tag)bulletStack.m_41739_(new CompoundTag()));
        }
    }

    private static ItemStack copyWithCount(ItemStack src, int count) {
        ItemStack copy = src.m_41777_();
        copy.m_41764_(count);
        return copy;
    }

    private static void play(Level level, Player player, SoundEvent sound, float vol, float pitch) {
        if (sound != null) {
            level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), sound, SoundSource.PLAYERS, vol, pitch);
        }
    }
}

