/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.jei.dnaextractor;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.extensions.IRecipeCategoryExtension;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.RegistryObject;
import net.vit.jurassicreborn.common.entities.Dinosaurs.Dinosaur;
import net.vit.jurassicreborn.common.entities.Dinosaurs.DinosaurHandler;
import net.vit.jurassicreborn.common.genetics.DinoDNA;
import net.vit.jurassicreborn.common.genetics.GeneticsHelper;
import net.vit.jurassicreborn.common.genetics.PlantDNA;
import net.vit.jurassicreborn.common.items.Food.DinosaurMeatItem;
import net.vit.jurassicreborn.common.items.ModItems;
import net.vit.jurassicreborn.common.items.genetics.StorageDiscItem;
import net.vit.jurassicreborn.common.plants.Plant;
import net.vit.jurassicreborn.common.plants.PlantHandler;

public class DNAExtractorRecipeExtension
implements IRecipeCategoryExtension {
    private final ItemStack input;
    private final List<ItemStack> outputs = new ArrayList<ItemStack>();

    public DNAExtractorRecipeExtension(ItemStack input) {
        this.input = input;
        this.computeOutputs();
    }

    public static List<DNAExtractorRecipeExtension> createRecipes() {
        ArrayList<DNAExtractorRecipeExtension> list = new ArrayList<DNAExtractorRecipeExtension>();
        list.add(new DNAExtractorRecipeExtension(new ItemStack((ItemLike)ModItems.MOSQUITO_AMBER.get())));
        list.add(new DNAExtractorRecipeExtension(new ItemStack((ItemLike)ModItems.SEA_LAMPREY.get())));
        list.add(new DNAExtractorRecipeExtension(new ItemStack((ItemLike)ModItems.FROZEN_LEECH_ITEM.get())));
        list.add(new DNAExtractorRecipeExtension(new ItemStack((ItemLike)ModItems.APHID_AMBER.get())));
        for (Map.Entry<Dinosaur, RegistryObject<Item>> entry : ModItems.MEATS.entrySet()) {
            list.add(new DNAExtractorRecipeExtension(new ItemStack((ItemLike)entry.getValue().get())));
        }
        return list;
    }

    private void computeOutputs() {
        this.outputs.clear();
        RandomSource rand = RandomSource.m_216327_();
        if (this.input.m_150930_((Item)ModItems.MOSQUITO_AMBER.get()) || this.input.m_150930_((Item)ModItems.SEA_LAMPREY.get())) {
            if (this.input.m_41773_() == 0) {
                List<Dinosaur> dinos = this.input.m_150930_((Item)ModItems.MOSQUITO_AMBER.get()) ? DinosaurHandler.getDinosaursFromAmber() : DinosaurHandler.getMarineCreatures();
                for (Dinosaur dino : dinos) {
                    ItemStack disc = ((StorageDiscItem)ModItems.STORAGE_DISC.get()).m_7968_();
                    int quality = 50 + rand.m_188503_(50);
                    DinoDNA dna = new DinoDNA(dino, quality, GeneticsHelper.randomGenetics(rand));
                    CompoundTag nbt = new CompoundTag();
                    dna.writeToNBT(nbt);
                    disc.m_41751_(nbt);
                    StorageDiscItem.applyCustomModelData(disc);
                    this.outputs.add(disc);
                }
            } else if (this.input.m_41773_() == 1) {
                List<Plant> plants = PlantHandler.getPrehistoricPlantsAndTrees();
                for (Plant plant : plants) {
                    ItemStack disc = ((StorageDiscItem)ModItems.STORAGE_DISC.get()).m_7968_();
                    int quality = 50 + rand.m_188503_(50);
                    PlantDNA dna = new PlantDNA(PlantHandler.getPlantId(plant), quality);
                    CompoundTag tag = new CompoundTag();
                    dna.writeToNBT(tag);
                    disc.m_41751_(tag);
                    StorageDiscItem.applyCustomModelData(disc);
                    this.outputs.add(disc);
                }
            }
        } else if (this.input.m_150930_((Item)ModItems.MOSQUITO_AMBER.get()) || this.input.m_150930_((Item)ModItems.FROZEN_LEECH_ITEM.get())) {
            if (this.input.m_41773_() == 0) {
                List<Dinosaur> dinos = this.input.m_150930_((Item)ModItems.MOSQUITO_AMBER.get()) ? DinosaurHandler.getDinosaursFromAmber() : DinosaurHandler.getMammalCreatures();
                for (Dinosaur dino : dinos) {
                    ItemStack disc = ((StorageDiscItem)ModItems.STORAGE_DISC.get()).m_7968_();
                    int quality = 50 + rand.m_188503_(50);
                    DinoDNA dna = new DinoDNA(dino, quality, GeneticsHelper.randomGenetics(rand));
                    CompoundTag tag = new CompoundTag();
                    dna.writeToNBT(tag);
                    disc.m_41751_(tag);
                    StorageDiscItem.applyCustomModelData(disc);
                    this.outputs.add(disc);
                }
            }
        } else {
            Item dinos = this.input.m_41720_();
            if (dinos instanceof DinosaurMeatItem) {
                DinosaurMeatItem meat = (DinosaurMeatItem)dinos;
                Dinosaur dino = meat.getDinosaur();
                ItemStack disc = ((StorageDiscItem)ModItems.STORAGE_DISC.get()).m_7968_();
                DinoDNA dna = new DinoDNA(dino, 100, GeneticsHelper.randomGenetics(rand));
                CompoundTag tag = new CompoundTag();
                dna.writeToNBT(tag);
                disc.m_41751_(tag);
                StorageDiscItem.applyCustomModelData(disc);
                this.outputs.add(disc);
            }
        }
    }

    public void setRecipe(IRecipeLayoutBuilder builder, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 6, 4).addItemStack(this.input);
        builder.addSlot(RecipeIngredientRole.INPUT, 6, 25).addItemStack(((StorageDiscItem)ModItems.STORAGE_DISC.get()).m_7968_());
        IRecipeSlotBuilder slot = builder.addSlot(RecipeIngredientRole.OUTPUT, 59, 6);
        if (!this.outputs.isEmpty()) {
            slot.addItemStacks(this.outputs);
        }
    }
}

