/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.network;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;
import net.vit.jurassicreborn.common.entities.item.PaddockSignEntity;

public class PaddockSignPlacePacket {
    private final BlockPos pos;
    private final Direction face;
    private final InteractionHand hand;
    private final int dinosaurId;

    public PaddockSignPlacePacket(BlockPos pos, Direction face, InteractionHand hand, int dinosaurId) {
        this.pos = pos;
        this.face = face;
        this.hand = hand;
        this.dinosaurId = dinosaurId;
    }

    public static void encode(PaddockSignPlacePacket pkt, FriendlyByteBuf buf) {
        buf.m_130064_(pkt.pos);
        buf.m_130068_((Enum)pkt.face);
        buf.m_130068_((Enum)pkt.hand);
        buf.writeInt(pkt.dinosaurId);
    }

    public static PaddockSignPlacePacket decode(FriendlyByteBuf buf) {
        BlockPos pos = buf.m_130135_();
        Direction face = (Direction)buf.m_130066_(Direction.class);
        InteractionHand hand = (InteractionHand)buf.m_130066_(InteractionHand.class);
        int id = buf.readInt();
        return new PaddockSignPlacePacket(pos, face, hand, id);
    }

    public static void handle(PaddockSignPlacePacket pkt, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer sender = ((NetworkEvent.Context)ctx.get()).getSender();
            if (sender == null) {
                return;
            }
            Level world = sender.f_19853_;
            BlockPos spawnPos = pkt.pos.m_121945_(pkt.face);
            if (world.f_46443_) {
                return;
            }
            if (!world.m_8055_(spawnPos).m_60795_()) {
                return;
            }
            PaddockSignEntity sign = new PaddockSignEntity(world, pkt.pos, pkt.face, pkt.dinosaurId);
            world.m_7967_((Entity)sign);
            ItemStack held = sender.m_21120_(pkt.hand);
            if (!sender.m_150110_().f_35937_) {
                held.m_41774_(1);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

