/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.worldgen.tree.petrified;

import com.mojang.serialization.Codec;
import java.util.function.Predicate;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraftforge.registries.RegistryObject;
import net.vit.jurassicreborn.common.blocks.wood.WoodBlocks;
import net.vit.jurassicreborn.common.worldgen.tree.petrified.PetrifiedTreeConfig;

public class PetrifiedTreeGenerator
extends Feature<PetrifiedTreeConfig> {
    public PetrifiedTreeGenerator(Codec<PetrifiedTreeConfig> p_65786_) {
        super(p_65786_);
    }

    public boolean m_142674_(FeaturePlaceContext<PetrifiedTreeConfig> context) {
        RandomSource random = context.m_225041_();
        float chance = random.m_188501_();
        if (((PetrifiedTreeConfig)context.m_159778_()).chance >= chance) {
            WorldGenLevel world = context.m_159774_();
            BlockPos pos = context.m_159777_();
            int chunkX = world.m_46865_(pos).m_7697_().m_45604_();
            int chunkZ = world.m_46865_(pos).m_7697_().m_45605_();
            int randPosX = chunkX + random.m_188503_(16) + 8;
            int randPosZ = chunkZ + random.m_188503_(16) + 8;
            int surfaceY = world.m_6924_(Heightmap.Types.WORLD_SURFACE_WG, randPosX, randPosZ);
            int oceanFloorY = world.m_6924_(Heightmap.Types.OCEAN_FLOOR_WG, randPosX, randPosZ);
            int minY = 5;
            int maxY = Math.max(minY, surfaceY - 5);
            int randPosY = random.m_188503_(maxY - minY + 1) + minY;
            BlockPos targetPos = new BlockPos(randPosX, randPosY, randPosZ);
            if (world.m_8055_(targetPos).m_60795_() || !world.m_8055_(targetPos).m_60819_().m_76178_()) {
                return false;
            }
            this.generatePetrifiedTree(world, randPosX, randPosY, randPosZ, random, (PetrifiedTreeConfig)context.m_159778_());
            return world.m_8055_(pos).m_60734_() instanceof RotatedPillarBlock;
        }
        return false;
    }

    private void generatePetrifiedTree(WorldGenLevel world, int x, int y, int z, RandomSource rand, PetrifiedTreeConfig config) {
        Predicate<BlockState> predicate = state -> Feature.m_204735_((TagKey)BlockTags.f_144287_).test(state) || state.m_60795_();
        float rotX = (float)(rand.m_188500_() * 360.0);
        float rotY = (float)(rand.m_188500_() * 360.0) - 180.0f;
        Block log = (Block)((RegistryObject)Util.m_214621_(WoodBlocks.petrifiedLogs(), (RandomSource)rand)).get();
        BlockState state2 = log.m_49966_();
        float horizontal = Mth.m_14089_((float)(rotX * (float)Math.PI / 180.0f));
        float vertical = Mth.m_14031_((float)(rotX * (float)Math.PI / 180.0f));
        float xOffset = -Mth.m_14031_((float)(rotY * (float)Math.PI / 180.0f)) * horizontal;
        float yOffset = Mth.m_14089_((float)(rotY * (float)Math.PI / 180.0f)) * horizontal;
        for (int i = 0; i < rand.m_188503_(config.size) + 2; ++i) {
            BlockPos pos;
            int blockX = x + Math.round(xOffset * (float)i);
            int blockY = y + Math.round(vertical * (float)i);
            int blockZ = z + Math.round(yOffset * (float)i);
            if (blockY <= world.m_141937_() || blockY >= world.m_151558_() || !world.isAreaLoaded(pos = new BlockPos(blockX, blockY, blockZ), 20)) continue;
            this.m_159742_(world, pos, state2, predicate);
        }
    }
}

