/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.client.render.entity;

import com.github.alexthe666.citadel.client.model.TabulaModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.vit.jurassicreborn.common.entities.DinosaurEggEntity;
import net.vit.jurassicreborn.common.entities.Dinosaurs.Dinosaur;
import net.vit.jurassicreborn.common.legacy.tabula.TabulaModelHelper;

@OnlyIn(value=Dist.CLIENT)
public class DinosaurEggRenderer
extends EntityRenderer<DinosaurEggEntity> {
    private static TabulaModel DEFAULT_MODEL;
    private static ResourceLocation DEFAULT_TEXTURE;
    private final Map<Dinosaur, TabulaModel> modelCache = new HashMap<Dinosaur, TabulaModel>();

    public DinosaurEggRenderer(EntityRendererProvider.Context ctx) {
        super(ctx);
    }

    public void render(DinosaurEggEntity egg, float yaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int light) {
        poseStack.m_85836_();
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f - yaw));
        poseStack.m_85837_(0.0, -1.0, 0.0);
        TabulaModel model = this.getModel(egg);
        ResourceLocation texture = this.getTextureLocation(egg);
        VertexConsumer vertexConsumer = buffer.m_6299_(RenderType.m_110458_((ResourceLocation)texture));
        model.m_7695_(poseStack, vertexConsumer, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        poseStack.m_85849_();
        super.m_7392_((Entity)egg, yaw, partialTicks, poseStack, buffer, light);
    }

    public ResourceLocation getTextureLocation(DinosaurEggEntity egg) {
        Dinosaur dino = egg.getDinosaur();
        if (dino != null) {
            return new ResourceLocation("jurassicreborn", "textures/entities/egg/" + dino.getName().toLowerCase(Locale.ENGLISH) + ".png");
        }
        return DEFAULT_TEXTURE;
    }

    private TabulaModel getModel(DinosaurEggEntity egg) {
        Dinosaur dino = egg.getDinosaur();
        if (dino != null) {
            return this.modelCache.computeIfAbsent(dino, d -> {
                try {
                    return new TabulaModel(TabulaModelHelper.loadTabulaModel("/assets/jurassicreborn/models/entities/egg/" + d.getName().toLowerCase(Locale.ENGLISH)));
                }
                catch (Exception e) {
                    return DEFAULT_MODEL;
                }
            });
        }
        return DEFAULT_MODEL;
    }

    static {
        try {
            DEFAULT_MODEL = new TabulaModel(TabulaModelHelper.loadTabulaModel("/assets/jurassicreborn/models/entities/egg/tyrannosaurus"));
            DEFAULT_TEXTURE = new ResourceLocation("jurassicreborn", "textures/entities/egg/tyrannosaurus.png");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

