/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.client.screens;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.RegistryObject;
import net.vit.jurassicreborn.client.render.entity.animation.EntityAnimation;
import net.vit.jurassicreborn.common.entities.DinosaurEntity;
import net.vit.jurassicreborn.common.entities.Dinosaurs.Dinosaur;
import net.vit.jurassicreborn.common.entities.Dinosaurs.DinosaurHandler;
import net.vit.jurassicreborn.common.entities.EntityUtils.FoodType;

public class FieldGuideScreen
extends Screen {
    private final int imageWidth = 256;
    private final int imageHeight = 192;
    private int currentIndex = 0;
    private List<Dinosaur> dinosaurs;
    private static final ResourceLocation BOOK_TEXTURE = new ResourceLocation("jurassicreborn", "textures/field_guide/background.png");
    private static final ResourceLocation WIDGETS_TEXTURE = new ResourceLocation("jurassicreborn", "textures/journal/widgets.png");
    private final Map<Dinosaur, DinosaurEntity> skeletonCache = new HashMap<Dinosaur, DinosaurEntity>();

    public FieldGuideScreen() {
        super((Component)new TextComponent("InGen Field Guide"));
        this.dinosaurs = new ArrayList<Dinosaur>((Collection<Dinosaur>)Dinosaur.DINOSAUR_IDS.keySet());
        this.dinosaurs.sort((a, b) -> a.getName().compareToIgnoreCase(b.getName()));
    }

    protected void m_7856_() {
        super.m_7856_();
        int x = this.leftPos();
        int y = this.topPos();
        this.m_142416_((GuiEventListener)new ArrowButton(x - 3, y + 180, false, btn -> this.switchEntry(-1)));
        this.m_142416_((GuiEventListener)new ArrowButton(x + 235, y + 180, true, btn -> this.switchEntry(1)));
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(poseStack);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)BOOK_TEXTURE);
        this.m_93228_(poseStack, this.leftPos(), this.topPos(), 0, 0, 256, 192);
        super.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        if (this.currentIndex >= 0 && this.currentIndex < this.dinosaurs.size()) {
            FoodType type;
            Dinosaur dino = this.dinosaurs.get(this.currentIndex);
            int xLeft = this.leftPos() + 24;
            int y = this.topPos() + 20;
            int wrapWidth = 90;
            List nameLines = this.f_96547_.m_92923_((FormattedText)new TextComponent(this.currentIndex + 1 + ". " + dino.getName()), wrapWidth);
            for (int i = 0; i < nameLines.size(); ++i) {
                this.f_96547_.m_92877_(poseStack, (FormattedCharSequence)nameLines.get(i), (float)xLeft, (float)(y + i * 10), 0x3E3E3E);
            }
            this.f_96547_.m_92883_(poseStack, "Scientific Name:", (float)xLeft, (float)(y + 30), 0x3E3E3E);
            List sciLines = this.f_96547_.m_92923_((FormattedText)new TextComponent(dino.getScientificName()), wrapWidth);
            for (int i = 0; i < sciLines.size(); ++i) {
                this.f_96547_.m_92877_(poseStack, (FormattedCharSequence)sciLines.get(i), (float)(xLeft + 5), (float)(y + 40 + i * 10), 0x555555);
            }
            int offsetY = y + 15 + sciLines.size() * 10 + 5;
            List periodLines = this.f_96547_.m_92923_((FormattedText)new TextComponent("Period: " + dino.getPeriod()), wrapWidth);
            for (int i = 0; i < periodLines.size(); ++i) {
                this.f_96547_.m_92877_(poseStack, (FormattedCharSequence)periodLines.get(i), (float)xLeft, (float)(offsetY + 30 + i * 10), 0x3E3E3E);
            }
            List familyLines = this.f_96547_.m_92923_((FormattedText)new TextComponent("Family: " + dino.getFamily()), wrapWidth);
            for (int i = 0; i < familyLines.size(); ++i) {
                this.f_96547_.m_92877_(poseStack, (FormattedCharSequence)familyLines.get(i), (float)xLeft, (float)(offsetY + 50 + i * 10), 0x3E3E3E);
            }
            List locationLines = this.f_96547_.m_92923_((FormattedText)new TextComponent("Location: " + dino.getLocation()), wrapWidth);
            for (int i = 0; i < locationLines.size(); ++i) {
                this.f_96547_.m_92877_(poseStack, (FormattedCharSequence)locationLines.get(i), (float)xLeft, (float)(offsetY + 80 + i * 10), 0x3E3E3E);
            }
            Object diet = "Unknown";
            if (dino.getDiet() != null && !dino.getDiet().getModules().isEmpty() && (type = dino.getDiet().getModules().get(0).getFoodType()) != null) {
                diet = type.name().charAt(0) + type.name().substring(1).toLowerCase();
            }
            this.f_96547_.m_92883_(poseStack, "Diet: " + (String)diet, (float)xLeft, (float)(offsetY + 100), 0x3E3E3E);
            int skeletonX = this.leftPos() + 256 - 72;
            int skeletonY = this.topPos() + 192 - 55;
            int skeletonScale = 15;
            if (dino == DinosaurHandler.CAMARASAURUS || dino == DinosaurHandler.NIGERSAURUS || dino == DinosaurHandler.MAMENCHISAURUS || dino == DinosaurHandler.BRACHIOSAURUS || dino == DinosaurHandler.ANKYLODOCUS || dino == DinosaurHandler.DREADNOUGHTUS || dino == DinosaurHandler.GIGANOTOSAURUS || dino == DinosaurHandler.SPINOSAURUS || dino == DinosaurHandler.STEGOSAURUS || dino == DinosaurHandler.RAPHUSREX || dino == DinosaurHandler.APATOSAURUS || dino == DinosaurHandler.TYLOSAURUS || dino == DinosaurHandler.THERIZINOSAURUS || dino == DinosaurHandler.LAMBEOSAURUS || dino == DinosaurHandler.EDMONTOSAURUS || dino == DinosaurHandler.CORYTHOSAURUS || dino == DinosaurHandler.INDOMINUS || dino == DinosaurHandler.DIPLODOCUS) {
                skeletonScale = 5;
            }
            if (dino == DinosaurHandler.MOSASAURUS) {
                skeletonScale = 3;
            }
            if (dino == DinosaurHandler.ALLIGATOR_GAR || dino == DinosaurHandler.ALVAREZSAURUS || dino == DinosaurHandler.ASTEROCERAS || dino == DinosaurHandler.MEGALODON || dino == DinosaurHandler.BEELZEBUFO || dino == DinosaurHandler.DIMORPHODON || dino == DinosaurHandler.DODO || dino == DinosaurHandler.LEAELLYNASAURA || dino == DinosaurHandler.MEGAPIRANHA || dino == DinosaurHandler.PROTOCERATOPS || dino == DinosaurHandler.SEGISAURUS || dino == DinosaurHandler.TROODON || dino == DinosaurHandler.HYPSILOPHODON) {
                skeletonScale = 30;
            }
            if (dino == DinosaurHandler.DIPLOCAULUS || dino == DinosaurHandler.ALVAREZSAURUS || dino == DinosaurHandler.MICROCERATUS || dino == DinosaurHandler.MICRORAPTOR || dino == DinosaurHandler.OTHNIELIA || dino == DinosaurHandler.OVIRAPTOR) {
                skeletonScale = 30;
            }
            if (dino == DinosaurHandler.COMPSOGNATHUS) {
                skeletonScale = 70;
            }
            if (dino == DinosaurHandler.ALLOSAURUS || dino == DinosaurHandler.CARNOTAURUS || dino == DinosaurHandler.CERATOSAURUS || dino == DinosaurHandler.DEINOTHERIUM || dino == DinosaurHandler.DUNKLEOSTEUS || dino == DinosaurHandler.TYRANNOSAURUS || dino == DinosaurHandler.MAMMOTH || dino == DinosaurHandler.PARASAUROLOPHUS || dino == DinosaurHandler.QUETZAL || dino == DinosaurHandler.SUCHOMIMUS || dino == DinosaurHandler.PARACERATHERIUM) {
                skeletonScale = 10;
            }
            if (dino == DinosaurHandler.ANKYLOSAURUS || dino == DinosaurHandler.CARCHARODONTOSAURUS) {
                skeletonScale = 8;
            }
            if (dino == DinosaurHandler.SPINORAPTOR) {
                skeletonScale = 12;
            }
            this.renderSkeletonModel(poseStack, skeletonX, skeletonY, skeletonScale, dino);
        }
    }

    private void renderSkeletonModel(PoseStack stack, int x, int y, int scale, Dinosaur dino) {
        Minecraft mc = Minecraft.m_91087_();
        EntityRenderDispatcher dispatcher = mc.m_91290_();
        RegistryObject<? extends EntityType<? extends DinosaurEntity>> reg = DinosaurEntity.CLASS_TYPE_LIST.get(dino.getDinosaurClass());
        if (reg == null) {
            return;
        }
        DinosaurEntity entity = this.skeletonCache.computeIfAbsent(dino, key -> {
            DinosaurEntity e = (DinosaurEntity)((EntityType)reg.get()).m_20615_((Level)mc.f_91073_);
            if (e != null) {
                e.setAge(dino.getMaximumAge());
                e.setSkeleton(true);
                e.setSkeletonVariant((byte)0);
                e.setIsFossile(true);
                boolean hasMaleSkeleton = !dino.isHybrid;
                e.setIsFossile(hasMaleSkeleton);
                e.setupDisplay(hasMaleSkeleton);
                e.setAnimation(EntityAnimation.IDLE.get());
                e.m_21557_(true);
            }
            return e;
        });
        if (entity == null) {
            return;
        }
        entity.setAnimationTick(0);
        stack.m_85836_();
        stack.m_85837_((double)x, (double)y, 100.0);
        stack.m_85841_((float)(-scale), (float)scale, (float)scale);
        stack.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
        stack.m_85845_(Vector3f.f_122225_.m_122240_(-135.0f));
        stack.m_85845_(Vector3f.f_122223_.m_122240_(-10.0f));
        dispatcher.m_114468_(false);
        RenderSystem.m_69890_(() -> dispatcher.m_114384_((Entity)entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, stack, (MultiBufferSource)mc.m_91269_().m_110104_(), 0xF000F0));
        dispatcher.m_114468_(true);
        mc.m_91269_().m_110104_().m_109911_();
        stack.m_85849_();
    }

    private void switchEntry(int delta) {
        this.currentIndex = (this.currentIndex + delta + this.dinosaurs.size()) % this.dinosaurs.size();
    }

    private int leftPos() {
        return (this.f_96543_ - 256) / 2;
    }

    private int topPos() {
        return (this.f_96544_ - 192) / 2;
    }

    private class ArrowButton
    extends Button {
        private final boolean isForward;

        public ArrowButton(int x, int y, boolean isForward, Button.OnPress onPress) {
            super(x, y, 23, 13, TextComponent.f_131282_, onPress);
            this.isForward = isForward;
        }

        public void m_6303_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
            if (this.f_93624_) {
                RenderSystem.m_157456_((int)0, (ResourceLocation)WIDGETS_TEXTURE);
                int u = this.f_93622_ ? 23 : 0;
                int v = this.isForward ? 194 : 207;
                this.m_93228_(poseStack, this.f_93620_, this.f_93621_, u, v, this.f_93618_, this.f_93619_);
            }
        }
    }
}

