/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.client.screens.paleopad;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.resources.ResourceLocation;
import net.vit.jurassicreborn.client.screens.PaleoPadScreen;
import net.vit.jurassicreborn.client.screens.paleopad.GuiApp;
import net.vit.jurassicreborn.common.paleopad.App;
import net.vit.jurassicreborn.common.paleopad.FlappyDinoApp;

public class FlappyDinoGuiApp
extends GuiApp {
    private static final ResourceLocation TEXTURE = new ResourceLocation("jurassicreborn", "textures/gui/paleo_pad/apps/flappy_dino.png");
    private static final ResourceLocation LOGO = new ResourceLocation("jurassicreborn", "textures/gui/paleo_pad/apps/background/flappy_dino.png");
    private static final ResourceLocation PTERANODON = new ResourceLocation("jurassicreborn", "textures/gui/paleo_pad/apps/background/flappy_dino_pteranodon.png");
    private static final ResourceLocation[] CHARACTERS = new ResourceLocation[]{new ResourceLocation("jurassicreborn", "textures/gui/paleo_pad/apps/background/pteranodon_char.png"), new ResourceLocation("jurassicreborn", "textures/gui/paleo_pad/apps/background/dimorphodon_char.png"), new ResourceLocation("jurassicreborn", "textures/gui/paleo_pad/apps/background/cearadactylus_char.png"), new ResourceLocation("jurassicreborn", "textures/gui/paleo_pad/apps/background/quetzalcoatlus_char.png"), new ResourceLocation("jurassicreborn", "textures/gui/paleo_pad/apps/background/quetzalcoatlus_sad_char.png")};
    private static final String[] CHAR_NAMES = new String[]{"Pteranodon", "Dimorphodon", "Cearadactylus", "Quetzalcoatlus", "Colorful Quetzalcoatlus"};
    private ResourceLocation character;
    private int charIndex;
    private static final ResourceLocation PILLAR_BOTTOM = new ResourceLocation("jurassicreborn", "textures/gui/paleo_pad/apps/background/pillar_bottom.png");
    private static final ResourceLocation PILLAR_TOP = new ResourceLocation("jurassicreborn", "textures/gui/paleo_pad/apps/background/pillar_top.png");
    private static final ResourceLocation BACKGROUND = new ResourceLocation("jurassicreborn", "textures/gui/paleo_pad/apps/background/flappy_dino_background.png");
    private boolean mainScreen;
    private int x;
    private int y;
    private int motionY;
    private int score;
    private final Map<Integer, Integer> pillars = new HashMap<Integer, Integer>();

    public FlappyDinoGuiApp(App app) {
        super(app);
    }

    @Override
    public void render(PoseStack poseStack, int mouseX, int mouseY, Screen screen, float partialTicks) {
        this.renderButtons(poseStack, mouseX, mouseY, partialTicks);
        int left = screen.f_96543_ / 2 - 115;
        int top = 65;
        RenderSystem.m_157456_((int)0, (ResourceLocation)BACKGROUND);
        GuiComponent.m_93133_((PoseStack)poseStack, (int)left, (int)top, (float)0.0f, (float)0.0f, (int)229, (int)150, (int)229, (int)150);
        if (this.mainScreen) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)LOGO);
            GuiComponent.m_93133_((PoseStack)poseStack, (int)(left + 5), (int)(top + 5), (float)0.0f, (float)0.0f, (int)128, (int)64, (int)128, (int)64);
            RenderSystem.m_157456_((int)0, (ResourceLocation)PTERANODON);
            GuiComponent.m_93133_((PoseStack)poseStack, (int)(left + 145), (int)(top + 15), (float)0.0f, (float)0.0f, (int)128, (int)64, (int)128, (int)64);
            RenderSystem.m_157456_((int)0, (ResourceLocation)this.character);
            GuiComponent.m_93133_((PoseStack)poseStack, (int)(left + 10), (int)(top + 80), (float)0.0f, (float)0.0f, (int)32, (int)32, (int)32, (int)32);
            ((PaleoPadScreen)screen).drawScaledText(poseStack, "Character", left + 10, top + 75, 0.6f, 0xFFFFFF);
            ((PaleoPadScreen)screen).drawScaledText(poseStack, CHAR_NAMES[this.charIndex], left + 45, top + 90, 0.7f, 0xFFFFFF);
            ((PaleoPadScreen)screen).drawScaledText(poseStack, "Click to change", left + 10, top + 115, 0.6f, 0xFFFFFF);
            FlappyDinoApp fApp = (FlappyDinoApp)this.app;
            ((PaleoPadScreen)screen).drawScaledText(poseStack, "High Scores", left + 145, top + 80, 0.6f, 0xFFFFFF);
            int yOff = top + 90;
            int i = 1;
            for (int s : fApp.getScores()) {
                ((PaleoPadScreen)screen).drawScaledText(poseStack, i + ". " + s, left + 145, yOff, 0.6f, 0xFFFFFF);
                yOff += 10;
                if (i++ < 5) continue;
                break;
            }
            ((PaleoPadScreen)screen).drawScaledRect(poseStack, left + 90, top + 100, 50, 20, 1.0f, 0x545454);
            ((PaleoPadScreen)screen).drawScaledRect(poseStack, left + 91, top + 101, 48, 18, 1.0f, 0x747474);
            ((PaleoPadScreen)screen).drawScaledText(poseStack, "Play", left + 105, top + 107, 1.0f, 0xFFFFFF);
        } else {
            int drawX;
            RenderSystem.m_157456_((int)0, (ResourceLocation)this.character);
            GuiComponent.m_93133_((PoseStack)poseStack, (int)(left + 5), (int)(top + (150 - this.y)), (float)0.0f, (float)0.0f, (int)32, (int)32, (int)32, (int)32);
            RenderSystem.m_157456_((int)0, (ResourceLocation)PILLAR_BOTTOM);
            for (Map.Entry<Integer, Integer> entry : this.pillars.entrySet()) {
                drawX = entry.getKey() - this.x;
                if (drawX <= 0 || drawX >= 200) continue;
                for (int height = 0; height < entry.getValue(); ++height) {
                    GuiComponent.m_93133_((PoseStack)poseStack, (int)(left + drawX), (int)(top + 130 - height * 20), (float)0.0f, (float)12.0f, (int)32, (int)20, (int)32, (int)32);
                }
                GuiComponent.m_93133_((PoseStack)poseStack, (int)(left + drawX), (int)(top + 139 - entry.getValue() * 20), (float)0.0f, (float)0.0f, (int)32, (int)12, (int)32, (int)32);
            }
            RenderSystem.m_157456_((int)0, (ResourceLocation)PILLAR_TOP);
            for (Map.Entry<Integer, Integer> entry : this.pillars.entrySet()) {
                drawX = entry.getKey() - this.x;
                if (drawX <= 0 || drawX >= 200) continue;
                int totalHeight = 4 - entry.getValue();
                for (int height = 0; height < totalHeight; ++height) {
                    GuiComponent.m_93133_((PoseStack)poseStack, (int)(left + drawX), (int)(top + height * 20), (float)0.0f, (float)0.0f, (int)32, (int)20, (int)32, (int)32);
                }
                GuiComponent.m_93133_((PoseStack)poseStack, (int)(left + drawX), (int)(top + totalHeight * 20), (float)0.0f, (float)20.0f, (int)32, (int)12, (int)32, (int)32);
                if (!Minecraft.m_91087_().m_91290_().m_114377_()) continue;
                int topHeight = top + (4 - entry.getValue()) * 20 + 11;
                int bottomHeight = top + (150 - entry.getValue() * 20) - 11;
                int actualY = top + 150 - this.y;
                ((PaleoPadScreen)screen).drawScaledRect(poseStack, left + drawX + 1, topHeight, 30, 1, 1.0f, 0xFFFFFF);
                ((PaleoPadScreen)screen).drawScaledRect(poseStack, left + drawX + 1, bottomHeight, 30, 1, 1.0f, 0xFFFF00);
                ((PaleoPadScreen)screen).drawScaledRect(poseStack, left + 6, actualY + 5, 30, 1, 1.0f, 0xFF0000);
                ((PaleoPadScreen)screen).drawScaledRect(poseStack, left + 6, actualY + 23, 30, 1, 1.0f, 0xFF00FF);
            }
            ((PaleoPadScreen)screen).drawScaledText(poseStack, String.valueOf(this.score), left + 5, top + 5, 1.0f, 0xFFFFFF);
        }
    }

    @Override
    public void actionPerformed(Button button) {
    }

    @Override
    public void mouseClicked(double mouseX, double mouseY, Screen screen) {
        int left = screen.f_96543_ / 2 - 115;
        int top = 65;
        int relX = (int)mouseX - left;
        int relY = (int)mouseY - top;
        if (this.mainScreen) {
            if (relX > 10 && relX < 42 && relY > 80 && relY < 112) {
                this.charIndex = (this.charIndex + 1) % CHARACTERS.length;
                this.character = CHARACTERS[this.charIndex];
                ((FlappyDinoApp)this.app).setSelectedCharacter(this.charIndex);
            } else if (relX > 90 && relX < 140 && relY > 100 && relY < 120) {
                this.mainScreen = false;
            }
        } else {
            this.motionY = 6;
        }
    }

    @Override
    public void init() {
        this.x = 0;
        this.y = 150;
        this.motionY = 0;
        this.score = 0;
        this.pillars.clear();
        Random rand = new Random();
        for (int i = 0; i < 100; ++i) {
            this.pillars.put(i * 70 + 70, rand.nextInt(5));
        }
        FlappyDinoApp fApp = (FlappyDinoApp)this.app;
        this.charIndex = fApp.getSelectedCharacter();
        if (this.charIndex < 0 || this.charIndex >= CHARACTERS.length) {
            this.charIndex = 0;
        }
        this.character = CHARACTERS[this.charIndex];
        this.mainScreen = true;
    }

    @Override
    public void update() {
        if (!this.mainScreen && FlappyDinoGuiApp.mc.f_91074_ != null && FlappyDinoGuiApp.mc.f_91074_.f_19797_ % 2 == 0) {
            ++this.x;
            this.score = this.x / 70;
            if (this.y > 140) {
                this.y = 140;
            }
            if (this.motionY < -5) {
                this.motionY = -5;
            }
            this.y += this.motionY;
            --this.motionY;
            boolean died = false;
            for (Map.Entry<Integer, Integer> entry : this.pillars.entrySet()) {
                boolean collideY;
                int renderX = entry.getKey() - this.x;
                int height = entry.getValue();
                int bottomHeight = 150 - height * 20 - 11;
                int topHeight = (4 - height) * 20 + 11;
                int actualY = 150 - this.y;
                if (renderX <= 0 || renderX >= 200) continue;
                boolean collideX = renderX < 30;
                boolean bl = collideY = actualY + 5 < topHeight || actualY + 23 > bottomHeight;
                if (!collideX || !collideY) continue;
                died = true;
                break;
            }
            if (this.y < 20) {
                died = true;
            }
            if (died) {
                ((FlappyDinoApp)this.app).addScore(this.score);
                this.init();
            }
        }
    }

    @Override
    public ResourceLocation getTexture(Screen screen) {
        return TEXTURE;
    }
}

