/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.blocks;

import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.registries.RegistryObject;
import net.vit.jurassicreborn.common.items.misc.SwarmItem;

public class SwarmBlock
extends Block {
    public static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)0.5, (double)16.0);
    private RegistryObject<SwarmItem> item;

    public SwarmBlock(RegistryObject<SwarmItem> item, BlockBehaviour.Properties properties) {
        super(properties);
        this.item = item;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos below;
        BlockPos pos = context.m_8083_();
        Level level = context.m_43725_();
        BlockState stateBelow = level.m_8055_(below = pos.m_7495_());
        if (stateBelow.m_60734_() == Blocks.f_49990_ && stateBelow.m_60819_().m_76170_() && level.m_8055_(pos).m_60795_()) {
            return this.m_49966_();
        }
        return null;
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    public void onNeighborChange(BlockState state, LevelReader level, BlockPos pos, BlockPos neighbor) {
        super.onNeighborChange(state, level, pos, neighbor);
        this.checkForDrop((Level)level, pos, state);
    }

    public boolean m_7898_(BlockState pState, LevelReader world, BlockPos pPos) {
        BlockState stateBelow = world.m_8055_(pPos.m_7495_());
        return stateBelow.m_60734_() == Blocks.f_49990_ && stateBelow.m_60819_().m_76170_();
    }

    private boolean checkForDrop(Level world, BlockPos pos, BlockState state) {
        if (!this.m_7898_(state, (LevelReader)world, pos)) {
            world.m_7967_((Entity)new ItemEntity(world, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), new ItemStack((ItemLike)this.item.get())));
            world.m_7731_(pos, Blocks.f_50016_.m_49966_(), 1);
            return false;
        }
        return true;
    }

    public List<ItemStack> m_7381_(BlockState pState, LootContext.Builder pBuilder) {
        return this.getAddationalDrops(pState, super.m_7381_(pState, pBuilder));
    }

    public List<ItemStack> getAddationalDrops(BlockState state, List<ItemStack> originalDrops) {
        originalDrops.add(new ItemStack((ItemLike)this.item.get()));
        return originalDrops;
    }

    public void m_7455_(BlockState state, ServerLevel world, BlockPos pos, Random rand) {
        BlockPos spread;
        super.m_7455_(state, world, pos, rand);
        this.checkForDrop((Level)world, pos, state);
        if (rand.nextInt(10) == 0) {
            ItemEntity item = new ItemEntity((Level)world, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.8, (double)pos.m_123343_() + 0.5, new ItemStack((ItemLike)this.item.get()));
            item.m_20334_((double)((rand.nextFloat() - 0.5f) * 0.5f), (double)0.2f, (double)((rand.nextFloat() - 0.5f) * 0.5f));
            world.m_7967_((Entity)item);
        }
        if (rand.nextInt(8) == 0 && !(spread = pos.m_142082_(rand.nextInt(3) - 1, 0, rand.nextInt(3) - 1)).equals((Object)pos) && world.m_8055_(spread).m_60795_() && world.m_8055_(spread.m_7495_()).m_60734_() == Blocks.f_49990_) {
            world.m_7731_(spread, this.m_49966_(), 2);
        }
    }

    public Item m_5456_() {
        return (Item)this.item.get();
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        return new ItemStack((ItemLike)this.item.get());
    }
}

