/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.blocks.ancientplants;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.vit.jurassicreborn.common.blocks.ancientplants.AncientPlantBlock;

public class DoublePlantBlock
extends AncientPlantBlock {
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.f_61401_;

    public DoublePlantBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER));
    }

    public DoublePlantBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76302_).m_60988_());
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER));
    }

    @Override
    public boolean m_6724_(BlockState state) {
        return state.m_61143_(HALF) == DoubleBlockHalf.LOWER && super.m_6724_(state);
    }

    @Override
    protected void spread(ServerLevel level, BlockPos pos) {
        if (pos.m_123342_() >= level.m_151558_() - 1) {
            return;
        }
        BlockPos upperPos = pos.m_7494_();
        BlockState upperState = level.m_8055_(upperPos);
        if (!upperState.m_60795_() && !upperState.m_60767_().m_76336_()) {
            return;
        }
        DoublePlantBlock.placeAt((LevelAccessor)level, this.m_49966_(), pos, 3);
    }

    public BlockState m_7417_(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        DoubleBlockHalf doubleblockhalf = (DoubleBlockHalf)pState.m_61143_(HALF);
        if (pFacing.m_122434_() != Direction.Axis.Y || doubleblockhalf == DoubleBlockHalf.LOWER != (pFacing == Direction.UP) || pFacingState.m_60713_((Block)this) && pFacingState.m_61143_(HALF) != doubleblockhalf) {
            return doubleblockhalf == DoubleBlockHalf.LOWER && pFacing == Direction.DOWN && !pState.m_60710_((LevelReader)pLevel, pCurrentPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
        }
        return Blocks.f_50016_.m_49966_();
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        BlockPos blockpos = pContext.m_8083_();
        Level level = pContext.m_43725_();
        return blockpos.m_123342_() < level.m_151558_() - 1 && level.m_8055_(blockpos.m_7494_()).m_60629_(pContext) ? super.m_5573_(pContext) : null;
    }

    public void m_6402_(Level pLevel, BlockPos pPos, BlockState pState, LivingEntity pPlacer, ItemStack pStack) {
        BlockPos blockpos = pPos.m_7494_();
        pLevel.m_7731_(blockpos, DoublePlantBlock.copyWaterloggedFrom((LevelReader)pLevel, blockpos, (BlockState)this.m_49966_().m_61124_(HALF, (Comparable)DoubleBlockHalf.UPPER)), 3);
    }

    public boolean m_7898_(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        if (pState.m_61143_(HALF) != DoubleBlockHalf.UPPER) {
            return super.m_7898_(pState, pLevel, pPos);
        }
        BlockState blockstate = pLevel.m_8055_(pPos.m_7495_());
        if (pState.m_60734_() != this) {
            return super.m_7898_(pState, pLevel, pPos);
        }
        return blockstate.m_60713_((Block)this) && blockstate.m_61143_(HALF) == DoubleBlockHalf.LOWER;
    }

    public static void placeAt(LevelAccessor pLevel, BlockState pState, BlockPos pPos, int pFlags) {
        BlockPos blockpos = pPos.m_7494_();
        pLevel.m_7731_(pPos, DoublePlantBlock.copyWaterloggedFrom((LevelReader)pLevel, pPos, (BlockState)pState.m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER)), pFlags);
        pLevel.m_7731_(blockpos, DoublePlantBlock.copyWaterloggedFrom((LevelReader)pLevel, blockpos, (BlockState)pState.m_61124_(HALF, (Comparable)DoubleBlockHalf.UPPER)), pFlags);
    }

    public static BlockState copyWaterloggedFrom(LevelReader p_182454_, BlockPos p_182455_, BlockState p_182456_) {
        return p_182456_.m_61138_((Property)BlockStateProperties.f_61362_) ? (BlockState)p_182456_.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(p_182454_.m_46801_(p_182455_))) : p_182456_;
    }

    public void m_5707_(Level pLevel, BlockPos pPos, BlockState pState, Player pPlayer) {
        if (!pLevel.f_46443_) {
            if (pPlayer.m_7500_()) {
                DoublePlantBlock.preventCreativeDropFromBottomPart(pLevel, pPos, pState, pPlayer);
            } else {
                DoublePlantBlock.m_49881_((BlockState)pState, (Level)pLevel, (BlockPos)pPos, (BlockEntity)null, (Entity)pPlayer, (ItemStack)pPlayer.m_21205_());
            }
        }
        super.m_5707_(pLevel, pPos, pState, pPlayer);
    }

    public void m_6240_(Level pLevel, Player pPlayer, BlockPos pPos, BlockState pState, @Nullable BlockEntity pTe, ItemStack pStack) {
        super.m_6240_(pLevel, pPlayer, pPos, Blocks.f_50016_.m_49966_(), pTe, pStack);
    }

    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        if (!pState.m_60713_(pNewState.m_60734_())) {
            DoubleBlockHalf doubleblockhalf = (DoubleBlockHalf)pState.m_61143_(HALF);
            BlockPos blockpos = doubleblockhalf == DoubleBlockHalf.LOWER ? pPos.m_7494_() : pPos.m_7495_();
            BlockState blockstate = pLevel.m_8055_(blockpos);
            if (blockstate.m_60713_((Block)this) && blockstate.m_61143_(HALF) != doubleblockhalf) {
                pLevel.m_7731_(blockpos, Blocks.f_50016_.m_49966_(), 35);
                pLevel.m_46796_(2001, blockpos, Block.m_49956_((BlockState)blockstate));
            }
            super.m_6810_(pState, pLevel, pPos, pNewState, pIsMoving);
        } else {
            super.m_6810_(pState, pLevel, pPos, pNewState, pIsMoving);
        }
    }

    protected static void preventCreativeDropFromBottomPart(Level pLevel, BlockPos pPos, BlockState pState, Player pPlayer) {
        BlockPos blockpos;
        BlockState blockstate;
        DoubleBlockHalf doubleblockhalf = (DoubleBlockHalf)pState.m_61143_(HALF);
        if (doubleblockhalf == DoubleBlockHalf.UPPER && (blockstate = pLevel.m_8055_(blockpos = pPos.m_7495_())).m_60713_(pState.m_60734_()) && blockstate.m_61143_(HALF) == DoubleBlockHalf.LOWER) {
            BlockState blockstate1 = blockstate.m_61138_((Property)BlockStateProperties.f_61362_) && (Boolean)blockstate.m_61143_((Property)BlockStateProperties.f_61362_) != false ? Blocks.f_49990_.m_49966_() : Blocks.f_50016_.m_49966_();
            pLevel.m_7731_(blockpos, blockstate1, 35);
            pLevel.m_5898_(pPlayer, 2001, blockpos, Block.m_49956_((BlockState)blockstate));
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{HALF});
    }

    public BlockBehaviour.OffsetType m_5858_() {
        return BlockBehaviour.OffsetType.XZ;
    }

    public long m_7799_(BlockState pState, BlockPos pPos) {
        return Mth.m_14130_((int)pPos.m_123341_(), (int)pPos.m_6625_(pState.m_61143_(HALF) == DoubleBlockHalf.LOWER ? 0 : 1).m_123342_(), (int)pPos.m_123343_());
    }
}

