/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.blocks.entities.DNABlocks.DNASequencer;

import java.util.List;
import java.util.Objects;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.vit.jurassicreborn.common.blocks.entities.DNABlocks.DNASequencer.DNASequencerMenu;
import net.vit.jurassicreborn.common.blocks.entities.MachineBlockEntity;
import net.vit.jurassicreborn.common.blocks.entities.ModBlockEntities;
import net.vit.jurassicreborn.common.blocks.inventory.DNASequencerItemHandler;
import net.vit.jurassicreborn.common.blocks.inventory.ItemHandlerBlockEntity;
import net.vit.jurassicreborn.common.items.ModItems;
import net.vit.jurassicreborn.common.network.Network;
import net.vit.jurassicreborn.common.util.api.SequencableItem;
import org.jetbrains.annotations.NotNull;

public class DNASequencerBlockEntity
extends MachineBlockEntity
implements MenuProvider,
ItemHandlerBlockEntity {
    public static final int SLOTS = 9;
    public static final int[] INPUTS = new int[]{0, 1, 2, 3, 4, 5};
    public static final int[] INPUTS_PROCESS_1 = new int[]{0, 1};
    private static final int[] INPUTS_PROCESS_2 = new int[]{2, 3};
    private static final int[] INPUTS_PROCESS_3 = new int[]{4, 5};
    private static final int[] DISCS_INPUT = new int[]{1, 3, 5};
    public static final int[] DNA_INPUT = new int[]{0, 2, 4};
    public static final int[] OUTPUTS = new int[]{6, 7, 8};
    private int[] sequencingTime = new int[3];
    protected final DNASequencerItemHandler machineItemStackHandler = DNASequencerItemHandler.instance();
    private ContainerData sequencerData = new ContainerData(){

        public int m_6413_(int pIndex) {
            return DNASequencerBlockEntity.this.sequencingTime[pIndex];
        }

        public void m_8050_(int pIndex, int pValue) {
            DNASequencerBlockEntity.this.sequencingTime[pIndex] = pValue;
        }

        public int m_6499_() {
            return 3;
        }
    };

    @Override
    public IItemHandlerModifiable getItemHandler() {
        return this.machineItemStackHandler;
    }

    public DNASequencerBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.DNA_SEQUENCER_BLOCK_ENTITY.get(), pPos, pBlockState);
        Network.ENTITIES.add(this);
        this.machineItemStackHandler.setChangeListener(() -> {
            this.m_6596_();
            if (this.f_58857_ != null) {
                this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
            }
        });
    }

    @Override
    public Tag getMachineData() {
        CompoundTag machineData = new CompoundTag();
        machineData.m_128385_("SequencingTime", this.sequencingTime);
        return machineData;
    }

    @Override
    public void readMachineData(Tag data) {
        CompoundTag machineData = (CompoundTag)data;
        this.sequencingTime = machineData.m_128465_("SequencingTime");
    }

    @Override
    @NotNull
    protected Component getDefaultName() {
        return new TranslatableComponent("block.jurassicreborn.dna_sequencer");
    }

    public Component m_5446_() {
        return super.m_5446_();
    }

    @NotNull
    public AbstractContainerMenu m_7208_(int pContainerId, @NotNull Inventory pInventory, Player player) {
        return new DNASequencerMenu(pContainerId, this.machineItemStackHandler, this.sequencerData, pInventory);
    }

    @Override
    @NotNull
    public List<ItemStack> processItem(ItemStack ... inputs) {
        NonNullList outputs = NonNullList.m_122779_();
        ItemStack tissue = inputs[0];
        ItemStack disc = inputs[1];
        Random rand = Objects.requireNonNull(this.f_58857_).m_5822_();
        outputs.add((Object)SequencableItem.getSequencableItem(tissue).getSequenceOutput(tissue, rand));
        tissue.m_41774_(1);
        outputs.add((Object)tissue);
        disc.m_41774_(1);
        outputs.add((Object)disc);
        return outputs;
    }

    @Override
    public boolean canProcess(ItemStack ... inputs) {
        return !inputs[0].m_41619_() && inputs[0].m_41720_() instanceof SequencableItem && !inputs[1].m_41619_() && inputs[1].m_41720_() == ModItems.STORAGE_DISC.get() && inputs[2].m_41619_();
    }

    public ItemStack[] collectInputs(int ... flags) {
        return new ItemStack[]{this.getItem(flags[0]), this.getItem(flags[1]), this.getItem(flags[2])};
    }

    public static void tick(Level pLevel, BlockPos pPos, BlockState pState, DNASequencerBlockEntity pBlockEntity) {
        if (pLevel.f_46443_) {
            return;
        }
        for (int input = 0; input < DNA_INPUT.length; ++input) {
            int time = pBlockEntity.sequencingTime[input];
            int dna = DNA_INPUT[input];
            ItemStack[] processInputs = pBlockEntity.collectInputs(dna, dna + 1, OUTPUTS[input]);
            if (time >= 2000 && pBlockEntity.canProcess(processInputs)) {
                List<ItemStack> list = pBlockEntity.processItem(processInputs);
                pBlockEntity.mergeStack(OUTPUTS[input], list.get(0));
                pBlockEntity.setItem(dna, list.get(1));
                pBlockEntity.setItem(dna + 1, list.get(2));
                pBlockEntity.sequencingTime[input] = time = 0;
                processInputs = pBlockEntity.collectInputs(dna, dna + 1, OUTPUTS[input]);
            }
            pBlockEntity.sequencingTime[input] = !pBlockEntity.canProcess(processInputs) ? 0 : ++time;
        }
    }
}

