/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.blocks.entities.cultivator;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MilkBucketItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.vit.jurassicreborn.common.blocks.entities.MachineBlockEntity;
import net.vit.jurassicreborn.common.blocks.entities.ModBlockEntities;
import net.vit.jurassicreborn.common.blocks.entities.cultivator.CultivatorMenu;
import net.vit.jurassicreborn.common.blocks.inventory.CultivatorItemHandler;
import net.vit.jurassicreborn.common.blocks.inventory.FluidHandlerBlockEntity;
import net.vit.jurassicreborn.common.blocks.inventory.ItemHandlerBlockEntity;
import net.vit.jurassicreborn.common.blocks.inventory.SerializableSingleFluidTank;
import net.vit.jurassicreborn.common.entities.DinosaurEntity;
import net.vit.jurassicreborn.common.entities.Dinosaurs.Dinosaur;
import net.vit.jurassicreborn.common.genetics.DinoDNA;
import net.vit.jurassicreborn.common.genetics.GeneticsHelper;
import net.vit.jurassicreborn.common.items.ModItems;
import net.vit.jurassicreborn.common.items.genetics.HatchedEggItem;
import net.vit.jurassicreborn.common.items.genetics.SyringeItem;
import net.vit.jurassicreborn.common.util.block.TemperatureControl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CultivatorBlockEntity
extends MachineBlockEntity
implements MenuProvider,
TemperatureControl,
ItemHandlerBlockEntity,
FluidHandlerBlockEntity {
    public static final int[] INPUTS = new int[]{0, 1, 2, 3};
    public static final int[] OUTPUTS = new int[]{0, 3};
    public static final int MAX_NUTRIENTS = 3000;
    public static final int STACK_PROCESS_TIME = 2000;
    private final CultivatorItemHandler machineItemStackHandler = new CultivatorItemHandler(4, INPUTS, OUTPUTS);
    private final SerializableSingleFluidTank tank = new SerializableSingleFluidTank(2000, fs -> fs.getFluid() == Fluids.f_76193_);
    private int lipids;
    private int proximates;
    private int minerals;
    private int vitamins;
    private int temperature;
    private int processTime;
    private DinosaurEntity dinosaurEntity;
    private final ContainerData cultivatorBlockData = new ContainerData(){

        public int m_6413_(int i) {
            return switch (i) {
                case 0 -> CultivatorBlockEntity.this.tank.getFluid().getAmount();
                case 1 -> CultivatorBlockEntity.this.lipids;
                case 2 -> CultivatorBlockEntity.this.proximates;
                case 3 -> CultivatorBlockEntity.this.minerals;
                case 4 -> CultivatorBlockEntity.this.vitamins;
                case 5 -> CultivatorBlockEntity.this.temperature;
                case 6 -> CultivatorBlockEntity.this.processTime;
                case 7 -> CultivatorBlockEntity.this.f_58858_.m_123341_();
                case 8 -> CultivatorBlockEntity.this.f_58858_.m_123342_();
                case 9 -> CultivatorBlockEntity.this.f_58858_.m_123343_();
                default -> 0;
            };
        }

        public void m_8050_(int i, int v) {
            switch (i) {
                case 0: {
                    CultivatorBlockEntity.this.tank.getFluid().setAmount(v);
                    break;
                }
                case 1: {
                    CultivatorBlockEntity.this.lipids = v;
                    break;
                }
                case 2: {
                    CultivatorBlockEntity.this.proximates = v;
                    break;
                }
                case 3: {
                    CultivatorBlockEntity.this.minerals = v;
                    break;
                }
                case 4: {
                    CultivatorBlockEntity.this.vitamins = v;
                    break;
                }
                case 5: {
                    CultivatorBlockEntity.this.temperature = v;
                    break;
                }
                case 6: {
                    CultivatorBlockEntity.this.processTime = v;
                }
            }
            CultivatorBlockEntity.this.pushSync();
        }

        public BlockPos getBlockPos() {
            return new BlockPos(this.m_6413_(7), this.m_6413_(8), this.m_6413_(9));
        }

        public int m_6499_() {
            return 10;
        }
    };

    public CultivatorBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.CULTIVATOR_BLOCK_ENTITY_TYPE.get(), pos, state);
        this.machineItemStackHandler.setChangeListener(this::pushSync);
    }

    @Override
    public IFluidHandler getFluidHandler() {
        return this.tank;
    }

    @Override
    public IItemHandlerModifiable getItemHandler() {
        return this.machineItemStackHandler;
    }

    private void pushSync() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.m_6596_();
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public void handleUpdateTag(CompoundTag tag) {
        CompoundTag machineData;
        super.handleUpdateTag(tag);
        if (tag.m_128425_("MachineData", 10) && (machineData = tag.m_128469_("MachineData")).m_128425_("Data", 10)) {
            this.readMachineData((Tag)machineData.m_128469_("Data"));
        }
        if (this.f_58857_ != null && this.f_58857_.f_46443_) {
            if (this.processTime > 0) {
                this.getRenderEntity();
            } else {
                this.dinosaurEntity = null;
            }
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @Override
    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.handleUpdateTag(pkt.m_131708_());
    }

    @Override
    public Tag getMachineData() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("Lipids", this.lipids);
        tag.m_128405_("Minerals", this.minerals);
        tag.m_128405_("Vitamins", this.vitamins);
        tag.m_128405_("Proximates", this.proximates);
        tag.m_128405_("Temperature", this.temperature);
        tag.m_128405_("ProcessTime", this.processTime);
        return tag;
    }

    @Override
    public void readMachineData(Tag data) {
        if (!(data instanceof CompoundTag)) {
            return;
        }
        CompoundTag tag = (CompoundTag)data;
        this.lipids = tag.m_128451_("Lipids");
        this.proximates = tag.m_128451_("Proximates");
        this.minerals = tag.m_128451_("Minerals");
        this.vitamins = tag.m_128451_("Vitamins");
        this.temperature = tag.m_128451_("Temperature");
        this.processTime = tag.m_128451_("ProcessTime");
        if (this.processTime == 0) {
            this.dinosaurEntity = null;
        }
        this.m_6596_();
    }

    @Override
    public boolean canProcess(ItemStack ... inputs) {
        Item item;
        ItemStack syringe = inputs[0];
        if (syringe.m_41619_() || !((item = syringe.m_41720_()) instanceof SyringeItem)) {
            return false;
        }
        SyringeItem syringeItem = (SyringeItem)item;
        if (this.tank.getFluidAmount() < 1000) {
            return false;
        }
        Dinosaur dino = syringeItem.getDinosaur(syringe);
        if (dino == null) {
            return false;
        }
        return this.lipids >= dino.getLipids() && this.minerals >= dino.getMinerals() && this.proximates >= dino.getProximates() && this.vitamins >= dino.getVitamins();
    }

    @Override
    @NotNull
    public List<ItemStack> processItem(ItemStack ... inputs) {
        ItemStack syringe = inputs[0];
        Item item = syringe.m_41720_();
        if (!(item instanceof SyringeItem)) {
            return List.of(ItemStack.f_41583_);
        }
        SyringeItem syringeItem = (SyringeItem)item;
        Dinosaur dino = syringeItem.getDinosaur(syringe);
        if (dino == null) {
            return List.of(ItemStack.f_41583_);
        }
        ItemStack hatchedEgg = ((HatchedEggItem)((Object)ModItems.hatchedDinoEggs.get(dino).get())).m_7968_();
        CompoundTag nbt = new CompoundTag();
        nbt.m_128379_("Gender", this.temperature > 50);
        DinoDNA dna = DinoDNA.fromStack(syringe);
        if (dna == null) {
            dna = new DinoDNA(dino, 100, GeneticsHelper.randomGenetics(this.f_58857_.m_5822_()));
        }
        dna.writeToNBT(nbt);
        hatchedEgg.m_41751_(nbt);
        this.decrementResources(dino);
        return List.of(hatchedEgg);
    }

    private void decrementResources(Dinosaur dino) {
        this.lipids -= dino.getLipids();
        this.minerals -= dino.getMinerals();
        this.vitamins -= dino.getVitamins();
        this.proximates -= dino.getProximates();
        this.tank.getFluid().shrink(1000);
        this.pushSync();
    }

    @Override
    @NotNull
    protected Component getDefaultName() {
        return new TranslatableComponent("container.cultivator");
    }

    public Component m_5446_() {
        return super.m_5446_();
    }

    @NotNull
    public AbstractContainerMenu m_7208_(int id, @NotNull Inventory inv, Player player) {
        return new CultivatorMenu(id, this.machineItemStackHandler, this.cultivatorBlockData, inv);
    }

    public ItemStack[] collectInputs(int ... flags) {
        return new ItemStack[]{this.getItem(0), this.getItem(1), this.getItem(2), this.getItem(3)};
    }

    public static void tick(@NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull CultivatorBlockEntity be) {
        int filled;
        if (world.f_46443_) {
            return;
        }
        ItemStack foodItem = be.getItem(1);
        if (!(foodItem.m_41619_() || be.proximates >= 3000 && be.minerals >= 3000 && be.vitamins >= 3000 && be.lipids >= 3000)) {
            be.consumeNutrients();
        }
        ItemStack[] inputs = be.collectInputs(new int[0]);
        if (be.processTime >= 2000 && be.canProcess(inputs)) {
            ItemStack output = be.processItem(inputs).get(0);
            be.setItem(0, output);
            be.processTime = 0;
            be.dinosaurEntity = null;
            be.pushSync();
            inputs = be.collectInputs(new int[0]);
        }
        if (be.canProcess(inputs)) {
            if (be.processTime == 0) {
                be.getRenderEntity();
            }
            ++be.processTime;
            if (be.processTime == 1 || be.processTime % 20 == 0) {
                be.pushSync();
            }
        } else if (be.processTime != 0) {
            be.processTime = 0;
            be.dinosaurEntity = null;
            be.pushSync();
        }
        if (be.tank.getFluid().getAmount() < be.tank.getCapacity() && be.getItem(2).m_41720_() == Items.f_42447_ && (be.getItem(3).m_41613_() < be.getItem(3).m_41741_() || be.getItem(3).m_41619_()) && (filled = be.tank.fill(new FluidStack((Fluid)Fluids.f_76193_, 1000), IFluidHandler.FluidAction.EXECUTE)) > 0) {
            ItemStack bucket = be.getItem(2);
            bucket.m_41774_(1);
            be.setItem(2, bucket.m_41619_() ? ItemStack.f_41583_ : bucket);
            if (be.getItem(3).m_41619_()) {
                be.setItem(3, Items.f_42446_.m_7968_());
            } else {
                be.getItem(3).m_41769_(1);
            }
            be.pushSync();
        }
    }

    private void consumeNutrients() {
        if (this.f_58857_ == null) {
            return;
        }
        ItemStack foodStack = this.getItem(1);
        FoodNutrients nutrients = FoodNutrients.get(foodStack.m_41720_());
        if (nutrients == null) {
            return;
        }
        if (foodStack.m_41720_() instanceof MilkBucketItem) {
            this.setItem(1, new ItemStack((ItemLike)Items.f_42446_));
        } else {
            foodStack.m_41774_(1);
        }
        Random random = this.f_58857_.m_5822_();
        if (this.proximates < 3000) {
            this.proximates = Math.min((int)((double)this.proximates + (double)(800 + random.nextInt(201)) * nutrients.getProximate()), 3000);
        }
        if (this.minerals < 3000) {
            this.minerals = Math.min((int)((double)this.minerals + (double)(900 + random.nextInt(101)) * nutrients.getMinerals()), 3000);
        }
        if (this.vitamins < 3000) {
            this.vitamins = Math.min((int)((double)this.vitamins + (double)(900 + random.nextInt(101)) * nutrients.getVitamins()), 3000);
        }
        if (this.lipids < 3000) {
            this.lipids = Math.min((int)((double)this.lipids + (double)(980 + random.nextInt(101)) * nutrients.getLipids()), 3000);
        }
        this.pushSync();
    }

    @Nullable
    private DinosaurEntity createEntity() {
        SyringeItem item;
        block5: {
            block4: {
                Item item2 = this.getItem(0).m_41720_();
                if (!(item2 instanceof SyringeItem)) break block4;
                item = (SyringeItem)item2;
                if (this.f_58857_ != null) break block5;
            }
            return null;
        }
        this.dinosaurEntity = (DinosaurEntity)((EntityType)DinosaurEntity.CLASS_TYPE_LIST.get(item.getDinosaur(this.getItem(0)).getDinosaurClass()).get()).m_20615_(this.f_58857_);
        if (this.dinosaurEntity == null) {
            return null;
        }
        this.dinosaurEntity.setMale(this.temperature > 50);
        this.dinosaurEntity.setFullyGrown();
        this.dinosaurEntity.getLegacyAttributes().setScaleModifier(1.0f);
        return this.dinosaurEntity;
    }

    @Nullable
    public DinosaurEntity getRenderEntity() {
        if (!(this.dinosaurEntity != null || this.f_58857_ == null || this.f_58857_.f_46443_ && this.processTime <= 0)) {
            this.dinosaurEntity = this.createEntity();
        }
        return this.dinosaurEntity;
    }

    public boolean isProcessing() {
        return this.processTime > 0;
    }

    public int getProcessTime() {
        return this.processTime;
    }

    public int getMaxNutrients() {
        return 3000;
    }

    public int getProximates() {
        return this.proximates;
    }

    public int getMinerals() {
        return this.minerals;
    }

    public int getVitamins() {
        return this.vitamins;
    }

    public int getLipids() {
        return this.lipids;
    }

    @Override
    public void setTemperature(int index, int value) {
        if (index == 0) {
            this.temperature = value;
            this.pushSync();
        }
    }

    @Override
    public int getTemperature(int index) {
        return index == 0 ? this.temperature : -1;
    }

    @Override
    public int getTemperatureCount() {
        return 1;
    }

    static {
        FoodNutrients.register();
    }

    public static class FoodNutrients {
        public static final Map<Item, FoodNutrients> NUTRIENTS = new HashMap<Item, FoodNutrients>();
        private final double proximate;
        private final double minerals;
        private final double vitamins;
        private final double lipids;
        private final Item food;

        public FoodNutrients(Item food, double prox, double min, double vit, double lip) {
            this.food = food;
            this.proximate = prox;
            this.minerals = min;
            this.vitamins = vit;
            this.lipids = lip;
        }

        public static void register() {
            if (!NUTRIENTS.isEmpty()) {
                return;
            }
            FoodNutrients.register(Items.f_42410_, 0.06, 0.065, 0.1, 0.01);
            FoodNutrients.register(Items.f_42620_, 0.1, 0.2, 0.16, 0.02);
            FoodNutrients.register(Items.f_42406_, 0.3, 0.4, 0.43, 0.18);
            FoodNutrients.register(Items.f_42581_, 0.39, 0.35, 0.28, 0.45);
            FoodNutrients.register(Items.f_42582_, 0.49, 0.425, 0.335, 0.555);
            FoodNutrients.register(Items.f_42485_, 0.46, 0.31, 0.39, 0.38);
            FoodNutrients.register(Items.f_42486_, 0.58, 0.39, 0.49, 0.47);
            FoodNutrients.register(Items.f_42579_, 0.46, 0.31, 0.39, 0.38);
            FoodNutrients.register(Items.f_42579_, 0.46, 0.31, 0.39, 0.38);
            FoodNutrients.register(Items.f_42580_, 0.52, 0.33, 0.41, 0.4);
            FoodNutrients.register(Items.f_42526_, 0.48, 0.43, 0.14, 0.24);
            FoodNutrients.register(Items.f_42530_, 0.5, 0.45, 0.2, 0.28);
            FoodNutrients.register(Items.f_42527_, 0.48, 0.43, 0.14, 0.24);
            FoodNutrients.register(Items.f_42531_, 0.5, 0.45, 0.2, 0.28);
            FoodNutrients.register(Items.f_42528_, 0.48, 0.43, 0.14, 0.24);
            FoodNutrients.register(Items.f_42455_, 0.18, 0.26, 0.22, 0.6);
            FoodNutrients.register(Items.f_42521_, 0.05, 0.03, 0.05, 0.25);
            FoodNutrients.register(Items.f_42619_, 0.07, 0.17, 0.35, 0.01);
            FoodNutrients.register(Items.f_42501_, 0.2, 0.01, 0.01, 0.01);
            FoodNutrients.register(Items.f_42028_, 0.06, 0.06, 0.06, 0.01);
            FoodNutrients.register(Items.f_42405_, 0.1, 0.22, 0.1, 0.03);
            FoodNutrients.register(Items.f_42658_, 0.46, 0.31, 0.39, 0.38);
            FoodNutrients.register(Items.f_42659_, 0.58, 0.39, 0.49, 0.47);
            FoodNutrients.register(Items.f_42697_, 0.46, 0.31, 0.39, 0.38);
            FoodNutrients.register(Items.f_42698_, 0.58, 0.39, 0.49, 0.47);
            FoodNutrients.register((Item)ModItems.GOAT_RAW.get(), 0.46, 0.31, 0.39, 0.38);
            FoodNutrients.register((Item)ModItems.GOAT_COOKED.get(), 0.58, 0.39, 0.49, 0.47);
            FoodNutrients.register((Item)ModItems.CRAB_MEAT_RAW.get(), 0.26, 0.15, 0.29, 0.28);
            FoodNutrients.register((Item)ModItems.CRAB_MEAT_COOKED.get(), 0.48, 0.23, 0.39, 0.37);
            FoodNutrients.register((Item)ModItems.SHARK_MEAT_RAW.get(), 0.46, 0.31, 0.39, 0.38);
            FoodNutrients.register((Item)ModItems.SHARK_MEAT_COOKED.get(), 0.58, 0.39, 0.49, 0.47);
            ModItems.MEATS.forEach((dino, item) -> FoodNutrients.register((Item)item.get(), 0.46, 0.31, 0.39, 0.38));
            ModItems.STEAKS.forEach((dino, item) -> FoodNutrients.register((Item)item.get(), 0.58, 0.39, 0.49, 0.47));
        }

        public static void register(Item item, double prox, double min, double vit, double lip) {
            NUTRIENTS.put(item, new FoodNutrients(item, prox, min, vit, lip));
        }

        public static FoodNutrients get(Item item) {
            return NUTRIENTS.get(item);
        }

        public double getProximate() {
            return this.proximate;
        }

        public double getMinerals() {
            return this.minerals;
        }

        public double getVitamins() {
            return this.vitamins;
        }

        public double getLipids() {
            return this.lipids;
        }
    }
}

