/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.blocks.entities.fence;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.vit.jurassicreborn.common.blocks.entities.fence.ElectricFenceBaseBlockEntity;
import net.vit.jurassicreborn.common.blocks.entities.fence.ElectricFencePoleBlock;
import net.vit.jurassicreborn.common.blocks.entities.fence.ElectricFencePoleBlockEntity;
import net.vit.jurassicreborn.common.blocks.entities.fence.ElectricFenceWireBlock;
import net.vit.jurassicreborn.common.blocks.entities.fence.FenceType;
import org.jetbrains.annotations.Nullable;

public class ElectricFenceBaseBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty POLE = BooleanProperty.m_61465_((String)"pole");
    public static final BooleanProperty NORTH = BooleanProperty.m_61465_((String)"north");
    public static final BooleanProperty SOUTH = BooleanProperty.m_61465_((String)"south");
    public static final BooleanProperty WEST = BooleanProperty.m_61465_((String)"west");
    public static final BooleanProperty EAST = BooleanProperty.m_61465_((String)"east");
    public static final IntegerProperty CONNECTIONS = IntegerProperty.m_61631_((String)"connections", (int)0, (int)4);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final VoxelShape EXTENDED_BOUNDS = Shapes.m_83064_((AABB)new AABB(0.0, 0.0, 0.0, 1.0, 1.5, 1.0));
    private final FenceType type;

    public ElectricFenceBaseBlock(FenceType type) {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_).m_60918_(SoundType.f_56743_).m_60978_(3.5f).m_60955_());
        this.type = type;
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)POLE, (Comparable)Boolean.valueOf(false))).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)CONNECTIONS, (Comparable)Integer.valueOf(0))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new ElectricFenceBaseBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return null;
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        Direction bias = ctx.m_8125_().m_122427_();
        boolean water = ctx.m_43725_().m_6425_(ctx.m_8083_()).m_76152_() == Fluids.f_76193_;
        return this.updateConnections((LevelAccessor)ctx.m_43725_(), ctx.m_8083_(), (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)bias)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(water)));
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (!level.f_46443_) {
            level.m_7731_(pos, this.updateConnections((LevelAccessor)level, pos, state), 3);
        }
    }

    public BlockState m_7417_(BlockState state, Direction dir, BlockState neighbour, LevelAccessor world, BlockPos pos, BlockPos neighbourPos) {
        BlockState updated;
        Block block;
        if (!world.m_5776_() && dir == Direction.UP && (block = neighbour.m_60734_()) instanceof ElectricFencePoleBlock) {
            ElectricFencePoleBlock pole = (ElectricFencePoleBlock)block;
            if (world instanceof Level) {
                Level lvl = (Level)world;
                pole.updateConnectedWires(lvl, neighbourPos);
            }
        }
        if (((Boolean)(updated = this.updateConnections(world, pos, state)).m_61143_((Property)WATERLOGGED)).booleanValue()) {
            world.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)world));
        }
        return updated;
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean moved) {
        boolean fenceComponent;
        boolean powerChanged;
        super.m_6861_(state, level, pos, neighborBlock, neighborPos, moved);
        if (level.f_46443_) {
            return;
        }
        BlockPos polePos = pos.m_7494_();
        BlockState poleState = level.m_8055_(polePos);
        Block block = poleState.m_60734_();
        if (!(block instanceof ElectricFencePoleBlock)) {
            return;
        }
        ElectricFencePoleBlock pole = (ElectricFencePoleBlock)block;
        boolean wasPowered = (Boolean)poleState.m_61143_((Property)ElectricFencePoleBlock.ACTIVE);
        boolean isPowered = ElectricFencePoleBlock.hasPoweredBase((LevelAccessor)level, polePos, pole.getType());
        boolean bl = powerChanged = wasPowered != isPowered;
        if (powerChanged) {
            level.m_7731_(polePos, (BlockState)poleState.m_61124_((Property)ElectricFencePoleBlock.ACTIVE, (Comparable)Boolean.valueOf(isPowered)), 2);
            pole.updateConnectedWires(level, polePos, isPowered);
        }
        BlockEntity be = level.m_7702_(polePos);
        BlockState neighbourState = level.m_8055_(neighborPos);
        boolean bl2 = fenceComponent = neighbourState.m_60734_() instanceof ElectricFenceWireBlock || neighbourState.m_60734_() instanceof ElectricFencePoleBlock || neighbourState.m_60734_() instanceof ElectricFenceBaseBlock || neighborBlock instanceof ElectricFenceWireBlock || neighborBlock instanceof ElectricFencePoleBlock || neighborBlock instanceof ElectricFenceBaseBlock;
        if (be instanceof ElectricFencePoleBlockEntity) {
            ElectricFencePoleBlockEntity poleBe = (ElectricFencePoleBlockEntity)be;
            if (neighborPos.equals((Object)polePos) || fenceComponent) {
                poleBe.markNetworkDirty();
            }
        }
    }

    private BlockState updateConnections(LevelAccessor world, BlockPos pos, BlockState state) {
        boolean n = this.canConnect(world.m_8055_(pos.m_142127_()));
        boolean s = this.canConnect(world.m_8055_(pos.m_142128_()));
        boolean w = this.canConnect(world.m_8055_(pos.m_142125_()));
        boolean e = this.canConnect(world.m_8055_(pos.m_142126_()));
        int con = (n ? 1 : 0) + (s ? 1 : 0) + (w ? 1 : 0) + (e ? 1 : 0);
        boolean pole = world.m_8055_(pos.m_7494_()).m_60734_() instanceof ElectricFencePoleBlock;
        if (!pole && con == 0) {
            con = 1;
            switch ((Direction)state.m_61143_((Property)FACING)) {
                case NORTH: {
                    n = true;
                    break;
                }
                case SOUTH: {
                    s = true;
                    break;
                }
                case EAST: {
                    e = true;
                    break;
                }
                default: {
                    w = true;
                }
            }
        }
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(n))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(s))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(w))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(e))).m_61124_((Property)POLE, (Comparable)Boolean.valueOf(pole))).m_61124_((Property)CONNECTIONS, (Comparable)Integer.valueOf(con));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, POLE, NORTH, SOUTH, EAST, WEST, CONNECTIONS, WATERLOGGED});
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public boolean m_7420_(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    public void m_6240_(Level level, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity blockEntity, ItemStack stack) {
        if (!level.f_46443_) {
            Random rand = level.f_46441_;
            for (int i = 0; i < 8; ++i) {
                double dx = (double)pos.m_123341_() + 0.5 + (rand.nextDouble() - 0.5);
                double dy = (double)pos.m_123342_() + 0.5 + (rand.nextDouble() - 0.5);
                double dz = (double)pos.m_123343_() + 0.5 + (rand.nextDouble() - 0.5);
                level.m_7106_((ParticleOptions)ParticleTypes.f_175830_, dx, dy, dz, 0.0, 0.0, 0.0);
            }
        }
        super.m_6240_(level, player, pos, state, blockEntity, stack);
    }

    private boolean canConnect(BlockState st) {
        ElectricFenceBaseBlock b;
        Block block = st.m_60734_();
        return block instanceof ElectricFenceBaseBlock && (b = (ElectricFenceBaseBlock)block).getType() == this.type;
    }

    public FenceType getType() {
        return this.type;
    }
}

