/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.blocks.entities.trashcan;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;
import net.vit.jurassicreborn.common.blocks.entities.trashcan.TrashCanMenu;

public class TrashCanBlock
extends Block {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    private static final VoxelShape SHAPE = TrashCanBlock.loadShape();

    public TrashCanBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60978_(3.0f).m_60955_().m_60918_(SoundType.f_56743_).m_60999_());
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    private static VoxelShape loadShape() {
        VoxelShape shape = Shapes.m_83040_();
        try (InputStream stream = TrashCanBlock.class.getResourceAsStream("/assets/jurassicreborn/models/block/trash_can.json");){
            if (stream != null) {
                JsonObject json = JsonParser.parseReader((Reader)new InputStreamReader(stream)).getAsJsonObject();
                JsonArray elements = json.getAsJsonArray("elements");
                for (JsonElement element : elements) {
                    String name;
                    JsonObject obj = element.getAsJsonObject();
                    String string = name = obj.has("name") ? obj.get("name").getAsString() : "";
                    if (name.startsWith("inner")) continue;
                    JsonArray from = obj.getAsJsonArray("from");
                    JsonArray to = obj.getAsJsonArray("to");
                    shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Block.m_49796_((double)from.get(0).getAsDouble(), (double)from.get(1).getAsDouble(), (double)from.get(2).getAsDouble(), (double)to.get(0).getAsDouble(), (double)to.get(1).getAsDouble(), (double)to.get(2).getAsDouble()));
                }
            }
        }
        catch (IOException e) {
            shape = Shapes.m_83144_();
        }
        return shape;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!level.f_46443_ && player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            SimpleMenuProvider provider = new SimpleMenuProvider((id, inv, p) -> new TrashCanMenu(id, inv), (Component)new TranslatableComponent("container.trash_can"));
            NetworkHooks.openGui((ServerPlayer)sp, (MenuProvider)provider, (BlockPos)pos);
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }
}

