/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.vit.jurassicreborn.client.render.entity.animation.EntityAnimation;
import net.vit.jurassicreborn.common.entities.EntityUtils.Animatable;

public class ForceAnimationCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"animate").requires(cs -> cs.m_6761_(2))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"anim", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests((ctx, builder) -> {
            for (EntityAnimation anim : EntityAnimation.values()) {
                builder.suggest(anim.name().toLowerCase(Locale.ROOT));
            }
            return builder.buildFuture();
        }).executes(ctx -> ForceAnimationCommand.run((CommandContext<CommandSourceStack>)ctx, Collections.singleton(ForceAnimationCommand.getSourceEntity((CommandContext<CommandSourceStack>)ctx))))).then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91460_()).executes(ctx -> ForceAnimationCommand.run((CommandContext<CommandSourceStack>)ctx, EntityArgument.m_91461_((CommandContext)ctx, (String)"targets"))))));
    }

    private static Entity getSourceEntity(CommandContext<CommandSourceStack> ctx) {
        Entity entity = ((CommandSourceStack)ctx.getSource()).m_81373_();
        if (entity == null) {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)new TextComponent("No entity was provided"));
        }
        return entity;
    }

    private static int run(CommandContext<CommandSourceStack> ctx, Collection<? extends Entity> targets) {
        EntityAnimation anim;
        if (targets == null || targets.isEmpty()) {
            return 0;
        }
        ResourceLocation id = ResourceLocationArgument.m_107011_(ctx, (String)"anim");
        String animKey = id.m_135815_();
        try {
            anim = EntityAnimation.valueOf(animKey.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException ex) {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)new TextComponent("Unknown animation: " + animKey));
            return 0;
        }
        int played = 0;
        for (Entity entity : targets) {
            if (!(entity instanceof Animatable)) continue;
            Animatable a = (Animatable)entity;
            a.setAnimation(anim.get());
            ++played;
        }
        if (played == 0) {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)new TextComponent("No animatable entities found"));
            return 0;
        }
        ((CommandSourceStack)ctx.getSource()).m_81354_((Component)new TextComponent("Played " + animKey + " on " + played + " entities"), true);
        return played;
    }
}

