/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.entities;

import java.util.EnumSet;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.vit.jurassicreborn.common.entities.DinosaurEntity;
import net.vit.jurassicreborn.common.entities.Dinosaurs.Dinosaur;
import net.vit.jurassicreborn.common.entities.ai.navigation.DinosaurMoveHelper;
import net.vit.jurassicreborn.common.entities.ai.navigation.DinosaurPathNavigate;
import org.jetbrains.annotations.Nullable;

public abstract class AmphibianDinosaurEntity
extends DinosaurEntity {
    private boolean getOut = false;
    private boolean getInWater = false;
    private boolean blocked;
    protected final PathNavigation navigationSwimmer;
    protected final PathNavigation navigationLand;
    private final SmoothSwimmingMoveControl waterMoveControl = new SmoothSwimmingMoveControl((Mob)this, 85, 10, 0.02f, 0.1f, true);
    private final SmoothSwimmingLookControl waterLookControl = new SmoothSwimmingLookControl((Mob)this, 10);
    private final DinosaurMoveHelper landMoveControl;
    private final LookControl landLookControl;
    private int waterTicks;
    private int landTicks;
    private int mediumSwitchCooldown = 0;
    private static final int MEDIUM_SWITCH_CD = 10;

    public AmphibianDinosaurEntity(Level world, EntityType type, Dinosaur dino) {
        super(world, (EntityType<? extends DinosaurEntity>)type, dino);
        this.navigationSwimmer = new WaterBoundPathNavigation((Mob)this, world);
        this.landMoveControl = new DinosaurMoveHelper(this);
        this.landLookControl = new LookControl((Mob)this);
        this.navigationLand = new DinosaurPathNavigate(this, world);
        this.navigationLand.m_7008_(true);
        this.f_21342_ = this.landMoveControl;
        this.f_21365_ = this.landLookControl;
        this.f_21344_ = this.navigationLand;
        this.blocked = false;
        this.f_21345_.m_25352_(5, (Goal)new MoveUnderwaterGoal());
        this.f_21345_.m_25352_(10, (Goal)new FindWaterGoal());
        this.f_21345_.m_25352_(10, (Goal)new WanderGoal());
    }

    @Override
    public boolean isMovementBlocked() {
        return this.isCarcass() || this.m_5803_() || this.blocked;
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (this.mediumSwitchCooldown > 0) {
            --this.mediumSwitchCooldown;
        }
        if (!this.f_19853_.f_46443_ && this.m_6084_()) {
            boolean inWaterNow = this.m_20069_();
            if (inWaterNow) {
                ++this.waterTicks;
                this.landTicks = 0;
                this.m_20301_(300);
                this.getOut = this.waterTicks > 200;
                this.getInWater = false;
                if (this.mediumSwitchCooldown == 0 && !(this.f_21344_ instanceof WaterBoundPathNavigation)) {
                    this.f_21344_ = this.navigationSwimmer;
                    this.mediumSwitchCooldown = 10;
                }
            } else {
                ++this.landTicks;
                this.waterTicks = 0;
                int air = this.m_20146_() - 1;
                this.m_20301_(air);
                if (air <= -20) {
                    this.m_20301_(0);
                    this.m_6469_(DamageSource.f_19312_, 2.0f);
                }
                this.getInWater = air < 40;
                this.getOut = false;
                if (this.mediumSwitchCooldown == 0 && !(this.f_21344_ instanceof GroundPathNavigation)) {
                    this.f_21344_ = this.navigationLand;
                    this.mediumSwitchCooldown = 10;
                }
            }
        }
        if (this.m_20069_()) {
            if (this.f_21342_ != this.waterMoveControl && this.mediumSwitchCooldown == 0) {
                this.f_21342_ = this.waterMoveControl;
                this.f_21365_ = this.waterLookControl;
            }
        } else if (this.f_21342_ != this.landMoveControl && this.mediumSwitchCooldown == 0) {
            this.f_21342_ = this.landMoveControl;
            this.f_21365_ = this.landLookControl;
        }
    }

    @Override
    public void m_7023_(Vec3 vec) {
        boolean noInput;
        float strafe = (float)vec.f_82479_;
        float vertical = (float)vec.f_82480_;
        float forward = (float)vec.f_82481_;
        boolean bl = noInput = strafe == 0.0f && vertical == 0.0f && forward == 0.0f;
        if (!this.f_19853_.f_46443_ && this.m_20069_() && !this.isCarcass()) {
            this.m_19920_(0.1f, new Vec3((double)strafe, (double)vertical, (double)forward));
            this.m_6478_(MoverType.SELF, this.m_20184_());
            Vec3 movement = this.m_20184_().m_82542_(0.7, 0.7, 0.7);
            if (noInput) {
                movement = movement.m_82520_(0.0, -0.005, 0.0);
            }
            this.m_20256_(movement);
        } else {
            super.m_7023_(vec);
        }
    }

    class MoveUnderwaterGoal
    extends Goal {
        private double x;
        private double y;
        private double z;
        private int retryCd = 0;
        private static final int TRY_EVERY = 20;

        public MoveUnderwaterGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            Vec3 target;
            if (this.retryCd > 0) {
                --this.retryCd;
                return false;
            }
            Random rng = AmphibianDinosaurEntity.this.m_21187_();
            if (AmphibianDinosaurEntity.this.m_5448_() != null) {
                return false;
            }
            if (rng.nextFloat() < 0.5f && AmphibianDinosaurEntity.this.isBusy()) {
                return false;
            }
            Vec3 vec3 = target = AmphibianDinosaurEntity.this.getOut ? this.getRandomLandPos((Mob)AmphibianDinosaurEntity.this, 6, 6) : this.getRandomWaterPos((Mob)AmphibianDinosaurEntity.this, 6, 6);
            if (target == null) {
                this.retryCd = 20;
                return false;
            }
            this.x = target.f_82479_;
            this.y = target.f_82480_;
            this.z = target.f_82481_;
            return true;
        }

        public boolean m_8045_() {
            if (AmphibianDinosaurEntity.this.m_5448_() != null) {
                return false;
            }
            return !AmphibianDinosaurEntity.this.m_21573_().m_26571_();
        }

        public void m_8056_() {
            boolean foundPath = AmphibianDinosaurEntity.this.m_21573_().m_26519_(this.x, this.y, this.z, 1.0);
            if (!foundPath) {
                AmphibianDinosaurEntity.this.m_21566_().m_6849_(this.x, this.y, this.z, 1.0);
            }
            this.retryCd = 20;
        }

        public boolean m_6767_() {
            return true;
        }

        @Nullable
        private Vec3 getRandomWaterPos(Mob mob, int hr, int vr) {
            for (int i = 0; i < 8; ++i) {
                double z;
                double y;
                double x = mob.m_20185_() + (double)mob.m_21187_().nextInt(hr * 2 + 1) - (double)hr;
                BlockPos pos = new BlockPos(x, y = mob.m_20186_() + (double)mob.m_21187_().nextInt(vr * 2 + 1) - (double)vr, z = mob.m_20189_() + (double)mob.m_21187_().nextInt(hr * 2 + 1) - (double)hr);
                if (!mob.f_19853_.m_8055_(pos).m_60767_().m_76332_()) continue;
                return new Vec3(x, y, z);
            }
            return null;
        }

        @Nullable
        private Vec3 getRandomLandPos(Mob mob, int hr, int vr) {
            for (int i = 0; i < 8; ++i) {
                BlockPos below;
                BlockState stateBelow;
                double x = mob.m_20185_() + (double)mob.m_21187_().nextInt(hr * 2 + 1) - (double)hr;
                double y = mob.m_20186_() + (double)mob.m_21187_().nextInt(vr * 2 + 1) - (double)vr;
                double z = mob.m_20189_() + (double)mob.m_21187_().nextInt(hr * 2 + 1) - (double)hr;
                BlockPos pos = new BlockPos(x, y, z);
                BlockState stateAtPos = mob.f_19853_.m_8055_(pos);
                if (!mob.f_19853_.m_46859_(pos) && !stateAtPos.m_60812_((BlockGetter)mob.f_19853_, pos).m_83281_() || !(stateBelow = mob.f_19853_.m_8055_(below = pos.m_7495_())).m_60767_().m_76333_() || !stateAtPos.m_60819_().m_76178_()) continue;
                return Vec3.m_82539_((Vec3i)pos);
            }
            return null;
        }
    }

    class FindWaterGoal
    extends Goal {
        private int cd = 0;

        public FindWaterGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            if (this.cd > 0) {
                --this.cd;
                return false;
            }
            return false;
        }
    }

    class WanderGoal
    extends RandomStrollGoal {
        public WanderGoal() {
            super((PathfinderMob)AmphibianDinosaurEntity.this, 1.0, 10);
        }

        public boolean m_8036_() {
            if (AmphibianDinosaurEntity.this.getInWater) {
                return false;
            }
            return !AmphibianDinosaurEntity.this.m_20069_() && super.m_8036_();
        }
    }
}

